/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.text.Position;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.Index;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class TreePathHandle {
    private final Delegate delegate;

    private TreePathHandle(Delegate delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    public FileObject getFileObject() {
        return this.delegate.getFileObject();
    }

    public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
        TreePath treePath = this.delegate.resolve(compilationInfo);
        if (treePath == null) {
            Logger.getLogger(TreePathHandle.class.getName()).info("Cannot resolve: " + this.toString());
        }
        return treePath;
    }

    public boolean equals(Object object) {
        if (object == null && !(object instanceof TreePathHandle)) {
            return false;
        }
        if (this.delegate.getClass() != ((TreePathHandle)object).delegate.getClass()) {
            return false;
        }
        return this.delegate.equalsHandle(((TreePathHandle)object).delegate);
    }

    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    public Element resolveElement(CompilationInfo compilationInfo) {
        Parameters.notNull((CharSequence)"info", (Object)compilationInfo);
        Element element = this.delegate.resolveElement(compilationInfo);
        if (element == null) {
            Logger.getLogger(TreePathHandle.class.getName()).info("Cannot resolve: " + this.toString());
        }
        return element;
    }

    public Tree.Kind getKind() {
        return this.delegate.getKind();
    }

    public static TreePathHandle create(TreePath treePath, CompilationInfo compilationInfo) throws IllegalArgumentException {
        Element element;
        FileObject fileObject;
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"info", (Object)compilationInfo);
        try {
            URL uRL = treePath.getCompilationUnit().getSourceFile().toUri().toURL();
            fileObject = URLMapper.findFileObject((URL)uRL);
            assert (fileObject != null) : "Cannot find FileObject for: " + uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw (RuntimeException)new RuntimeException().initCause(malformedURLException);
        }
        int n = ((JCTree)treePath.getLeaf()).pos;
        PositionRef positionRef = TreePathHandle.createPositionRef(fileObject, n, Position.Bias.Forward);
        TreePath treePath2 = treePath;
        boolean bl = true;
        do {
            element = compilationInfo.getTrees().getElement(treePath2);
            treePath2 = treePath2.getParentPath();
            if (element == null || TreePathHandle.isSupported(element)) continue;
            bl = false;
        } while ((element == null || !TreePathHandle.isSupported(element)) && treePath2 != null);
        return new TreePathHandle(new TreeDelegate(positionRef, new TreeDelegate.KindPath(treePath), fileObject, ElementHandle.create(element), bl));
    }

    public static TreePathHandle create(Element element, CompilationInfo compilationInfo) throws IllegalArgumentException {
        URL uRL = null;
        String string = null;
        Symbol.ClassSymbol classSymbol = element instanceof Symbol.ClassSymbol ? (Symbol.ClassSymbol)element : (Symbol.ClassSymbol)SourceUtils.getEnclosingTypeElement(element);
        if (classSymbol != null && classSymbol.classfile != null) {
            try {
                uRL = classSymbol.classfile.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            string = ((Symbol)classSymbol.getEnclosingElement()).getQualifiedName().toString();
        }
        return new TreePathHandle(new ElementDelegate(ElementHandle.create(element), uRL, string, compilationInfo.getClasspathInfo()));
    }

    private static boolean isSupported(Element element) {
        switch (element.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ANNOTATION_TYPE: 
            case ENUM_CONSTANT: {
                return true;
            }
        }
        return false;
    }

    private static PositionRef createPositionRef(FileObject fileObject, int n, Position.Bias bias) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
            if (cookie instanceof CloneableEditorSupport) {
                return ((CloneableEditorSupport)cookie).createPositionRef(n, bias);
            }
            cookie = dataObject.getCookie(EditorCookie.class);
            if (cookie instanceof CloneableEditorSupport) {
                return ((CloneableEditorSupport)cookie).createPositionRef(n, bias);
            }
            EditorSupport editorSupport = (EditorSupport)dataObject.getCookie(EditorSupport.class);
            if (editorSupport != null) {
                return editorSupport.createPositionRef(n, bias);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        throw new IllegalStateException("Cannot create PositionRef for file " + fileObject.getPath() + ". CloneableEditorSupport not found");
    }

    public String toString() {
        return "TreePathHandle[delegate:" + this.delegate + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementDelegate
    implements Delegate {
        private ElementHandle<? extends Element> el;
        private URL source;
        private String qualName;
        private ClasspathInfo cpInfo;

        public ElementDelegate(ElementHandle<? extends Element> elementHandle, URL uRL, String string, ClasspathInfo classpathInfo) {
            this.el = elementHandle;
            this.source = uRL;
            this.qualName = string;
            this.cpInfo = classpathInfo;
        }

        @Override
        public FileObject getFileObject() {
            FileObject fileObject = SourceUtils.getFile(this.el, this.cpInfo);
            if (fileObject == null && this.source != null) {
                FileObject fileObject2;
                fileObject = fileObject2 = URLMapper.findFileObject((URL)this.source);
                if (fileObject2.getNameExt().endsWith("sig")) {
                    String string = FileObjects.convertPackage2Folder(this.qualName);
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                    for (int n = 0; fileObject2 != null && n <= stringTokenizer.countTokens(); fileObject2 = fileObject2.getParent(), ++n) {
                    }
                    if (fileObject2 != null) {
                        try {
                            URL uRL = fileObject2.getURL();
                            URL uRL2 = Index.getSourceRootForClassFolder(uRL);
                            if (uRL2 != null) {
                                FileObject fileObject3 = URLMapper.findFileObject((URL)uRL2);
                                String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)URLMapper.findFileObject((URL)this.source));
                                fileObject = fileObject3.getFileObject(string2.replace(".sig", ".class"));
                            } else {
                                Logger.getLogger(TreePathHandle.class.getName()).fine("Index.getSourceRootForClassFolder(url) returned null for url=" + uRL);
                            }
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                        }
                    }
                }
            }
            return fileObject;
        }

        @Override
        public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
            Element element = this.resolveElement(compilationInfo);
            if (element == null) {
                return null;
            }
            return compilationInfo.getTrees().getPath(element);
        }

        @Override
        public Element resolveElement(CompilationInfo compilationInfo) {
            return this.el.resolve(compilationInfo);
        }

        @Override
        public Tree.Kind getKind() {
            switch (this.el.getKind()) {
                case PACKAGE: {
                    return Tree.Kind.COMPILATION_UNIT;
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    return Tree.Kind.CLASS;
                }
                case FIELD: 
                case ENUM_CONSTANT: 
                case PARAMETER: 
                case LOCAL_VARIABLE: 
                case EXCEPTION_PARAMETER: {
                    return Tree.Kind.VARIABLE;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    return Tree.Kind.METHOD;
                }
                case INSTANCE_INIT: 
                case STATIC_INIT: {
                    return Tree.Kind.BLOCK;
                }
                case TYPE_PARAMETER: {
                    return Tree.Kind.TYPE_PARAMETER;
                }
            }
            return Tree.Kind.OTHER;
        }

        @Override
        public boolean equalsHandle(Delegate delegate) {
            ElementDelegate elementDelegate = (ElementDelegate)delegate;
            return this.el.signatureEquals((Element)((Object)elementDelegate.el)) && this.cpInfo.equals(elementDelegate.cpInfo);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.el.getSignature());
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[elementHandle:" + this.el + ", url:" + this.source + "]";
        }
    }

    private static final class TreeDelegate
    implements Delegate {
        private PositionRef position;
        private KindPath kindPath;
        private FileObject file;
        private ElementHandle enclosingElement;
        private boolean enclElIsCorrespondingEl;
        private Tree.Kind kind;

        private TreeDelegate(PositionRef positionRef, KindPath kindPath, FileObject fileObject, ElementHandle elementHandle, boolean bl) {
            this.kindPath = kindPath;
            this.position = positionRef;
            this.file = fileObject;
            this.enclosingElement = elementHandle;
            this.enclElIsCorrespondingEl = bl;
            if (kindPath != null) {
                this.kind = (Tree.Kind)((Object)kindPath.kindPath.get(0));
            } else if (bl) {
                ElementKind elementKind = elementHandle.getKind();
                if (elementKind.isClass() || elementKind.isInterface()) {
                    this.kind = Tree.Kind.CLASS;
                } else if (elementKind.isField()) {
                    this.kind = Tree.Kind.VARIABLE;
                } else if (elementKind == ElementKind.METHOD || elementKind == ElementKind.CONSTRUCTOR) {
                    this.kind = Tree.Kind.METHOD;
                }
            }
        }

        public FileObject getFileObject() {
            return this.file;
        }

        public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
            Object object;
            assert (compilationInfo != null);
            if (!compilationInfo.getFileObject().equals(this.getFileObject())) {
                StringBuilder stringBuilder = new StringBuilder();
                FileObject fileObject = this.getFileObject();
                FileObject fileObject2 = compilationInfo.getFileObject();
                stringBuilder.append("TreePathHandle [" + FileUtil.getFileDisplayName((FileObject)fileObject) + "] was not created from " + FileUtil.getFileDisplayName((FileObject)fileObject2));
                stringBuilder.append("\n");
                try {
                    stringBuilder.append("mine: id=" + System.identityHashCode(fileObject) + ", valid=" + fileObject.isValid() + ", url=");
                    stringBuilder.append(fileObject.getURL().toExternalForm());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    stringBuilder.append(fileStateInvalidException.getMessage());
                }
                stringBuilder.append("\n");
                try {
                    stringBuilder.append("remote: id=" + System.identityHashCode(fileObject2) + ", valid=" + fileObject2.isValid() + ", url=");
                    stringBuilder.append(fileObject2.getURL().toExternalForm());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    stringBuilder.append(fileStateInvalidException.getMessage());
                }
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            Object t = this.enclosingElement.resolve(compilationInfo);
            TreePath treePath = null;
            if (t != null) {
                object = compilationInfo.getTrees().getPath((Element)t);
                if (object == null) {
                    Logger.getLogger(TreePathHandle.class.getName()).fine("compilationInfo.getTrees().getPath(element) returned null for element %s " + t + "(" + this.file.getPath() + ")");
                } else {
                    treePath = compilationInfo.getTreeUtilities().pathFor((TreePath)object, this.position.getOffset() + 1);
                }
            }
            if (treePath != null && new KindPath(treePath).equals(this.kindPath)) {
                return treePath;
            }
            for (treePath = compilationInfo.getTreeUtilities().pathFor(this.position.getOffset() + 1); treePath != null; treePath = treePath.getParentPath()) {
                object = new KindPath(treePath);
                this.kindPath.getList().remove((Object)Tree.Kind.ERRONEOUS);
                if (!((KindPath)object).equals(this.kindPath)) continue;
                return treePath;
            }
            return null;
        }

        public boolean equalsHandle(Delegate delegate) {
            TreeDelegate treeDelegate = (TreeDelegate)delegate;
            try {
                if (this.position == null && treeDelegate.position == null) {
                    assert (this.enclElIsCorrespondingEl);
                    assert (treeDelegate.enclElIsCorrespondingEl);
                    return this.enclosingElement.equals(treeDelegate.enclosingElement);
                }
                if (this.position.getPosition().getOffset() != this.position.getPosition().getOffset()) {
                    return false;
                }
                if (!(this.file == treeDelegate.file || this.file != null && this.file.equals(treeDelegate.file))) {
                    return false;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.position == null) {
                return 553 + this.enclosingElement.hashCode();
            }
            int n = 7;
            n = 79 * n + this.position.getOffset();
            n = 79 * n + (this.file != null ? this.file.hashCode() : 0);
            return n;
        }

        public Element resolveElement(CompilationInfo compilationInfo) {
            TreePath treePath = null;
            IllegalStateException illegalStateException = null;
            try {
                if (this.file != null && compilationInfo.getFileObject() != null && compilationInfo.getFileObject().equals(this.file) && this.position != null) {
                    treePath = this.resolve(compilationInfo);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                illegalStateException = illegalStateException2;
            }
            if (treePath == null) {
                if (this.enclElIsCorrespondingEl) {
                    Object t = this.enclosingElement.resolve(compilationInfo);
                    if (t == null) {
                        Logger.getLogger(TreePathHandle.class.getName()).severe("Cannot resolve" + this.enclosingElement + " in " + compilationInfo.getClasspathInfo());
                    }
                    return t;
                }
                if (illegalStateException == null) {
                    return null;
                }
                throw illegalStateException;
            }
            Element element = compilationInfo.getTrees().getElement(treePath);
            if (element == null) {
                Logger.getLogger(TreePathHandle.class.toString()).fine("info.getTrees().getElement(tp) returned null for " + treePath);
                if (this.enclElIsCorrespondingEl) {
                    Object t = this.enclosingElement.resolve(compilationInfo);
                    if (t == null) {
                        Logger.getLogger(TreePathHandle.class.getName()).fine("Cannot resolve" + this.enclosingElement + " in " + compilationInfo.getClasspathInfo());
                    }
                    return t;
                }
                return null;
            }
            return element;
        }

        public Tree.Kind getKind() {
            return this.kind;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[kind:" + (Object)((Object)this.kind) + ", enclosingElement:" + this.enclosingElement + ", file:" + this.file + "]";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class KindPath {
            private ArrayList<Tree.Kind> kindPath = new ArrayList();

            KindPath(TreePath treePath) {
                while (treePath != null) {
                    this.kindPath.add(treePath.getLeaf().getKind());
                    treePath = treePath.getParentPath();
                }
            }

            public int hashCode() {
                return this.kindPath.hashCode();
            }

            public boolean equals(Object object) {
                if (object instanceof KindPath) {
                    return this.kindPath.equals(((KindPath)object).kindPath);
                }
                return false;
            }

            public ArrayList<Tree.Kind> getList() {
                return this.kindPath;
            }
        }
    }

    static interface Delegate {
        public FileObject getFileObject();

        public TreePath resolve(CompilationInfo var1) throws IllegalArgumentException;

        public boolean equalsHandle(Delegate var1);

        public int hashCode();

        public Element resolveElement(CompilationInfo var1);

        public Tree.Kind getKind();
    }
}

