/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveRefactoringPlugin
extends JavaRefactoringPlugin {
    private Map packagePostfix = new HashMap();
    AbstractRefactoring refactoring;
    ArrayList<FileObject> filesToMove = new ArrayList();
    HashMap<FileObject, ElementHandle> classes;
    Map<FileObject, Set<FileObject>> whoReferences = new HashMap<FileObject, Set<FileObject>>();

    public MoveRefactoringPlugin(MoveRefactoring moveRefactoring) {
        this.refactoring = moveRefactoring;
        this.setup(moveRefactoring.getRefactoringSource().lookupAll(FileObject.class), "", true);
    }

    public MoveRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        FileObject fileObject = (FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class);
        if (fileObject != null) {
            this.setup(Collections.singletonList(fileObject), "", true);
        } else {
            this.setup(Collections.singletonList(((NonRecursiveFolder)renameRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder()), "", false);
        }
    }

    @Override
    public Problem preCheck() {
        Problem problem = null;
        for (FileObject fileObject : this.filesToMove) {
            if (RetoucheUtils.isElementInOpenProject(fileObject)) continue;
            problem = MoveRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
        }
        return problem;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        if (this.refactoring instanceof RenameRefactoring) {
            FileObject fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            if (fileObject != null) {
                String string = ((RenameRefactoring)this.refactoring).getNewName();
                if (!RetoucheUtils.isValidPackageName(string)) {
                    String string2 = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{string});
                    return new Problem(true, string2);
                }
                if (fileObject.getParent().getFileObject(string, fileObject.getExt()) != null) {
                    String string3 = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_PackageExists")).format(new Object[]{string});
                    return new Problem(true, string3);
                }
            }
            return super.fastCheckParameters();
        }
        if (this.refactoring instanceof MoveRefactoring) {
            try {
                for (FileObject fileObject : this.filesToMove) {
                    String string;
                    String string4;
                    if (!RetoucheUtils.isJavaFile(fileObject)) continue;
                    String string5 = this.getTargetPackageName(fileObject);
                    if (!RetoucheUtils.isValidPackageName(string5)) {
                        string4 = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage");
                        string = new MessageFormat(string4).format(new Object[]{string5});
                        return new Problem(true, string);
                    }
                    string4 = RetoucheUtils.getClassPathRoot((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
                    string = string4.getFileObject(string5.replace('.', '/'));
                    String string6 = null;
                    if (string != null && !string.canWrite()) {
                        return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_PackageIsReadOnly")).format(new Object[]{string5}));
                    }
                    string6 = string5;
                    if (string6 == null) {
                        string6 = "";
                    } else if (string6.length() > 0) {
                        string6 = string6 + '.';
                    }
                    String string7 = fileObject.getName();
                    if (string == null) continue;
                    FileObject[] fileObjectArray = string.getChildren();
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        if (!fileObjectArray[i].getName().equals(string7) || !"java".equals(fileObjectArray[i].getExt()) || fileObjectArray[i].equals(fileObject) || fileObjectArray[i].isVirtual()) continue;
                        return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_ClassToMoveClashes")).format(new Object[]{string7}));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.fastCheckParameters();
    }

    private Problem checkProjectDeps(Set<FileObject> set) {
        if (this.refactoring instanceof MoveRefactoring) {
            Object object;
            Object object2;
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            for (FileObject fileObject : this.filesToMove) {
                object2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                if (object2 == null) continue;
                object = object2.findOwnerRoot(fileObject);
                hashSet.add((FileObject)object);
            }
            URL uRL = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
            if (uRL == null) {
                return null;
            }
            try {
                FileObject fileObject;
                fileObject = RetoucheUtils.getClassPathRoot(uRL);
                object2 = URLMapper.findURL((FileObject)fileObject, (int)1);
                object = SourceUtils.getDependentRoots((URL)object2);
                for (FileObject fileObject2 : hashSet) {
                    URL uRL2 = URLMapper.findURL((FileObject)fileObject2, (int)0);
                    if (object.contains(uRL2)) continue;
                    Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
                    for (FileObject fileObject3 : set) {
                        if (!FileOwnerQuery.getOwner((FileObject)fileObject3).equals(project) || this.filesToMove.contains(fileObject3)) continue;
                        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
                        assert (project != null);
                        assert (project2 != null);
                        String string = ProjectUtils.getInformation((Project)project).getDisplayName();
                        String string2 = ProjectUtils.getInformation((Project)project2).getDisplayName();
                        return MoveRefactoringPlugin.createProblem(null, false, NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_MissingProjectDeps", (Object)string, (Object)string2));
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
        ClassIndex classIndex = classpathInfo.getClassIndex();
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (Map.Entry<FileObject, ElementHandle> entry : this.classes.entrySet()) {
            Set set = classIndex.getResources(entry.getValue(), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            hashSet.addAll(set);
            this.whoReferences.put(entry.getKey(), set);
        }
        hashSet.addAll(this.filesToMove);
        return hashSet;
    }

    private void initClasses() {
        this.classes = new HashMap();
        for (int i = 0; i < this.filesToMove.size(); ++i) {
            final int n = i;
            try {
                JavaSource javaSource = JavaSource.forFileObject((FileObject)this.filesToMove.get(i));
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        List<? extends Tree> list = compilationController.getCompilationUnit().getTypeDecls();
                        for (Tree tree : list) {
                            if (tree.getKind() != Tree.Kind.CLASS || !((ClassTree)tree).getSimpleName().toString().equals(MoveRefactoringPlugin.this.filesToMove.get(n).getName())) continue;
                            MoveRefactoringPlugin.this.classes.put(MoveRefactoringPlugin.this.filesToMove.get(n), ElementHandle.create((Element)compilationController.getTrees().getElement(TreePath.getPath(compilationController.getCompilationUnit(), tree))));
                            return;
                        }
                    }
                }, true);
                continue;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        this.initClasses();
        Set<FileObject> set = this.getRelevantFiles();
        Problem problem = this.checkProjectDeps(set);
        this.fireProgressListenerStart(1, set.size());
        MoveTransformer moveTransformer = new MoveTransformer(this);
        JavaRefactoringPlugin.TransformTask transformTask = new JavaRefactoringPlugin.TransformTask(this, moveTransformer, null);
        Problem problem2 = this.createAndAddElements(set, transformTask, refactoringElementsBag, this.refactoring);
        this.fireProgressListenerStop();
        return problem2 != null ? problem2 : MoveRefactoringPlugin.chainProblems(problem, moveTransformer.getProblem());
    }

    private static Problem chainProblems(Problem problem, Problem problem2) {
        if (problem == null) {
            return problem2;
        }
        if (problem2 == null) {
            return problem;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    String getNewPackageName() {
        if (this.refactoring instanceof MoveRefactoring) {
            return RetoucheUtils.getPackageName((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
        }
        return ((RenameRefactoring)this.refactoring).getNewName();
    }

    String getTargetPackageName(FileObject fileObject) {
        if (this.refactoring instanceof RenameRefactoring) {
            if (this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
                return this.getNewPackageName();
            }
            FileObject fileObject2 = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
            FileObject fileObject3 = classPath.findOwnerRoot(fileObject2);
            String string = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2.getParent()).replace('/', '.');
            String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent()).replace('/', '.');
            String string3 = this.concat(string, this.getNewPackageName(), string2);
            return string3;
        }
        if (this.packagePostfix != null) {
            String string = (String)this.packagePostfix.get(fileObject);
            String string4 = this.concat(null, this.getNewPackageName(), string);
            return string4;
        }
        return this.getNewPackageName();
    }

    private void setup(Collection collection, String string, boolean bl) {
        for (FileObject fileObject : collection) {
            if (RetoucheUtils.isJavaFile(fileObject)) {
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                this.filesToMove.add(fileObject);
                continue;
            }
            if (!fileObject.isFolder()) {
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(fileObject)) continue;
            boolean bl2 = !"".equals(string);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (fileObject2.isFolder() && (!fileObject2.isFolder() || !bl)) continue;
                arrayList.add(fileObject2);
            }
            this.setup(arrayList, string + (bl2 ? "." : "") + fileObject.getName(), bl);
        }
    }

    private String concat(String string, String string2, String string3) {
        String string4 = "";
        if (string != null && !"".equals(string)) {
            string4 = string4 + string + ".";
        }
        string4 = string4 + string2;
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + ("".equals(string4) ? "" : ".") + string3;
        }
        return string4;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        return null;
    }
}

