/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.resources;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.connection.JDBCNBConnection;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.ui.ValidationUtils;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.db.explorer.DatabaseConnection;

public class DataSourceDialog
extends JDialog {
    private int dialogResult = 2;
    private JServer server = null;
    private String parentFolder = null;
    private RepositoryFolder datasourceResource = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private boolean doNotStore = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClose;
    private JButton jButtonImportConnection;
    private JButton jButtonSave;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabelBeanMethod;
    private JLabel jLabelBeanName;
    private JLabel jLabelDescription;
    private JLabel jLabelDriver;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelPassword;
    private JLabel jLabelServiceName;
    private JLabel jLabelURL;
    private JLabel jLabelUriString;
    private JLabel jLabelUsername;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPasswordField jPasswordField;
    private JRadioButton jRadioButtonBean;
    private JRadioButton jRadioButtonJDBC;
    private JRadioButton jRadioButtonJNDI;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldBeanMethod;
    private JTextField jTextFieldBeanName;
    private JTextField jTextFieldDriver;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldServiceName;
    private JTextField jTextFieldURL;
    private JTextField jTextFieldUriString;
    private JTextField jTextFieldUsername;

    public DataSourceDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
        DocumentListener changesListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                DataSourceDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                DataSourceDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                DataSourceDialog.this.updateSaveButton();
            }
        };
        this.jTextFieldLabel.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.getDocument().addDocumentListener(changesListener);
        this.jTextFieldDriver.getDocument().addDocumentListener(changesListener);
        this.jTextFieldURL.getDocument().addDocumentListener(changesListener);
        this.jTextFieldUsername.getDocument().addDocumentListener(changesListener);
        this.jTextFieldServiceName.getDocument().addDocumentListener(changesListener);
        this.jPasswordField.getDocument().addDocumentListener(changesListener);
        this.jTextFieldBeanName.getDocument().addDocumentListener(changesListener);
        this.applyI18n();
        this.jTextFieldName.requestFocusInWindow();
    }

    public void applyI18n() {
        this.jButtonClose.setText(JasperServerManager.getString("dataSourceDialog.buttonCancel", "Cancel"));
        this.jButtonImportConnection.setText(JasperServerManager.getString("dataSourceDialog.buttonImportConnection", "Import from iReport"));
        this.jButtonSave.setText(JasperServerManager.getString("dataSourceDialog.buttonSave", "Save"));
        this.jLabel1.setText(JasperServerManager.getString("dataSourceDialog.title", "Data Source"));
        this.jLabelBeanMethod.setText(JasperServerManager.getString("dataSourceDialog.labelBeanMethod", "Bean Method"));
        this.jLabelBeanName.setText(JasperServerManager.getString("dataSourceDialog.labelBeanName", "Bean Name"));
        this.jLabelDescription.setText(JasperServerManager.getString("dataSourceDialog.labelDescription", "Description"));
        this.jLabelDriver.setText(JasperServerManager.getString("dataSourceDialog.labelDriver", "Driver"));
        this.jLabelLabel.setText(JasperServerManager.getString("dataSourceDialog.labelLabel", "Label"));
        this.jLabelName.setText(JasperServerManager.getString("dataSourceDialog.labelName", "Name"));
        this.jLabelUriString.setText(JasperServerManager.getString("dataSourceDialog.labelParentFolder", "Parent folder"));
        this.jLabelPassword.setText(JasperServerManager.getString("dataSourceDialog.labelPassword", "Password"));
        this.jLabelServiceName.setText(JasperServerManager.getString("dataSourceDialog.labelServiceName", "Service Name"));
        this.jLabelURL.setText(JasperServerManager.getString("dataSourceDialog.labelURL", "URL"));
        this.jLabelUsername.setText(JasperServerManager.getString("dataSourceDialog.labelUsername", "Username"));
        this.jRadioButtonBean.setText(JasperServerManager.getString("dataSourceDialog.radioBean", "Bean Data Source"));
        this.jRadioButtonJDBC.setText(JasperServerManager.getString("dataSourceDialog.radioJDBC", "JDBC Data Source"));
        this.jRadioButtonJNDI.setText(JasperServerManager.getString("dataSourceDialog.radioJNDI", "JNDI Data Source"));
        this.jTabbedPane1.setTitleAt(0, JasperServerManager.getString("dataSourceDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, JasperServerManager.getString("dataSourceDialog.tabDetails", "Data Source details"));
    }

    private void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0 && this.jTextFieldName.getText().length() > 0) {
            boolean ok = false;
            if (this.jRadioButtonJDBC.isSelected() && this.jTextFieldDriver.getText().length() > 0 && this.jTextFieldURL.getText().length() > 0 && this.jTextFieldUsername.getText().length() > 0) {
                ok = true;
            } else if (this.jRadioButtonJNDI.isSelected() && this.jTextFieldServiceName.getText().length() > 0) {
                ok = true;
            } else if (this.jRadioButtonBean.isSelected() && this.jTextFieldBeanName.getText().length() > 0) {
                ok = true;
            }
            this.jButtonSave.setEnabled(ok);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jLabelDescription = new JLabel();
        this.jPanel3 = new JPanel();
        this.jRadioButtonJDBC = new JRadioButton();
        this.jLabelDriver = new JLabel();
        this.jTextFieldDriver = new JTextField();
        this.jLabelURL = new JLabel();
        this.jTextFieldURL = new JTextField();
        this.jLabelUsername = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabelPassword = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jButtonImportConnection = new JButton();
        this.jRadioButtonJNDI = new JRadioButton();
        this.jLabelServiceName = new JLabel();
        this.jTextFieldServiceName = new JTextField();
        this.jPanel5 = new JPanel();
        this.jRadioButtonBean = new JRadioButton();
        this.jLabelBeanName = new JLabel();
        this.jTextFieldBeanName = new JTextField();
        this.jLabelBeanMethod = new JLabel();
        this.jTextFieldBeanMethod = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("DataSource");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_new.png")));
        this.jLabel1.setText("Datasource");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setPreferredSize(new Dimension(400, 185));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelUriString.setText("Parent folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("ID");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jTabbedPane1.addTab("General", this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.jRadioButtonJDBC);
        this.jRadioButtonJDBC.setText("JDBC Data Source");
        this.jRadioButtonJDBC.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonJDBC.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonJDBC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jRadioButtonJDBCActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel3.add((Component)this.jRadioButtonJDBC, gridBagConstraints);
        this.jLabelDriver.setText("Driver");
        this.jLabelDriver.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelDriver, gridBagConstraints);
        this.jTextFieldDriver.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldDriver, gridBagConstraints);
        this.jLabelURL.setText("URL");
        this.jLabelURL.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelURL, gridBagConstraints);
        this.jTextFieldURL.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldURL, gridBagConstraints);
        this.jLabelUsername.setText("Username");
        this.jLabelUsername.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelUsername, gridBagConstraints);
        this.jTextFieldUsername.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jLabelPassword.setText("Password");
        this.jLabelPassword.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelPassword, gridBagConstraints);
        this.jPasswordField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.jPasswordField, gridBagConstraints);
        this.jButtonImportConnection.setText("Import from iReport");
        this.jButtonImportConnection.setEnabled(false);
        this.jButtonImportConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jButtonImportConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 8);
        this.jPanel3.add((Component)this.jButtonImportConnection, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonJNDI);
        this.jRadioButtonJNDI.setSelected(true);
        this.jRadioButtonJNDI.setText("JNDI Data Source");
        this.jRadioButtonJNDI.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonJNDI.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonJNDI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jRadioButtonJNDIActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 8, 4, 4);
        this.jPanel3.add((Component)this.jRadioButtonJNDI, gridBagConstraints);
        this.jLabelServiceName.setText("Service Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelServiceName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldServiceName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonBean);
        this.jRadioButtonBean.setText("Bean Data Source");
        this.jRadioButtonBean.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonBean.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonBean.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jRadioButtonJNDIActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 8, 4, 4);
        this.jPanel3.add((Component)this.jRadioButtonBean, gridBagConstraints);
        this.jLabelBeanName.setText("Bean Name");
        this.jLabelBeanName.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelBeanName, gridBagConstraints);
        this.jTextFieldBeanName.setToolTipText("Name of configured bean");
        this.jTextFieldBeanName.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldBeanName, gridBagConstraints);
        this.jLabelBeanMethod.setText("Bean Method");
        this.jLabelBeanMethod.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelBeanMethod, gridBagConstraints);
        this.jTextFieldBeanMethod.setToolTipText("Name of method on configured bean (optional)");
        this.jTextFieldBeanMethod.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldBeanMethod, gridBagConstraints);
        this.jTabbedPane1.addTab("Datasource details", this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(10, 30));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jRadioButtonJNDIActionPerformed1(ActionEvent evt) {
        this.updateDatasourceType();
    }

    private void jRadioButtonJDBCActionPerformed(ActionEvent evt) {
        this.updateDatasourceType();
    }

    private void jButtonImportConnectionActionPerformed(ActionEvent evt) {
        List iReportConnections = IReportManager.getInstance().getConnections();
        Vector<IReportConnection> validConnections = new Vector<IReportConnection>();
        for (IReportConnection conn : iReportConnections) {
            if (!(conn instanceof JDBCConnection) && !(conn instanceof JDBCNBConnection)) continue;
            validConnections.add(conn);
        }
        if (validConnections.size() == 0) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getString("dataSourceDialog.message.noJDBCconfigured", "No JDBC connections currently configured in iReport."));
            return;
        }
        Object[] connections = new IReportConnection[validConnections.size()];
        for (int i = 0; i < connections.length; ++i) {
            connections[i] = (IReportConnection)validConnections.elementAt(i);
        }
        IReportConnection selectedCon = (IReportConnection)JOptionPane.showInputDialog(this, JasperServerManager.getString("dataSourceDialog.message.selectJDBC", "Select a JDBC datasource:"), JasperServerManager.getString("dataSourceDialog.message.import", "Import..."), 3, null, connections, connections[0]);
        if (selectedCon != null) {
            DatabaseConnection dbconn;
            if (selectedCon instanceof JDBCConnection) {
                this.jTextFieldDriver.setText(((JDBCConnection)selectedCon).getJDBCDriver());
                this.jTextFieldURL.setText(((JDBCConnection)selectedCon).getUrl());
                this.jTextFieldUsername.setText(((JDBCConnection)selectedCon).getUsername());
                this.jPasswordField.setText(((JDBCConnection)selectedCon).getPassword());
            } else if (selectedCon instanceof JDBCNBConnection && (dbconn = ((JDBCNBConnection)selectedCon).getDatabaseConnectionObject()) != null) {
                this.jTextFieldDriver.setText(dbconn.getDriverClass());
                this.jTextFieldURL.setText(dbconn.getDatabaseURL());
                this.jTextFieldUsername.setText(dbconn.getUser());
                this.jPasswordField.setText(dbconn.getPassword());
            }
        }
    }

    private void jRadioButtonJNDIActionPerformed(ActionEvent evt) {
        this.updateDatasourceType();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        try {
            ResourceDescriptor rd = new ResourceDescriptor();
            ValidationUtils.validateName(this.jTextFieldName.getText());
            ValidationUtils.validateLabel(this.jTextFieldLabel.getText());
            ValidationUtils.validateDesc(this.jEditorPaneDescription.getText());
            rd.setDescription(this.jEditorPaneDescription.getText().trim());
            rd.setName(this.jTextFieldName.getText());
            String uri = this.getParentFolder();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + this.jTextFieldName.getText();
            rd.setUriString(uri);
            rd.setLabel(this.jTextFieldLabel.getText().trim());
            rd.setParentFolder(this.getParentFolder());
            rd.setIsNew(this.datasourceResource == null);
            if (this.jRadioButtonJDBC.isSelected()) {
                rd.setWsType("jdbc");
                rd.setDriverClass(this.jTextFieldDriver.getText());
                rd.setConnectionUrl(this.jTextFieldURL.getText());
                rd.setUsername(this.jTextFieldUsername.getText());
                rd.setPassword(new String(this.jPasswordField.getPassword()));
            } else if (this.jRadioButtonJNDI.isSelected()) {
                rd.setWsType("jndi");
                rd.setJndiName(this.jTextFieldServiceName.getText());
            } else if (this.jRadioButtonBean.isSelected()) {
                rd.setWsType("bean");
                rd.setBeanName(this.jTextFieldBeanName.getText());
                rd.setBeanMethod(this.jTextFieldBeanMethod.getText());
            }
            this.newResourceDescriptor = !this.doNotStore ? this.getServer().getWSClient().addOrModifyResource(rd, null) : rd;
            this.setDialogResult(0);
            if (this.datasourceResource != null) {
                this.datasourceResource.setDescriptor(this.newResourceDescriptor);
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        this.jTextFieldUriString.setText(parentFolder);
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setResource(RepositoryFolder resource) {
        this.datasourceResource = resource;
        if (resource != null) {
            this.setResource(resource.getDescriptor());
            this.jTextFieldName.setEditable(false);
            this.jTextFieldName.setOpaque(false);
        }
    }

    public void setResource(ResourceDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.setTitle(JasperServerManager.getFormattedString("properties.title", "{0} - Properties", new Object[]{descriptor.getName()}));
        this.jTextFieldName.setText(descriptor.getName());
        this.jTextFieldLabel.setText(descriptor.getLabel());
        this.jEditorPaneDescription.setText(descriptor.getDescription());
        if (descriptor.getWsType().equals("jdbc")) {
            this.jRadioButtonJDBC.setEnabled(true);
            this.jRadioButtonJDBC.setSelected(true);
            this.jRadioButtonJNDI.setEnabled(false);
            this.jRadioButtonJNDI.setSelected(false);
            this.jRadioButtonBean.setSelected(false);
            this.jRadioButtonBean.setEnabled(false);
            this.updateDatasourceType();
            this.jTextFieldDriver.setText(descriptor.getDriverClass());
            this.jTextFieldURL.setText(descriptor.getConnectionUrl());
            this.jTextFieldUsername.setText(descriptor.getUsername());
            this.jPasswordField.setText(descriptor.getPassword());
        } else if (descriptor.getWsType().equals("jndi")) {
            this.jRadioButtonJDBC.setEnabled(false);
            this.jRadioButtonJDBC.setSelected(false);
            this.jRadioButtonJNDI.setEnabled(true);
            this.jRadioButtonJNDI.setSelected(true);
            this.jRadioButtonBean.setSelected(false);
            this.jRadioButtonBean.setEnabled(false);
            this.updateDatasourceType();
            this.jTextFieldServiceName.setText(descriptor.getJndiName());
        } else if (descriptor.getWsType().equals("bean")) {
            this.jRadioButtonJDBC.setEnabled(false);
            this.jRadioButtonJDBC.setSelected(false);
            this.jRadioButtonJNDI.setEnabled(false);
            this.jRadioButtonJNDI.setSelected(false);
            this.jRadioButtonBean.setSelected(true);
            this.jRadioButtonBean.setEnabled(true);
            this.updateDatasourceType();
            this.jTextFieldBeanName.setText(descriptor.getBeanName());
            this.jTextFieldBeanMethod.setText(descriptor.getBeanMethod() != null && descriptor.getBeanMethod().trim().length() > 0 ? descriptor.getBeanMethod() : "");
        }
        this.jButtonSave.setText("Save");
    }

    public void updateDatasourceType() {
        boolean b = this.jRadioButtonJDBC.isSelected();
        this.jTextFieldDriver.setEnabled(b);
        this.jTextFieldURL.setEnabled(b);
        this.jTextFieldUsername.setEnabled(b);
        this.jPasswordField.setEnabled(b);
        this.jButtonImportConnection.setEnabled(b);
        this.jLabelDriver.setEnabled(b);
        this.jLabelURL.setEnabled(b);
        this.jLabelUsername.setEnabled(b);
        this.jLabelPassword.setEnabled(b);
        b = this.jRadioButtonJNDI.isSelected();
        this.jTextFieldServiceName.setEnabled(b);
        this.jLabelServiceName.setEnabled(b);
        b = this.jRadioButtonBean.isSelected();
        this.jTextFieldBeanName.setEnabled(b);
        this.jLabelBeanName.setEnabled(b);
        this.jTextFieldBeanMethod.setEnabled(b);
        this.jLabelBeanMethod.setEnabled(b);
        this.updateSaveButton();
    }

    public boolean isDoNotStore() {
        return this.doNotStore;
    }

    public void setDoNotStore(boolean doNotStore) {
        this.doNotStore = doNotStore;
    }
}

