/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DBSchemaConnectionPanel
extends JPanel
implements ListDataListener {
    static final long serialVersionUID = 5364628520334696421L;
    private ArrayList list;
    private DBSchemaWizardData data;
    private Node dbNode;
    private Node[] drvNodes;
    private JTextArea descriptionTextArea;
    private JComboBox existingConnComboBox;
    private final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");

    public DBSchemaConnectionPanel(DBSchemaWizardData dBSchemaWizardData, ArrayList arrayList) {
        DataFolder dataFolder;
        this.list = arrayList;
        this.data = dBSchemaWizardData;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.setName(this.bundle.getString("ConnectionChooser"));
        this.initComponents();
        this.initAccessibility();
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("UI/Runtime");
        try {
            dataFolder = (DataFolder)DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        this.dbNode = dataFolder.getNodeDelegate().getChildren().findChild("Databases");
        DatabaseExplorerUIs.connect((JComboBox)this.existingConnComboBox, (ConnectionManager)ConnectionManager.getDefault());
        this.existingConnComboBox.getModel().addListDataListener(this);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ConnectionPanelA11yDesc"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DescriptionA11yName"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DescriptionA11yDesc"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_ExistingConnectionA11yName"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ExistingConnectionA11yDesc"));
    }

    private void initComponents() {
        this.descriptionTextArea = new JTextArea();
        this.existingConnComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(this.bundle.getString("Description"));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        this.descriptionTextArea.setRequestFocusEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
        this.existingConnComboBox.setToolTipText(this.bundle.getString("ACS_ExistingConnectionComboBoxA11yDesc"));
        this.existingConnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.existingConnComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 5);
        this.add((Component)this.existingConnComboBox, gridBagConstraints);
    }

    private void existingConnComboBoxActionPerformed(ActionEvent actionEvent) {
        Object object = this.existingConnComboBox.getSelectedItem();
        if (object instanceof DatabaseConnection) {
            this.data.setDatabaseConnection((DatabaseConnection)object);
        }
        this.fireChange(this);
    }

    public boolean isInputValid() {
        return this.existingConnComboBox.getSelectedItem() instanceof DatabaseConnection;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void initData() {
        this.data.setExistingConn(true);
        Object object = this.existingConnComboBox.getSelectedItem();
        if (object instanceof DatabaseConnection) {
            this.data.setDatabaseConnection((DatabaseConnection)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(Object object) {
        ArrayList arrayList;
        Serializable serializable = this;
        synchronized (serializable) {
            arrayList = (ArrayList)this.list.clone();
        }
        serializable = new ChangeEvent(object);
        for (int i = 0; i < arrayList.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)arrayList.get(i);
            changeListener.stateChanged((ChangeEvent)serializable);
        }
    }
}

