/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;

public class ProgressFrame
extends JFrame {
    ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    public PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private int workunits;
    private boolean finished = false;
    private JLabel msgLabel;
    private JButton okButton;
    private JPanel progressPanel;

    public ProgressFrame() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ProgressFrameTabA11yDesc"));
        this.okButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CancelButtonA11yDesc"));
        this.progressHandle = ProgressHandleFactory.createHandle(null);
        this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
        this.progressPanel.add(this.progressComponent);
        this.progressHandle.start();
        ImageIcon imageIcon = new ImageIcon("/org/netbeans/core/resources/frames/ide.gif");
        this.setIconImage(imageIcon.getImage());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(380, 150);
        this.setLocation(dimension.width / 2 - 190, dimension.height / 2 - 80);
    }

    public void dispose() {
        if (!this.finished) {
            this.progressHandle.finish();
            this.finished = true;
        }
        super.dispose();
    }

    private void initComponents() {
        this.progressPanel = new JPanel();
        this.msgLabel = new JLabel();
        this.okButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(this.bundle.getString("Title"));
        this.setResizable(false);
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.setMinimumSize(new Dimension(20, 20));
        this.progressPanel.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 11, 11, 11);
        this.getContentPane().add((Component)this.progressPanel, gridBagConstraints);
        this.msgLabel.setHorizontalAlignment(2);
        this.msgLabel.setText(this.bundle.getString("PreparingToCapture"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 6, 11);
        this.getContentPane().add((Component)this.msgLabel, gridBagConstraints);
        this.okButton.setText(this.bundle.getString("Close"));
        this.okButton.setHorizontalTextPosition(0);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressFrame.this.okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 11, 11, 11);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.propertySupport.firePropertyChange("cancel", null, Boolean.TRUE);
        this.dispose();
    }

    public void setMaximum(int n) {
        this.progressHandle.switchToDeterminate(n);
        this.workunits = n;
    }

    public void setValue(final int n) {
        this.progressHandle.progress(n);
        if (n >= this.workunits) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = MessageFormat.format(ProgressFrame.this.bundle.getString("Complete"), Integer.toString(n));
                    ProgressFrame.this.msgLabel.setText(string);
                }
            });
        }
    }

    public void setMessage(String string) {
        this.msgLabel.setText(string);
    }

    public void finishProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressFrame.this.progressHandle.finish();
                ProgressFrame.this.finished = true;
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }
}

