/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder.syntax;

import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public abstract class QueryTokens {

    public static class Sort
    implements _Base {
        public static final short ASCENDING = 0;
        public static final short DESCENDING = 1;
        private short type;
        private _Expression expr;

        public Sort(_Expression expr) {
            this(expr, 0);
        }

        public Sort(_Expression expr, short type) {
            this.expr = expr;
            this.type = type;
        }

        public Sort(_Expression expr, boolean ascending) {
            this(expr, ascending ? (short)0 : 1);
        }

        public boolean isAscending() {
            return this.type == 0;
        }

        public void setType(short t) {
            this.type = t;
        }

        public _Expression getExpression() {
            return this.expr;
        }

        public String toString() {
            return (this.expr instanceof Column ? ((Column)this.expr).getIdentifier() : this.expr.toString()) + (this.isAscending() ? " ASC" : " DESC");
        }
    }

    public static class Group
    implements _Base {
        private _Expression expr;

        public Group(String value) {
            this(new DefaultExpression(value));
        }

        public Group(_Expression expr) {
            this.expr = expr;
        }

        public _Expression getExpression() {
            return this.expr;
        }

        public String toString() {
            return this.expr instanceof Column ? ((Column)this.expr).getReference() : this.expr.toString();
        }
    }

    public static class Condition
    implements _Base {
        private _Expression left;
        private _Expression right;
        private String append;
        private String operator;

        public Condition() {
            this(null, new DefaultExpression(), "=", new DefaultExpression());
        }

        public Condition(_Expression left, String operator, _Expression right) {
            this(null, left, operator, right);
        }

        public Condition(String append, _Expression left, String operator, _Expression right) {
            this.left = left;
            this.right = right;
            this.append = append;
            this.operator = operator;
        }

        public String getAppend() {
            return this.append;
        }

        public void setAppend(String a) {
            this.append = a;
        }

        public _Expression getLeft() {
            return this.left;
        }

        public void setLeft(_Expression l) {
            this.left = l;
        }

        public _Expression getRight() {
            return this.right;
        }

        public void setRight(_Expression r) {
            this.right = r;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String o) {
            this.operator = o;
        }

        public String toString() {
            String exprL = null;
            String exprR = null;
            if (this.left != null) {
                exprL = this.left instanceof Column ? ((Column)this.left).getIdentifier() : this.left.toString();
            }
            if (this.right != null) {
                exprR = this.right instanceof Column ? ((Column)this.right).getIdentifier() : this.right.toString();
            }
            if (this.operator.equals("EXISTS") || this.operator.equals("NOT EXISTS")) {
                return (this.append != null ? this.append + " " : "") + this.operator + " " + exprR;
            }
            return (this.append != null ? this.append + " " : "") + exprL + " " + this.operator + " " + exprR;
        }
    }

    public static class Join
    implements _TableReference {
        public static final int INNER = 0;
        public static final int LEFT_OUTER = 1;
        public static final int RIGHT_OUTER = 2;
        public static final int FULL_OUTER = 3;
        private int type;
        private Condition condition;

        public Join(Column primary, String operator, Column foreign) {
            this(0, primary, operator, foreign);
        }

        public Join(int type, Column primary, String operator, Column foreign) {
            this.type = type;
            this.condition = new Condition(primary, operator, foreign);
        }

        public int getType() {
            return this.type;
        }

        public String getTypeName() {
            return Join.getTypeString(this.type);
        }

        public static int getTypeInt(String type) {
            if (type.toUpperCase().equals("LEFT OUTER JOIN")) {
                return 1;
            }
            if (type.toUpperCase().equals("RIGHT OUTER JOIN")) {
                return 2;
            }
            if (type.toUpperCase().equals("FULL OUTER JOIN")) {
                return 3;
            }
            return 0;
        }

        public static String getTypeString(int type) {
            switch (type) {
                case 1: {
                    return "LEFT OUTER JOIN";
                }
                case 2: {
                    return "RIGHT OUTER JOIN";
                }
                case 3: {
                    return "FULL OUTER JOIN";
                }
            }
            return "INNER JOIN";
        }

        public void setType(int t) {
            this.type = t;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public Column getPrimary() {
            return (Column)this.condition.getLeft();
        }

        public Column getForeign() {
            return (Column)this.condition.getRight();
        }

        public String toString() {
            return this.getPrimary().getTable().toString() + ' ' + this.getTypeName() + ' ' + this.getForeign().getTable().toString() + ' ' + "ON" + ' ' + this.getCondition();
        }
    }

    public static class Table
    extends AbstractDatabaseObject
    implements _TableReference {
        private String schema;

        public Table(String schema, String name) {
            super(name);
            this.schema = schema;
        }

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public String getIdentifier() {
            String identifier = this.schema != null ? this.schema + '.' + this.getName() : this.getName();
            return SQLFormatter.ensureQuotes(identifier, !QueryBuilder.useAlwaysQuote);
        }

        public String toString() {
            String declare = this.getIdentifier();
            if (declare == null) {
                return this.getAlias();
            }
            if (this.isAliasSet()) {
                declare = declare + ' ' + this.getAlias();
            }
            return declare;
        }
    }

    public static class Column
    extends AbstractDatabaseObject
    implements _Expression {
        private Table owner;

        public Column(Table owner, String name) {
            super(name);
            this.owner = owner;
        }

        public Table getTable() {
            return this.owner;
        }

        public String getIdentifier() {
            String identifier = SQLFormatter.ensureQuotes(this.getName(), !QueryBuilder.useAlwaysQuote);
            if (this.owner != null) {
                identifier = this.owner.getReference() + '.' + identifier;
            }
            return identifier;
        }

        public String toString() {
            String declare = this.getIdentifier();
            if (declare == null) {
                return this.getAlias();
            }
            if (this.isAliasSet()) {
                declare = declare + ' ' + "AS" + ' ' + this.getAlias();
            }
            return declare;
        }
    }

    public static abstract class AbstractDatabaseObject
    implements _Alias {
        private String alias;
        private String name;

        public AbstractDatabaseObject(String name) {
            this.name = name;
        }

        public abstract String getIdentifier();

        public String getReference() {
            return this.isAliasSet() ? this.getAlias() : this.getIdentifier();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isAliasSet() {
            return this.alias != null && !this.alias.equals("");
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            if (alias != null) {
                alias = alias.replace(' ', '_');
                alias = alias.replace('.', '_');
            }
            this.alias = alias;
        }
    }

    public static class DefaultExpression
    implements _Expression,
    _Alias {
        private String alias;
        private String value;

        public DefaultExpression() {
            this(null);
        }

        public DefaultExpression(String value) {
            this(value, null);
        }

        public DefaultExpression(String value, String alias) {
            this.setValue(value);
            this.setAlias(alias);
        }

        public boolean isAliasSet() {
            return this.alias != null && !this.alias.equals("");
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            if (alias != null) {
                alias = alias.replace(' ', '_');
                alias = alias.replace('.', '_');
            }
            this.alias = alias;
        }

        public boolean isEmpty() {
            return this.value == null || this.value.trim().equals("");
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.isAliasSet() ? this.value + ' ' + "AS" + ' ' + this.getAlias() : this.value;
        }
    }

    public static interface _Alias {
        public boolean isAliasSet();

        public String getAlias();

        public void setAlias(String var1);
    }

    public static interface _TableReference
    extends _Base {
    }

    public static interface _Expression
    extends _Base {
    }

    public static interface _Base {
    }
}

