/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.jdkselection.JdkConfiguration;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Classpaths
implements ClassPathProvider,
AntProjectListener,
PropertyChangeListener {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance(Classpaths.class.getName());
    static CountDownLatch TESTING_LATCH = null;
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private AuxiliaryConfiguration aux;
    private final Map<String, Map<FileObject, ClassPath>> classpaths = new HashMap<String, Map<FileObject, ClassPath>>();
    private final Map<String, Map<List<String>, MutableClassPathImplementation>> mutablePathImpls = new HashMap<String, Map<List<String>, MutableClassPathImplementation>>();
    private final Map<MutableClassPathImplementation, ClassPath> mutableClassPathImpl2ClassPath = new HashMap<MutableClassPathImplementation, ClassPath>();
    private Map<String, Set<ClassPath>> registeredClasspaths = null;
    private static final String[] TYPES = new String[]{"classpath/source", "classpath/boot", "classpath/execute", "classpath/compile"};

    public Classpaths(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, AuxiliaryConfiguration auxiliaryConfiguration) {
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.aux = auxiliaryConfiguration;
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
        propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public ClassPath findClassPath(final FileObject fileObject, final String string) {
        return (ClassPath)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ClassPath>(){

            public ClassPath run() {
                return Classpaths.this.findClassPathImpl(fileObject, string);
            }
        });
    }

    private synchronized ClassPath findClassPathImpl(FileObject fileObject, String string) {
        Object object;
        Map<FileObject, ClassPath> map;
        if (TESTING_LATCH != null) {
            TESTING_LATCH.countDown();
            try {
                TESTING_LATCH.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                ErrorManager.getDefault().notify((Throwable)interruptedException);
            }
            this.classpaths.clear();
        }
        if ((map = this.classpaths.get(string)) == null) {
            map = new WeakHashMap<FileObject, ClassPath>();
            this.classpaths.put(string, map);
        }
        for (Map.Entry<FileObject, ClassPath> object22 : map.entrySet()) {
            object = object22.getKey();
            if (object != fileObject && !FileUtil.isParentOf((FileObject)object, (FileObject)fileObject)) continue;
            return object22.getValue();
        }
        Element element = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (element == null) {
            return null;
        }
        object = Util.findSubElements((Element)element);
        Iterator<Map.Entry<Object, Object>> iterator = object.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)((Object)iterator.next());
            assert (element2.getLocalName().equals("compilation-unit")) : element2;
            List<FileObject> list = Classpaths.findPackageRoots(this.helper, this.evaluator, element2);
            Iterator<FileObject> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                FileObject fileObject2 = iterator2.next();
                if (fileObject2 != fileObject && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                ClassPath classPath = this.getPath(element2, list, string);
                for (FileObject fileObject3 : list) {
                    map.put(fileObject3, classPath);
                }
                return classPath;
            }
        }
        return null;
    }

    public void opened() {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Classpaths.this.openedImpl();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openedImpl() {
        HashMap<String, Set<ClassPath>> hashMap;
        Classpaths classpaths = this;
        synchronized (classpaths) {
            if (this.registeredClasspaths != null) {
                return;
            }
            hashMap = new HashMap<String, Set<ClassPath>>();
            String[] object = TYPES;
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                String string = object[i];
                hashMap.put(string, new HashSet());
            }
            Element element = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
            if (element == null) {
                return;
            }
            for (Element element2 : Util.findSubElements((Element)element)) {
                assert (element2.getLocalName().equals("compilation-unit")) : element2;
                List<FileObject> list = Classpaths.findPackageRoots(this.helper, this.evaluator, element2);
                for (String string : TYPES) {
                    FileObject fileObject2;
                    Map<FileObject, ClassPath> map = this.classpaths.get(string);
                    if (map == null) {
                        map = new WeakHashMap<FileObject, ClassPath>();
                        this.classpaths.put(string, map);
                    }
                    Set set = (Set)hashMap.get(string);
                    assert (set != null);
                    ClassPath classPath = null;
                    Iterator<FileObject> iterator = list.iterator();
                    while (iterator.hasNext() && (classPath = map.get(fileObject2 = iterator.next())) == null) {
                    }
                    if (classPath == null) {
                        classPath = this.getPath(element2, list, string);
                        for (FileObject fileObject2 : list) {
                            map.put(fileObject2, classPath);
                        }
                    }
                    assert (classPath != null);
                    set.add(classPath);
                }
            }
            if (err.isLoggable(1)) {
                err.log("classpaths for " + this.helper.getProjectDirectory() + ": " + this.classpaths);
            }
            this.registeredClasspaths = hashMap;
        }
        assert (hashMap != null);
        classpaths = GlobalPathRegistry.getDefault();
        for (String string : TYPES) {
            Set set = (Set)hashMap.get(string);
            classpaths.register(string, set.toArray(new ClassPath[set.size()]));
        }
    }

    private synchronized void registerNewClasspath(String string, ClassPath classPath) {
        if (this.registeredClasspaths == null) {
            return;
        }
        Set<ClassPath> set = this.registeredClasspaths.get(string);
        set.add(classPath);
        GlobalPathRegistry.getDefault().register(string, new ClassPath[]{classPath});
    }

    public synchronized void closed() {
        if (this.registeredClasspaths == null) {
            return;
        }
        GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.getDefault();
        for (int i = 0; i < TYPES.length; ++i) {
            String string = TYPES[i];
            Set<ClassPath> set = this.registeredClasspaths.get(string);
            globalPathRegistry.unregister(string, set.toArray(new ClassPath[set.size()]));
        }
        this.registeredClasspaths = null;
    }

    static List<String> findPackageRootNames(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element2 : Util.findSubElements((Element)element)) {
            if (!element2.getLocalName().equals("package-root")) continue;
            String string = Util.findText((Element)element2);
            arrayList.add(string);
        }
        return arrayList;
    }

    static Map<String, FileObject> findPackageRootsByName(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, List<String> list) {
        LinkedHashMap<String, FileObject> linkedHashMap = new LinkedHashMap<String, FileObject>();
        for (String string : list) {
            File file;
            FileObject fileObject;
            String string2 = propertyEvaluator.evaluate(string);
            if (string2 == null || (fileObject = FileUtil.toFileObject((File)(file = antProjectHelper.resolveFile(string2)))) == null) continue;
            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
            }
            linkedHashMap.put(string, fileObject);
        }
        return linkedHashMap;
    }

    private static List<FileObject> findPackageRoots(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, List<String> list) {
        return new ArrayList<FileObject>(Classpaths.findPackageRootsByName(antProjectHelper, propertyEvaluator, list).values());
    }

    public static List<FileObject> findPackageRoots(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, Element element) {
        return Classpaths.findPackageRoots(antProjectHelper, propertyEvaluator, Classpaths.findPackageRootNames(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getPath(Element element, List<FileObject> list, String string) {
        if (string.equals("classpath/source") || string.equals("classpath/compile") || string.equals("classpath/execute") || string.equals("classpath/boot")) {
            List<String> list2 = Classpaths.findPackageRootNames(element);
            Classpaths classpaths = this;
            synchronized (classpaths) {
                ClassPath classPath;
                MutableClassPathImplementation mutableClassPathImplementation;
                Map<List<String>, MutableClassPathImplementation> map = this.mutablePathImpls.get(string);
                if (map == null) {
                    map = new HashMap<List<String>, MutableClassPathImplementation>();
                    this.mutablePathImpls.put(string, map);
                }
                if ((mutableClassPathImplementation = map.get(list2)) == null) {
                    mutableClassPathImplementation = new MutableClassPathImplementation(list2, string, element);
                    map.put(list2, mutableClassPathImplementation);
                }
                if ((classPath = this.mutableClassPathImpl2ClassPath.get(mutableClassPathImplementation)) == null) {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)mutableClassPathImplementation);
                    this.mutableClassPathImpl2ClassPath.put(mutableClassPathImplementation, classPath);
                    this.registerNewClasspath(string, classPath);
                }
                return classPath;
            }
        }
        return null;
    }

    private List<URL> createSourcePath(List<String> list) {
        ArrayList<URL> arrayList = new ArrayList<URL>(list.size());
        for (String string : list) {
            String string2 = this.evaluator.evaluate(string);
            if (string2 == null) continue;
            arrayList.add(this.createClasspathEntry(string2));
        }
        return arrayList;
    }

    private List<URL> createCompileClasspath(Element element) {
        for (Element element2 : Util.findSubElements((Element)element)) {
            if (!element2.getLocalName().equals("classpath") || !element2.getAttribute("mode").equals("compile")) continue;
            return this.createClasspath(element2);
        }
        return Collections.emptyList();
    }

    private List<URL> createClasspath(Element element) {
        String string;
        String string2 = Util.findText((Element)element);
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.evaluator.evaluate(string2)) == null) {
            return Collections.emptyList();
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string);
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            uRLArray[i] = this.createClasspathEntry(stringArray[i]);
        }
        return Arrays.asList(uRLArray);
    }

    private URL createClasspathEntry(String string) {
        File file = this.helper.resolveFile(string);
        return FileUtil.urlForArchiveOrDir((File)file);
    }

    private List<URL> createExecuteClasspath(List<String> list, Element element) {
        for (Element element2 : Util.findSubElements((Element)element)) {
            if (!element2.getLocalName().equals("classpath") || !element2.getAttribute("mode").equals("execute")) continue;
            return this.createClasspath(element2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.createCompileClasspath(element));
        boolean bl = false;
        for (Element element3 : Util.findSubElements((Element)element)) {
            if (!element3.getLocalName().equals("built-to")) continue;
            bl = true;
            String string = Util.findText((Element)element3);
            assert (string != null) : "Must have nonempty text inside <built-to>";
            String string2 = this.evaluator.evaluate(string);
            if (string2 == null) continue;
            arrayList.add(this.createClasspathEntry(string2));
        }
        if (!bl) {
            arrayList.addAll(this.createSourcePath(list));
        }
        return arrayList;
    }

    private List<URL> createBootClasspath(Element element) {
        Object object2;
        for (Object object2 : Util.findSubElements((Element)element)) {
            if (!object2.getLocalName().equals("classpath") || !object2.getAttribute("mode").equals("boot")) continue;
            return this.createClasspath((Element)object2);
        }
        JavaPlatform javaPlatform = new JdkConfiguration(null, this.helper, this.evaluator).getSelectedPlatform();
        if (javaPlatform == null) {
            object2 = JavaPlatformManager.getDefault();
            javaPlatform = object2.getDefaultPlatform();
        }
        if (javaPlatform != null) {
            object2 = javaPlatform.getBootstrapLibraries().entries();
            ArrayList<URL> arrayList = new ArrayList<URL>(object2.size());
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
                arrayList.add(entry.getURL());
            }
            return arrayList;
        }
        assert (false) : "JavaPlatformManager has no default platform";
        return Collections.emptyList();
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        this.pathsChanged();
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
        this.pathsChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pathsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pathsChanged() {
        Classpaths classpaths = this;
        synchronized (classpaths) {
            this.classpaths.clear();
            for (Map<List<String>, MutableClassPathImplementation> map : this.mutablePathImpls.values()) {
                for (MutableClassPathImplementation mutableClassPathImplementation : map.values()) {
                    mutableClassPathImplementation.change();
                }
            }
        }
    }

    private final class SourcePRI
    implements FilteringPathResourceImplementation,
    PropertyChangeListener,
    AntProjectListener {
        private final URL root;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private PathMatcher matcher;
        private String includes;
        private String excludes;

        public SourcePRI(URL uRL) {
            this.root = uRL;
            Classpaths.this.helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)Classpaths.this.helper));
            Classpaths.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)Classpaths.this.evaluator));
            this.computeMatcher();
        }

        private boolean computeMatcher() {
            String string = null;
            String string2 = null;
            File file = new File(URI.create(this.root.toExternalForm()));
            Element element = Util.getPrimaryConfigurationData((AntProjectHelper)Classpaths.this.helper);
            Element element2 = Util.findElement((Element)element, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (element2 != null) {
                for (Element element3 : Util.findSubElements((Element)element2)) {
                    Element element4;
                    String string3;
                    Element element5;
                    if (!element3.getLocalName().equals("source-folder") || (element5 = Util.findElement((Element)element3, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null || !(string3 = Util.findText((Element)element5)).equals("java")) continue;
                    Element element6 = Util.findElement((Element)element3, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2");
                    String string4 = Classpaths.this.evaluator.evaluate(Util.findText((Element)element6));
                    if (string4 == null || !Classpaths.this.helper.resolveFile(string4).equals(file)) continue;
                    Element element7 = Util.findElement((Element)element3, (String)"includes", (String)"http://www.netbeans.org/ns/freeform-project/2");
                    if (element7 != null && (string = Classpaths.this.evaluator.evaluate(Util.findText((Element)element7))) != null && string.matches("\\$\\{[^}]+\\}")) {
                        string = null;
                    }
                    if ((element4 = Util.findElement((Element)element3, (String)"excludes", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) continue;
                    string2 = Classpaths.this.evaluator.evaluate(Util.findText((Element)element4));
                }
            }
            if (!Utilities.compareObjects(string, (Object)this.includes) || !Utilities.compareObjects(string2, (Object)this.excludes)) {
                this.includes = string;
                this.excludes = string2;
                this.matcher = new PathMatcher(string, string2, file);
                return true;
            }
            if (this.matcher == null) {
                this.matcher = new PathMatcher(string, string2, file);
            }
            return false;
        }

        public URL[] getRoots() {
            return new URL[]{this.root};
        }

        public boolean includes(URL uRL, String string) {
            return this.matcher.matches(string, true);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.change(propertyChangeEvent);
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            this.change(antProjectEvent);
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }

        private void change(Object object) {
            if (this.computeMatcher()) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "includes", null, null);
                propertyChangeEvent.setPropagationId(object);
                this.pcs.firePropertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MutableClassPathImplementation
    implements ClassPathImplementation {
        private final List<String> packageRootNames;
        private final String type;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private List<URL> roots;
        private List<PathResourceImplementation> resources;

        public MutableClassPathImplementation(List<String> list, String string, Element element) {
            this.packageRootNames = list;
            this.type = string;
            this.initRoots(element);
        }

        private Element findCompilationUnit() {
            Element element = Classpaths.this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
            if (element == null) {
                return null;
            }
            List list = Util.findSubElements((Element)element);
            for (Element element2 : list) {
                assert (element2.getLocalName().equals("compilation-unit")) : element2;
                if (!((Object)this.packageRootNames).equals(Classpaths.findPackageRootNames(element2))) continue;
                return element2;
            }
            return null;
        }

        private boolean initRoots(Element element) {
            List<URL> list = this.roots;
            if (element != null) {
                if (this.type.equals("classpath/source")) {
                    this.roots = Classpaths.this.createSourcePath(this.packageRootNames);
                } else if (this.type.equals("classpath/compile")) {
                    this.roots = Classpaths.this.createCompileClasspath(element);
                } else if (this.type.equals("classpath/execute")) {
                    this.roots = Classpaths.this.createExecuteClasspath(this.packageRootNames, element);
                } else {
                    assert (this.type.equals("classpath/boot")) : this.type;
                    this.roots = Classpaths.this.createBootClasspath(element);
                }
            } else {
                this.roots = Collections.emptyList();
            }
            assert (this.roots != null);
            if (!((Object)this.roots).equals(list)) {
                this.resources = new ArrayList<PathResourceImplementation>(this.roots.size());
                for (URL uRL : this.roots) {
                    if (uRL == null) continue;
                    assert (uRL.toExternalForm().endsWith("/")) : "Had bogus roots " + this.roots + " for type " + this.type + " in " + Classpaths.access$700(Classpaths.this).getProjectDirectory();
                    Object object = this.type.equals("classpath/source") ? new SourcePRI(uRL) : ClassPathSupport.createResource((URL)uRL);
                    this.resources.add((PathResourceImplementation)object);
                }
                return true;
            }
            return false;
        }

        public List<PathResourceImplementation> getResources() {
            return this.resources;
        }

        public void change() {
            if (this.initRoots(this.findCompilationUnit())) {
                if (err.isLoggable(1)) {
                    err.log("MutableClassPathImplementation.change: packageRootNames=" + this.packageRootNames + " type=" + this.type + " roots=" + this.roots);
                }
                this.pcs.firePropertyChange("resources", null, null);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

