/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LineBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private static final String HELP_ID = "NetbeansDebuggerBreakpointLineJPDA";
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private LineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JPanel cPanel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JTextField tfFileName;
    private JTextField tfLineNumber;

    public LineBreakpointPanel(LineBreakpoint lineBreakpoint) {
        this.breakpoint = lineBreakpoint;
        this.initComponents();
        String string = lineBreakpoint.getURL();
        try {
            URI uRI = new URI(string);
            this.tfFileName.setText(uRI.getPath());
        }
        catch (Exception exception) {
            this.tfFileName.setText(string);
        }
        this.tfFileName.setPreferredSize(new Dimension(30 * this.tfFileName.getFontMetrics(this.tfFileName.getFont()).charWidth('W'), this.tfFileName.getPreferredSize().height));
        this.tfLineNumber.setText(Integer.toString(lineBreakpoint.getLineNumber()));
        this.conditionsPanel = new ConditionsPanel(HELP_ID);
        this.setupConditionPane();
        this.conditionsPanel.showClassFilter(false);
        this.conditionsPanel.setCondition(lineBreakpoint.getCondition());
        this.conditionsPanel.setHitCountFilteringStyle(lineBreakpoint.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(lineBreakpoint.getHitCountFilter());
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)lineBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    private static int findNumLines(String string) {
        DataObject dataObject;
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return 0;
        }
        if (fileObject == null) {
            return 0;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return 0;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return 0;
        }
        editorCookie.prepareDocument().waitFinished();
        StyledDocument styledDocument = editorCookie.getDocument();
        if (!(styledDocument instanceof StyledDocument)) {
            return 0;
        }
        StyledDocument styledDocument2 = styledDocument;
        return NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getLength());
    }

    private void setupConditionPane() {
        this.conditionsPanel.setupConditionPaneContext(this.breakpoint.getURL(), this.breakpoint.getLineNumber());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.tfFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfLineNumber = new JTextField();
        this.cPanel = new JPanel();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Line_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.tfFileName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("L_Line_Breakpoint_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.tfFileName.setEditable(false);
        this.tfFileName.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_File_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFileName, gridBagConstraints);
        this.tfFileName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.jLabel1.setLabelFor(this.tfLineNumber);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("L_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName("Line number");
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LineBreakpointPanel.class, (String)"ACSN_LineBreakpoint"));
    }

    public boolean ok() {
        String string = this.valiadateMsg();
        if (string == null) {
            string = this.conditionsPanel.valiadateMsg();
        }
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        this.actionsPanel.ok();
        this.breakpoint.setLineNumber(Integer.parseInt(this.tfLineNumber.getText().trim()));
        this.breakpoint.setCondition(this.conditionsPanel.getCondition());
        this.breakpoint.setHitCountFilter(this.conditionsPanel.getHitCount(), this.conditionsPanel.getHitCountFilteringStyle());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    private String valiadateMsg() {
        int n;
        try {
            n = Integer.parseInt(this.tfLineNumber.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_Line_Number_Spec");
        }
        if (n <= 0) {
            return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonPositive_Line_Number_Spec");
        }
        int n2 = LineBreakpointPanel.findNumLines(this.breakpoint.getURL());
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (n > n2 + 1) {
            return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_TooBig_Line_Number_Spec", (Object)Integer.toString(n), (Object)Integer.toString(n2 + 1));
        }
        return null;
    }
}

