/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsListener;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingTreeModel;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTreeView
extends BeanTreeView {
    private int thickness = 0;
    private Color highlightColor = new Color(233, 239, 248);
    private Color currentThreadColor = new Color(233, 255, 230);
    private Color whiteColor = UIManager.getDefaults().getColor("Tree.background");
    private JPDAThread focusedThread;

    DebugTreeView() {
        this.setBackground(this.whiteColor);
        this.tree.setOpaque(false);
        this.tree.setBackground(this.whiteColor);
        ((JComponent)this.tree.getParent()).setOpaque(false);
        ((JComponent)this.tree.getParent()).setBackground(this.whiteColor);
        this.setWheelScrollingEnabled(false);
    }

    public JTree getTree() {
        return this.tree;
    }

    void resetSelection() {
        this.tree.getSelectionModel().clearSelection();
        DebugTreeView.clearSelectionCache(this.tree.getSelectionModel().getRowMapper());
        DebugTreeView.clearDrawingCache(this.tree);
        this.tree.repaint();
    }

    private static void clearSelectionCache(RowMapper rowMapper) {
        if (rowMapper instanceof FixedHeightLayoutCache) {
            try {
                Field field = rowMapper.getClass().getDeclaredField("info");
                field.setAccessible(true);
                Object object = field.get(rowMapper);
                if (object != null) {
                    Field field2 = object.getClass().getDeclaredField("node");
                    field2.setAccessible(true);
                    field2.set(object, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void clearDrawingCache(JTree jTree) {
        TreeUI treeUI = jTree.getUI();
        if (treeUI instanceof BasicTreeUI) {
            try {
                Field field = BasicTreeUI.class.getDeclaredField("drawingCache");
                field.setAccessible(true);
                Map map = (Map)field.get(treeUI);
                map.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreePath> getVisiblePaths() {
        JTree jTree = this.tree;
        synchronized (jTree) {
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            int n = this.tree.getRowCount();
            for (int i = 0; i < n; ++i) {
                TreePath treePath = this.tree.getPathForRow(i);
                if (!this.tree.isVisible(treePath)) continue;
                arrayList.add(treePath);
            }
            return arrayList;
        }
    }

    public Object getJPDAObject(TreePath treePath) {
        Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
        JPDAThread jPDAThread = (JPDAThread)node.getLookup().lookup(JPDAThread.class);
        if (jPDAThread != null) {
            return jPDAThread;
        }
        JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)node.getLookup().lookup(JPDAThreadGroup.class);
        return jPDAThreadGroup;
    }

    public int getUnitHeight() {
        return this.thickness;
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.tree.addTreeExpansionListener(treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.tree.removeTreeExpansionListener(treeExpansionListener);
    }

    void setExpansionModel(TreeExpansionModel treeExpansionModel) {
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintStripes(graphics, (JComponent)((Object)this));
    }

    void paintStripes(Graphics graphics, JComponent jComponent) {
        int n;
        JPDAThread jPDAThread;
        int n2;
        int n3;
        int n4;
        int n5;
        Rectangle rectangle;
        List<TreePath> list = this.getVisiblePaths();
        int n6 = list.size();
        Rectangle rectangle2 = rectangle = list.size() > 0 ? this.tree.getRowBounds(this.tree.getRowForPath(list.get(0))) : null;
        if (rectangle != null) {
            this.thickness = (int)Math.round(rectangle.getHeight());
        }
        int n7 = this.thickness > 0 ? this.thickness : (this.tree.getRowHeight() > 0 ? this.tree.getRowHeight() + 2 : 18);
        int n8 = n6 * n7;
        int n9 = jComponent.getWidth();
        int n10 = jComponent.getHeight();
        if (n9 <= 0 || n10 <= 0) {
            return;
        }
        Rectangle rectangle3 = graphics.getClipBounds();
        if (rectangle3 == null) {
            n5 = 0;
            n4 = 0;
            n3 = n9;
            n2 = n10;
        } else {
            n4 = rectangle3.x;
            n5 = rectangle3.y;
            n3 = rectangle3.width;
            n2 = rectangle3.height;
        }
        if (n3 > n9) {
            n3 = n9;
        }
        if (n2 > n10) {
            n2 = n10;
        }
        Color color = graphics.getColor();
        ThreadsListener threadsListener = ThreadsListener.getDefault();
        JPDADebugger jPDADebugger = threadsListener != null ? threadsListener.getDebugger() : null;
        JPDAThread jPDAThread2 = jPDAThread = jPDADebugger != null ? jPDADebugger.getCurrentThread() : null;
        if (jPDAThread != null && !jPDAThread.isSuspended() && !DebuggingTreeModel.isMethodInvoking(jPDAThread)) {
            jPDAThread = null;
        }
        boolean bl = false;
        boolean bl2 = false;
        Iterator<TreePath> iterator = list.iterator();
        int n11 = n5 / n7;
        for (n = 0; n <= n11 && iterator.hasNext(); ++n) {
            Node node = Visualizer.findNode((Object)iterator.next().getLastPathComponent());
            JPDAThread jPDAThread3 = (JPDAThread)node.getLookup().lookup(JPDAThread.class);
            boolean bl3 = bl = this.focusedThread != null && jPDAThread3 == this.focusedThread;
            if (jPDAThread3 == null) continue;
            bl2 = jPDAThread == jPDAThread3;
        }
        int n12 = Math.min(n5 + n2 - 1, n8);
        for (n = n5 / n7 * n7; n < n12; n += n7) {
            int n13 = Math.max(n, n5);
            int n14 = Math.min(n5 + n2, n13 + n7);
            if (bl || bl2) {
                graphics.setColor(bl ? this.highlightColor : this.currentThreadColor);
                graphics.fillRect(n4, n13, n3, n14 - n13);
            }
            if (iterator.hasNext()) {
                Node node = Visualizer.findNode((Object)iterator.next().getLastPathComponent());
                JPDAThread jPDAThread4 = (JPDAThread)node.getLookup().lookup(JPDAThread.class);
                boolean bl4 = bl = this.focusedThread != null && jPDAThread4 == this.focusedThread;
                if (jPDAThread4 == null) continue;
                bl2 = jPDAThread == jPDAThread4;
                continue;
            }
            bl = false;
            bl2 = false;
        }
        graphics.setColor(color);
    }

    boolean threadFocuseGained(JPDAThread jPDAThread) {
        if (jPDAThread != null && this.focusedThread != jPDAThread) {
            this.focusedThread = jPDAThread;
            this.repaint();
            return true;
        }
        return false;
    }

    boolean threadFocuseLost(JPDAThread jPDAThread) {
        if (jPDAThread != null && this.focusedThread == jPDAThread) {
            this.focusedThread = null;
            this.repaint();
            return true;
        }
        return false;
    }
}

