/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.source.ui.JavaTypeDescription;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JavaTypeProvider
implements TypeProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaTypeProvider.class.getName());
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private Set<CacheItem> cache;
    private volatile boolean isCanceled = false;
    private final TypeElementFinder.Customizer customizer;
    private ClasspathInfo cpInfo;
    private GlobalPathRegistryListener pathListener;

    public String name() {
        return "java";
    }

    public String getDisplayName() {
        return "Java Classes";
    }

    public void cleanup() {
        this.isCanceled = false;
        this.cache = null;
        if (this.pathListener != null) {
            GlobalPathRegistry.getDefault().removeGlobalPathRegistryListener(this.pathListener);
        }
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public JavaTypeProvider() {
        this(null, null);
    }

    public JavaTypeProvider(ClasspathInfo classpathInfo, TypeElementFinder.Customizer customizer) {
        this.cpInfo = classpathInfo;
        this.customizer = customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTypeNames(TypeProvider.Context context, final TypeProvider.Result result) {
        Object object;
        Object object2;
        Iterator<CacheItem> iterator;
        Object object4;
        AbstractCollection abstractCollection;
        ClassIndex.NameKind nameKind;
        this.isCanceled = false;
        String string = context.getText();
        SearchType searchType = context.getSearchType();
        boolean bl = Lookup.getDefault().lookup(BinaryElementOpen.class) != null;
        switch (searchType) {
            case EXACT_NAME: {
                nameKind = ClassIndex.NameKind.SIMPLE_NAME;
                break;
            }
            case CASE_INSENSITIVE_EXACT_NAME: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case PREFIX: {
                nameKind = ClassIndex.NameKind.PREFIX;
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
                break;
            }
            case REGEXP: {
                nameKind = ClassIndex.NameKind.REGEXP;
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case CAMEL_CASE: {
                nameKind = ClassIndex.NameKind.CAMEL_CASE;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected search type: " + searchType);
            }
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        Future future = OpenProjects.getDefault().openProjects();
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.fine(interruptedException.getMessage());
        }
        catch (ExecutionException executionException) {
            LOGGER.fine(executionException.getMessage());
        }
        if (this.cache == null) {
            Object object5;
            abstractCollection = null;
            if (this.cpInfo == null) {
                l = System.currentTimeMillis();
                object5 = RepositoryUpdater.getDefault().getScannedSources();
                object4 = object5.entries();
                l7 += System.currentTimeMillis() - l;
                abstractCollection = new HashSet(object4.size());
                iterator = object4.iterator();
                while (iterator.hasNext()) {
                    ClassPath.Entry object32 = (ClassPath.Entry)iterator.next();
                    l = System.currentTimeMillis();
                    object2 = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{object32.getURL()}));
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem(object32.getURL(), (ClasspathInfo)object2, false));
                    l8 += System.currentTimeMillis() - l;
                }
                l = System.currentTimeMillis();
                object5 = RepositoryUpdater.getDefault().getScannedBinaries();
                object4 = object5.entries();
                l6 += System.currentTimeMillis() - l;
                iterator = object4.iterator();
                while (iterator.hasNext()) {
                    ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
                    try {
                        if (this.isCanceled) {
                            return;
                        }
                        l = System.currentTimeMillis();
                        if (!bl && (object2 = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL())).getRoots().length == 0) continue;
                        l5 += System.currentTimeMillis() - l;
                        l = System.currentTimeMillis();
                        object2 = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{entry.getURL()}), (ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH);
                        abstractCollection.add(new CacheItem(entry.getURL(), (ClasspathInfo)object2, true));
                        l8 += System.currentTimeMillis() - l;
                    }
                    finally {
                        if (!this.isCanceled) continue;
                        return;
                    }
                }
            } else {
                object5 = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT).entries();
                object4 = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).entries();
                iterator = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).entries();
                abstractCollection = new HashSet(object5.size() + object4.size() + iterator.size());
                Iterator iterator2 = object5.iterator();
                while (iterator2.hasNext()) {
                    object2 = (ClassPath.Entry)iterator2.next();
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{object2.getURL()}), (ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH);
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem(object2.getURL(), (ClasspathInfo)object, true));
                    l8 += System.currentTimeMillis() - l;
                }
                Iterator iterator3 = object4.iterator();
                while (iterator3.hasNext()) {
                    object2 = (ClassPath.Entry)iterator3.next();
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{object2.getURL()}), (ClassPath)EMPTY_CLASSPATH);
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem(object2.getURL(), (ClasspathInfo)object, true));
                    l8 += System.currentTimeMillis() - l;
                }
                Iterator iterator4 = iterator.iterator();
                while (iterator4.hasNext()) {
                    object2 = (ClassPath.Entry)iterator4.next();
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{object2.getURL()}));
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem(object2.getURL(), (ClasspathInfo)object, false));
                    l8 += System.currentTimeMillis() - l;
                }
            }
            if (!this.isCanceled) {
                this.cache = abstractCollection;
            } else {
                return;
            }
        }
        abstractCollection = new ArrayList(this.cache.size() * 20);
        boolean bl2 = RepositoryUpdater.getDefault().isScanInProgress();
        if (bl2) {
            object4 = NbBundle.getMessage(JavaTypeProvider.class, (String)"LBL_ScanInProgress_warning");
            result.setMessage((String)object4);
        } else {
            result.setMessage(null);
        }
        switch (nameKind) {
            case REGEXP: 
            case CASE_INSENSITIVE_REGEXP: {
                string = JavaTypeProvider.removeNonJavaChars(string);
                iterator = searchType == SearchType.CASE_INSENSITIVE_EXACT_NAME ? string : string + "*";
                iterator = ((String)((Object)iterator)).replace("*", ".*").replace('?', '.');
                object4 = iterator;
                break;
            }
            default: {
                object4 = string;
            }
        }
        LOGGER.fine("Text For Query '" + string + "'.");
        if (this.customizer != null) {
            for (CacheItem cacheItem : this.cache) {
                l = System.currentTimeMillis();
                object2 = this.customizer.query(cacheItem.classpathInfo, (String)object4, nameKind, EnumSet.of(cacheItem.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
                object = object2.iterator();
                while (object.hasNext()) {
                    ElementHandle elementHandle = (ElementHandle)object.next();
                    JavaTypeDescription javaTypeDescription = new JavaTypeDescription(cacheItem, (ElementHandle<TypeElement>)elementHandle);
                    ((ArrayList)abstractCollection).add(javaTypeDescription);
                    if (!this.isCanceled) continue;
                    return;
                }
            }
        } else {
            for (CacheItem cacheItem : this.cache) {
                object2 = cacheItem.classpathInfo.getClassIndex().getDeclaredTypes((String)object4, nameKind, EnumSet.of(cacheItem.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
                object = object2.iterator();
                while (object.hasNext()) {
                    ElementHandle elementHandle = (ElementHandle)object.next();
                    JavaTypeDescription javaTypeDescription = new JavaTypeDescription(cacheItem, (ElementHandle<TypeElement>)elementHandle);
                    ((ArrayList)abstractCollection).add(javaTypeDescription);
                    if (!this.isCanceled) continue;
                    return;
                }
            }
            if (((ArrayList)abstractCollection).isEmpty() && bl2) {
                try {
                    iterator = ClassPathSupport.createClassPath((URL[])new URL[0]);
                    ClasspathInfo classpathInfo = ClasspathInfo.create(iterator, iterator, iterator);
                    object2 = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
                    object = object2.runWhenScanFinished((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            LOGGER.fine("Restarting search...");
                            result.setMessage(null);
                        }
                    }, false);
                    object.get();
                    this.cache = null;
                    this.cpInfo = null;
                    this.computeTypeNames(context, result);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)executionException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (this.isCanceled) {
                return;
            }
            l4 += System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            l3 += System.currentTimeMillis() - l;
        }
        if (!this.isCanceled) {
            l = System.currentTimeMillis();
            LOGGER.fine("PERF -  GSS:  " + l7 + " GSB " + l6 + " CP: " + l8 + " SFB: " + l5 + " GTN: " + l4 + "  ADD: " + l3 + "  SORT: " + (l2 += System.currentTimeMillis() - l));
            result.addResult((List)((Object)abstractCollection));
        }
    }

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String removeNonJavaChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static class CacheItem {
        public final boolean isBinary;
        public final URL root;
        public final ClasspathInfo classpathInfo;
        public String projectName;
        public Icon projectIcon;
        private ClassPath.Entry defEntry;
        private FileObject cachedRoot;

        public CacheItem(URL uRL, ClasspathInfo classpathInfo, boolean bl) {
            this.isBinary = bl;
            this.root = uRL;
            this.classpathInfo = classpathInfo;
        }

        public int hashCode() {
            return this.root == null ? 0 : this.root.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CacheItem) {
                CacheItem cacheItem = (CacheItem)object;
                return this.root == null ? cacheItem.root == null : this.root.equals(cacheItem.root);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject getRoot() {
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                if (this.cachedRoot != null) {
                    return this.cachedRoot;
                }
            }
            cacheItem = URLMapper.findFileObject((URL)this.root);
            CacheItem cacheItem2 = this;
            synchronized (cacheItem2) {
                if (this.cachedRoot == null) {
                    this.cachedRoot = cacheItem;
                }
            }
            return cacheItem;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        private void initProjectInfo() {
            try {
                Project project = FileOwnerQuery.getOwner((URI)this.root.toURI());
                if (project != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    this.projectName = projectInformation.getDisplayName();
                    this.projectIcon = projectInformation.getIcon();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
    }
}

