/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTable;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.CopySupport;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyCookie;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.actions.AddAction;
import org.netbeans.modules.form.actions.AlignAction;
import org.netbeans.modules.form.actions.BindAction;
import org.netbeans.modules.form.actions.ChooseSameSizeAction;
import org.netbeans.modules.form.actions.CustomCodeAction;
import org.netbeans.modules.form.actions.CustomizeEmptySpaceAction;
import org.netbeans.modules.form.actions.CustomizeLayoutAction;
import org.netbeans.modules.form.actions.DefaultSizeAction;
import org.netbeans.modules.form.actions.DesignParentAction;
import org.netbeans.modules.form.actions.DuplicateAction;
import org.netbeans.modules.form.actions.EditContainerAction;
import org.netbeans.modules.form.actions.EncloseAction;
import org.netbeans.modules.form.actions.EventsAction;
import org.netbeans.modules.form.actions.InPlaceEditAction;
import org.netbeans.modules.form.actions.PropertyAction;
import org.netbeans.modules.form.actions.SelectLayoutAction;
import org.netbeans.modules.form.actions.SetAnchoringAction;
import org.netbeans.modules.form.actions.SetResizabilityAction;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.editors.TableCustomizer;
import org.netbeans.modules.form.layoutsupport.LayoutNode;
import org.netbeans.modules.form.menu.AddSubItemAction;
import org.netbeans.modules.form.menu.InsertMenuAction;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CustomizeAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.explorer.propertysheet.editors.NodeCustomizer;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RADComponentNode
extends FormNode
implements RADComponentCookie,
FormPropertyCookie {
    private static final MessageFormat nodeNameFormat = new MessageFormat(FormUtils.getBundleString("FMT_ComponentNodeName"));
    private static final MessageFormat nodeNoNameFormat = new MessageFormat(FormUtils.getBundleString("FMT_UnnamedComponentNodeName"));
    private RADComponent component;
    private boolean highlightDisplayName;
    private Map<Integer, Image> img = new HashMap<Integer, Image>();
    private static boolean iconsInitialized;

    public RADComponentNode(RADComponent rADComponent) {
        this((Children)(rADComponent instanceof ComponentContainer ? new RADChildren((ComponentContainer)((Object)rADComponent)) : Children.LEAF), rADComponent);
    }

    public RADComponentNode(Children children, RADComponent rADComponent) {
        super(children, rADComponent.getFormModel());
        this.component = rADComponent;
        rADComponent.setNodeReference(this);
        if (rADComponent instanceof ComponentContainer) {
            this.getCookieSet().add((Node.Cookie)new ComponentsIndex());
        }
        this.updateName();
    }

    void updateName() {
        String string = Utilities.getShortClassName(this.component.getBeanClass());
        if (this.component == this.component.getFormModel().getTopRADComponent()) {
            this.setDisplayName(nodeNoNameFormat.format(new Object[]{string}));
        } else {
            this.setDisplayName(nodeNameFormat.format(new Object[]{this.getName(), string}));
        }
    }

    public void fireComponentPropertiesChange() {
        this.firePropertyChange(null, null, null);
    }

    public void fireComponentPropertySetsChange() {
        this.firePropertySetsChange(null, null);
    }

    public Image getIcon(final int n) {
        Image image = this.img.get(n);
        if (image != null) {
            return image;
        }
        image = BeanSupport.getBeanIcon(this.component.getBeanClass(), n);
        if (image == null) {
            if (!iconsInitialized) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Image image = PaletteUtils.getIconForClass(RADComponentNode.this.component.getBeanClass().getName(), n, true);
                        iconsInitialized = true;
                        if (image != null) {
                            RADComponentNode.this.img.put(n, image);
                            RADComponentNode.this.fireIconChange();
                        }
                    }
                });
            } else {
                image = PaletteUtils.getIconForClass(this.component.getBeanClass().getName(), n, false);
            }
            if (image == null) {
                BeanInfo beanInfo = this.component.getBeanInfo();
                if (beanInfo != null) {
                    image = beanInfo.getIcon(n);
                }
                if (image == null) {
                    image = super.getIcon(n);
                }
            }
        }
        this.img.put(n, image);
        return image;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.components.editing");
    }

    public Node.PropertySet[] getPropertySets() {
        return this.component.getProperties();
    }

    public NewType[] getNewTypes() {
        return this.component.getNewTypes();
    }

    public Action getPreferredAction() {
        FormEditor formEditor = FormEditor.getFormEditor(this.component.getFormModel());
        if (formEditor == null) {
            return null;
        }
        for (Action action : formEditor.getDefaultComponentActions()) {
            if (!action.isEnabled()) continue;
            return action;
        }
        return null;
    }

    @Override
    public Action[] getActions(boolean bl) {
        if (this.actions == null) {
            int n;
            Object object;
            ArrayList<Action> arrayList = new ArrayList<Action>(20);
            RADComponent rADComponent = this.component.getFormModel().getTopRADComponent();
            if (this.component.isReadOnly()) {
                if (this.component == rADComponent) {
                    arrayList.add((Action)SystemAction.get(TestAction.class));
                    arrayList.add(null);
                }
                object = this.component.getKnownEvents();
                for (n = 0; n < ((Event[])object).length; ++n) {
                    if (!object[n].hasEventHandlers()) continue;
                    arrayList.add((Action)SystemAction.get(EventsAction.class));
                    arrayList.add(null);
                    break;
                }
                arrayList.add((Action)SystemAction.get(CopyAction.class));
            } else {
                if (InPlaceEditLayer.supportsEditingFor(this.component.getBeanClass(), false)) {
                    arrayList.add((Action)SystemAction.get(InPlaceEditAction.class));
                }
                if (JTable.class.isAssignableFrom(this.component.getBeanClass())) {
                    arrayList.add((Action)SystemAction.get(CustomizeTableAction.class));
                }
                if (this.component != rADComponent) {
                    arrayList.add((Action)SystemAction.get(ChangeVariableNameAction.class));
                } else {
                    arrayList.add((Action)SystemAction.get(TestAction.class));
                }
                arrayList.add((Action)SystemAction.get(BindAction.class));
                arrayList.add((Action)SystemAction.get(EventsAction.class));
                arrayList.add(null);
                object = this.component.getActionProperties();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    RADProperty rADProperty = (RADProperty)((Object)iterator.next());
                    PropertyAction propertyAction = PropertyAction.createIfEditable(rADProperty);
                    if (propertyAction == null) continue;
                    arrayList.add(propertyAction);
                }
                RADComponentNode.addSeparator(arrayList);
                if (this.component instanceof ComponentContainer) {
                    this.addContainerActions(arrayList);
                    this.addLayoutActions(arrayList);
                } else {
                    this.addLayoutActions(arrayList);
                    this.addContainerActions(arrayList);
                }
                if (this.component != rADComponent) {
                    arrayList.add((Action)SystemAction.get(MoveUpAction.class));
                    arrayList.add((Action)SystemAction.get(MoveDownAction.class));
                }
                if (this.component instanceof ComponentContainer) {
                    arrayList.add((Action)SystemAction.get(ReorderAction.class));
                }
                RADComponentNode.addSeparator(arrayList);
                if (this.component != rADComponent) {
                    arrayList.add((Action)SystemAction.get(CutAction.class));
                }
                arrayList.add((Action)SystemAction.get(CopyAction.class));
                if (this.component instanceof ComponentContainer) {
                    arrayList.add((Action)SystemAction.get(PasteAction.class));
                }
                if (this.component != rADComponent) {
                    arrayList.add((Action)SystemAction.get(DuplicateAction.class));
                    arrayList.add((Action)SystemAction.get(DeleteAction.class));
                }
                arrayList.add(null);
                arrayList.add((Action)SystemAction.get(CustomCodeAction.class));
            }
            arrayList.add(null);
            object = super.getActions(bl);
            for (n = 0; n < ((Object[])object).length; ++n) {
                arrayList.add((Action)object[n]);
            }
            this.actions = new Action[arrayList.size()];
            arrayList.toArray(this.actions);
        }
        return this.actions;
    }

    private void addLayoutActions(List<Action> list) {
        if (this.component.getParentComponent() instanceof RADVisualContainer) {
            list.add((Action)SystemAction.get(AlignAction.class));
            list.add((Action)SystemAction.get(SetAnchoringAction.class));
            list.add((Action)SystemAction.get(SetResizabilityAction.class));
            list.add((Action)SystemAction.get(ChooseSameSizeAction.class));
            list.add((Action)SystemAction.get(DefaultSizeAction.class));
            list.add((Action)SystemAction.get(CustomizeEmptySpaceAction.class));
            list.add((Action)SystemAction.get(EncloseAction.class));
            list.add(null);
        }
    }

    private void addContainerActions(List<Action> list) {
        if (this.component instanceof RADVisualContainer) {
            if (!((RADVisualContainer)this.component).hasDedicatedLayoutSupport()) {
                list.add((Action)SystemAction.get(SelectLayoutAction.class));
                list.add((Action)SystemAction.get(CustomizeLayoutAction.class));
            }
            if (MenuEditLayer.isMenuBarContainer(this.component)) {
                list.add((Action)SystemAction.get(InsertMenuAction.class));
            } else if (MenuEditLayer.isMenuRelatedContainer(this.component)) {
                list.add((Action)SystemAction.get(AddSubItemAction.class));
            } else {
                list.add((Action)SystemAction.get(AddAction.class));
            }
        }
        if (this.getNewTypes().length != 0) {
            list.add(null);
            list.add((Action)SystemAction.get(NewAction.class));
        }
        if (EditContainerAction.isEditableComponent(this.component)) {
            list.add((Action)SystemAction.get(EditContainerAction.class));
        }
        if (DesignParentAction.isParentEditableComponent(this.component)) {
            list.add((Action)SystemAction.get(DesignParentAction.class));
        }
        if (this.component instanceof RADVisualComponent && this.component.getParentComponent() == null) {
            list.add((Action)SystemAction.get(DefaultSizeAction.class));
        }
        RADComponentNode.addSeparator(list);
    }

    private static void addSeparator(List<Action> list) {
        int n = list.size();
        if (n > 0 && list.get(n - 1) != null) {
            list.add(null);
        }
    }

    public String getName() {
        return this.component.getName();
    }

    public void setName(String string) {
        this.component.rename(string);
    }

    public boolean canRename() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public boolean canDestroy() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public void destroy() throws IOException {
        if (this.component.getNodeReference() == this) {
            if (MetaComponentCreator.isTransparentLayoutComponent(this.component.getParentComponent())) {
                this.component = this.component.getParentComponent();
            }
            if (EventQueue.isDispatchThread()) {
                this.component.getFormModel().removeComponent(this.component, true);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        RADComponentNode.this.component.getFormModel().removeComponent(RADComponentNode.this.component, true);
                    }
                });
            }
        }
        super.destroy();
    }

    public boolean hasCustomizer() {
        return !this.component.isReadOnly() && this.component.getBeanInfo().getBeanDescriptor().getCustomizerClass() != null;
    }

    @Override
    protected Component createCustomizer() {
        Object obj;
        Class<Object> clazz = this.component.getBeanInfo().getBeanDescriptor().getCustomizerClass();
        if (clazz == null) {
            if (JTable.class.isAssignableFrom(this.component.getBeanClass())) {
                clazz = TableCustomizer.class;
            } else {
                return null;
            }
        }
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            ErrorManager.getDefault().notify(16, (Throwable)instantiationException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(16, (Throwable)illegalAccessException);
            return null;
        }
        if (!(obj instanceof Component) || !(obj instanceof Customizer)) {
            return null;
        }
        if (obj instanceof NodeCustomizer) {
            ((NodeCustomizer)obj).attach((Node)this.component.getNodeReference());
        }
        Customizer customizer = (Customizer)obj;
        customizer.setObject(this.component.getBeanInstance());
        if (obj instanceof FormAwareEditor) {
            Node.Property property = this.component.getProperties()[0].getProperties()[0];
            ((FormAwareEditor)obj).setContext(this.component.getFormModel(), (FormProperty)property);
        }
        customizer.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FormProperty[] formPropertyArray;
                if (propertyChangeEvent.getPropertyName() != null) {
                    RADProperty rADProperty = RADComponentNode.this.component.getBeanProperty(propertyChangeEvent.getPropertyName());
                    if (rADProperty == null) return;
                    formPropertyArray = new FormProperty[]{rADProperty};
                } else {
                    formPropertyArray = RADComponentNode.this.component.getAllBeanProperties();
                    propertyChangeEvent = null;
                }
                RADComponentNode.this.updatePropertiesFromCustomizer(formPropertyArray, propertyChangeEvent);
            }
        });
        return (Component)obj;
    }

    private void updatePropertiesFromCustomizer(final FormProperty[] formPropertyArray, final PropertyChangeEvent propertyChangeEvent) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object object = propertyChangeEvent != null ? propertyChangeEvent.getOldValue() : null;
                Object object2 = propertyChangeEvent != null ? propertyChangeEvent.getNewValue() : null;
                for (int i = 0; i < formPropertyArray.length; ++i) {
                    FormProperty formProperty = formPropertyArray[i];
                    try {
                        formProperty.reinstateProperty();
                        formProperty.propertyValueChanged(object, object2);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public Transferable clipboardCopy() throws IOException {
        return new CopySupport.RADTransferable(CopySupport.getComponentCopyFlavor(), this.component);
    }

    public Transferable clipboardCut() throws IOException {
        return new CopySupport.RADTransferable(CopySupport.getComponentCutFlavor(), this.component);
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        CopySupport.createPasteTypes(transferable, list, this.component.getFormModel(), this.component);
    }

    @Override
    public RADComponent getRADComponent() {
        return this.component;
    }

    @Override
    public FormProperty getProperty(String string) {
        return this.component.getPropertyByName(string, FormProperty.class, true);
    }

    public String getHtmlDisplayName() {
        if (this.highlightDisplayName) {
            return "<html><b>" + this.getDisplayName() + "</b></html>";
        }
        return "<html>" + this.getDisplayName() + "</html>";
    }

    void highlightDisplayName(boolean bl) {
        if (bl != this.highlightDisplayName) {
            this.highlightDisplayName = bl;
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }

    private static final class CustomizeTableAction
    extends CustomizeAction {
        private CustomizeTableAction() {
        }

        public String getName() {
            return FormUtils.getBundleString("NAME_CustomizeTableAction");
        }

        protected boolean enable(Node[] nodeArray) {
            return true;
        }
    }

    private static final class ChangeVariableNameAction
    extends RenameAction {
        private ChangeVariableNameAction() {
        }

        public String getName() {
            return NbBundle.getMessage(ChangeVariableNameAction.class, (String)"ChangeVariableNameAction");
        }
    }

    private final class ComponentsIndex
    extends Index.Support {
        private ComponentsIndex() {
        }

        public Node[] getNodes() {
            Object object = RADComponentNode.this.component instanceof RADVisualContainer ? ((RADVisualContainer)RADComponentNode.this.component).getSubComponents() : (RADComponentNode.this.component instanceof ComponentContainer ? ((ComponentContainer)((Object)RADComponentNode.this.component)).getSubBeans() : null);
            Node[] nodeArray = new Node[object != null ? ((RADVisualComponent[])object).length : 0];
            for (int i = 0; i < ((RADComponent[])object).length; ++i) {
                nodeArray[i] = object[i].getNodeReference();
            }
            return nodeArray;
        }

        public int getNodesCount() {
            return this.getNodes().length;
        }

        public void reorder(int[] nArray) {
            if (RADComponentNode.this.component instanceof ComponentContainer) {
                ComponentContainer componentContainer = (ComponentContainer)((Object)RADComponentNode.this.component);
                componentContainer.reorderSubComponents(nArray);
                RADComponentNode.this.component.getFormModel().fireComponentsReordered(componentContainer, nArray);
            }
        }
    }

    public static class RADChildren
    extends FormNode.FormNodeChildren {
        private ComponentContainer container;
        private Object keyLayout;

        public RADChildren(ComponentContainer componentContainer) {
            this.container = componentContainer;
            this.updateKeys();
        }

        protected void updateKeys() {
            RADComponent[] rADComponentArray = this.container.getSubBeans();
            ArrayList<Object> arrayList = new ArrayList<Object>(rADComponentArray.length + 2);
            if (this.container instanceof RADVisualContainer) {
                RADVisualContainer rADVisualContainer = (RADVisualContainer)this.container;
                RADComponent rADComponent = rADVisualContainer.getContainerMenu();
                if (rADComponent != null) {
                    arrayList.add(rADComponent);
                }
                if (rADVisualContainer.shouldHaveLayoutNode()) {
                    this.keyLayout = rADVisualContainer.getLayoutSupport().getLayoutDelegate();
                    arrayList.add(this.keyLayout);
                }
                for (int i = 0; i < rADComponentArray.length; ++i) {
                    if (rADComponentArray[i] == rADComponent) continue;
                    arrayList.add(rADComponentArray[i]);
                }
            } else {
                for (int i = 0; i < rADComponentArray.length; ++i) {
                    arrayList.add(rADComponentArray[i]);
                }
            }
            this.setKeys(arrayList);
        }

        protected Node[] createNodes(Object object) {
            FormNode formNode;
            if (object == this.keyLayout) {
                formNode = new LayoutNode((RADVisualContainer)this.container);
            } else {
                formNode = new RADComponentNode((RADComponent)object);
                formNode.getChildren().getNodes();
            }
            return new Node[]{formNode};
        }
    }
}

