/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassSource {
    private final String className;
    private final Collection<? extends Entry> entries;
    private static final String TYPE_JAR = "jar";
    private static final String TYPE_LIBRARY = "library";
    private static final String TYPE_PROJECT = "project";

    public ClassSource(String string, Entry ... entryArray) {
        this(string, Arrays.asList(entryArray));
    }

    public ClassSource(String string, Collection<? extends Entry> collection) {
        this.className = string;
        this.entries = collection;
    }

    public String getClassName() {
        return this.className;
    }

    public Collection<? extends Entry> getEntries() {
        return this.entries;
    }

    public boolean hasEntries() {
        return !this.entries.isEmpty();
    }

    public List<URL> getClasspath() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Entry object : this.entries) {
            arrayList.addAll(object.getClasspath());
        }
        for (URL uRL : arrayList) {
            assert (uRL.toExternalForm().endsWith("/")) : uRL;
        }
        return arrayList;
    }

    public boolean addToProjectClassPath(FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        for (Entry entry : this.entries) {
            if (entry.addToProjectClassPath(fileObject, string).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Entry unpickle(String string, String string2) {
        if (string.equals(TYPE_JAR)) {
            return new JarEntry(new File(string2));
        }
        if (string.equals(TYPE_LIBRARY)) {
            Library library;
            int n = string2.indexOf(35);
            if (n != -1) {
                try {
                    library = LibraryManager.forLocation((URL)new URL(string2.substring(0, n))).getLibrary(string2.substring(n + 1));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Exceptions.printStackTrace((Throwable)illegalArgumentException);
                    return null;
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                    return null;
                }
            } else {
                library = LibraryManager.getDefault().getLibrary(string2);
            }
            return library != null ? new LibraryEntry(library) : null;
        }
        if (string.equals(TYPE_PROJECT)) {
            AntArtifact antArtifact = AntArtifactQuery.findArtifactFromFile((File)new File(string2));
            return antArtifact != null ? new ProjectEntry(antArtifact) : null;
        }
        return null;
    }

    private static URL translateURL(URL uRL) {
        if (FileUtil.isArchiveFile((URL)uRL)) {
            return FileUtil.getArchiveRoot((URL)uRL);
        }
        return uRL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProjectEntry
    extends Entry {
        private final AntArtifact artifact;

        public ProjectEntry(AntArtifact antArtifact) {
            assert (antArtifact != null);
            this.artifact = antArtifact;
        }

        public AntArtifact getArtifact() {
            return this.artifact;
        }

        @Override
        public List<URL> getClasspath() {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (URI uRI : this.artifact.getArtifactLocations()) {
                try {
                    arrayList.add(ClassSource.translateURL(this.artifact.getScriptLocation().toURI().resolve(uRI).normalize().toURL()));
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                }
            }
            return arrayList;
        }

        @Override
        public Boolean addToProjectClassPath(FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
            if (this.artifact.getProject() != FileOwnerQuery.getOwner((FileObject)fileObject)) {
                return ProjectClassPathModifier.addAntArtifacts((AntArtifact[])new AntArtifact[]{this.artifact}, (URI[])this.artifact.getArtifactLocations(), (FileObject)fileObject, (String)string);
            }
            return Boolean.FALSE;
        }

        @Override
        public String getDisplayName() {
            Project project = this.artifact.getProject();
            return NbBundle.getMessage(ClassSource.class, (String)"FMT_ProjectSource", (Object)(project != null ? FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) : this.artifact.getScriptLocation().getAbsolutePath()));
        }

        @Override
        public String getPicklingType() {
            return ClassSource.TYPE_PROJECT;
        }

        @Override
        public String getPicklingName() {
            if (this.artifact.getArtifactLocations().length > 0) {
                return new File(this.artifact.getScriptLocation().toURI().resolve(this.artifact.getArtifactLocations()[0]).normalize()).getAbsolutePath();
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LibraryEntry
    extends Entry {
        private final Library lib;

        public LibraryEntry(Library library) {
            assert (library != null);
            this.lib = library;
        }

        public Library getLibrary() {
            return this.lib;
        }

        @Override
        public List<URL> getClasspath() {
            return this.lib.getContent("classpath");
        }

        @Override
        public Boolean addToProjectClassPath(FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addLibraries((Library[])new Library[]{this.lib}, (FileObject)fileObject, (String)string);
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(ClassSource.class, (String)"FMT_LibrarySource", (Object)this.lib.getDisplayName());
        }

        @Override
        public String getPicklingType() {
            return ClassSource.TYPE_LIBRARY;
        }

        @Override
        public String getPicklingName() {
            LibraryManager libraryManager = this.lib.getManager();
            if (libraryManager == LibraryManager.getDefault()) {
                return this.lib.getName();
            }
            return libraryManager.getLocation() + "#" + this.lib.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class JarEntry
    extends Entry {
        private final File jar;

        public JarEntry(File file) {
            assert (file != null);
            this.jar = file;
        }

        public File getJar() {
            return this.jar;
        }

        @Override
        public List<URL> getClasspath() {
            try {
                return Collections.singletonList(ClassSource.translateURL(this.jar.toURI().toURL()));
            }
            catch (MalformedURLException malformedURLException) {
                assert (false) : malformedURLException;
                return Collections.emptyList();
            }
        }

        @Override
        public Boolean addToProjectClassPath(FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
            URL uRL = this.jar.toURI().toURL();
            FileObject fileObject2 = FileUtil.toFileObject((File)this.jar);
            if (fileObject2 == null) {
                return Boolean.FALSE;
            }
            if (FileUtil.isArchiveFile((FileObject)fileObject2)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            }
            return ProjectClassPathModifier.addRoots((URL[])new URL[]{uRL}, (FileObject)fileObject, (String)string);
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(ClassSource.class, (String)"FMT_JarSource", (Object)this.jar.getAbsolutePath());
        }

        @Override
        public String getPicklingType() {
            return ClassSource.TYPE_JAR;
        }

        @Override
        public String getPicklingName() {
            return this.jar.getAbsolutePath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Entry {
        private Entry() {
        }

        public abstract List<URL> getClasspath();

        public abstract Boolean addToProjectClassPath(FileObject var1, String var2) throws IOException, UnsupportedOperationException;

        public abstract String getDisplayName();

        public abstract String getPicklingType();

        public abstract String getPicklingName();

        public final int hashCode() {
            return ((Object)this.getClasspath()).hashCode();
        }

        public final boolean equals(Object object) {
            return object instanceof Entry && ((Object)this.getClasspath()).equals(((Entry)object).getClasspath());
        }

        public final String toString() {
            return super.toString() + this.getClasspath();
        }
    }
}

