/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceFactory;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectSelectionPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(ProjectSelectionPanel.class.getName());
    private ProjectWizardPanel wizard;
    private EclipseProject[] projects;
    private Set<EclipseProject> selectedProjects;
    private Set<EclipseProject> requiredProjects;
    private ButtonGroup buttonGroup1;
    private JButton chooseDestButton;
    private JTextField destination;
    private JRadioButton jRadioInsideEclipse;
    private JRadioButton jRadioSeparate;
    private JLabel prjLocationLBL;
    private JLabel prjLocationLBL1;
    private JLabel projectListLabel;
    private JTable projectTable;
    private JScrollPane projectTableSP;

    public void updateValidity() {
        if (this.selectedProjects == null || this.selectedProjects.isEmpty()) {
            this.wizard.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ProjectIsNotChosed"));
            return;
        }
        boolean bl = false;
        if (this.jRadioInsideEclipse.isSelected()) {
            for (EclipseProject eclipseProject : this.allProjects()) {
                if (!new File(eclipseProject.getDirectory(), "nbproject").exists()) continue;
                bl = true;
                break;
            }
        } else {
            if (this.destination.getText().length() == 0) {
                this.wizard.setErrorMessage(ProjectImporterWizard.getMessage("MSG_DestinationIsEmpty"));
                return;
            }
            File file = new File(this.destination.getText());
            if (file.exists()) {
                for (EclipseProject eclipseProject : this.allProjects()) {
                    if (!new File(file, eclipseProject.getDirectory().getName()).exists()) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (bl) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"MSG_AlreadyImportedProjects"), true);
        } else {
            this.wizard.setErrorMessage(null);
        }
    }

    public boolean isSeparateFolder() {
        return this.jRadioSeparate.isSelected();
    }

    private Collection<EclipseProject> allProjects() {
        HashSet<EclipseProject> hashSet = new HashSet<EclipseProject>(this.selectedProjects);
        hashSet.addAll(this.requiredProjects);
        return hashSet;
    }

    private void solveDependencies() {
        this.requiredProjects.clear();
        this.requiredProjects.addAll(ProjectSelectionPanel.getFlattenedRequiredProjects(this.selectedProjects));
    }

    public static Set<EclipseProject> getFlattenedRequiredProjects(Set<EclipseProject> set) {
        Stack<EclipseProject> stack = new Stack<EclipseProject>();
        HashSet<EclipseProject> hashSet = new HashSet<EclipseProject>();
        if (set == null || set.isEmpty()) {
            return hashSet;
        }
        for (EclipseProject eclipseProject : set) {
            assert (eclipseProject != null);
            stack.push(eclipseProject);
            EclipseProject eclipseProject2 = eclipseProject;
            ProjectSelectionPanel.fillUpRequiredProjects(eclipseProject, stack, hashSet);
            EclipseProject eclipseProject3 = stack.pop();
            assert (eclipseProject3.equals(eclipseProject2));
            assert (stack.isEmpty());
            eclipseProject2 = null;
        }
        return hashSet;
    }

    private static void fillUpRequiredProjects(EclipseProject eclipseProject, Stack<EclipseProject> stack, Set<EclipseProject> set) {
        for (EclipseProject eclipseProject2 : eclipseProject.getProjects()) {
            assert (eclipseProject2 != null);
            if (stack.contains(eclipseProject2)) {
                ProjectSelectionPanel.recursionDetected(eclipseProject2, stack);
                return;
            }
            set.add(eclipseProject2);
            stack.push(eclipseProject2);
            ProjectSelectionPanel.fillUpRequiredProjects(eclipseProject2, stack, set);
            EclipseProject eclipseProject3 = stack.pop();
            assert (eclipseProject3.equals(eclipseProject2));
        }
    }

    private static void recursionDetected(EclipseProject eclipseProject, Stack<EclipseProject> stack) {
        int n = stack.search(eclipseProject);
        assert (n != -1) : "Cannot find start of the cycle.";
        EclipseProject eclipseProject2 = (EclipseProject)stack.get(stack.size() - n);
        StringBuffer stringBuffer = new StringBuffer();
        for (EclipseProject eclipseProject3 : stack) {
            stringBuffer.append(eclipseProject3.getName()).append(" --> ");
        }
        stringBuffer.append(eclipseProject2.getName()).append(" --> ...");
        logger.warning("Cycle dependencies was detected. Detected cycle: " + stringBuffer);
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ProjectImporterWizard.getMessage("MSG_CycleDependencies", stringBuffer.toString()), 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    ProjectSelectionPanel(ProjectWizardPanel projectWizardPanel) {
        this.wizard = projectWizardPanel;
        this.initComponents();
        this.init();
        this.destination.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ProjectSelectionPanel.this.updateValidity();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ProjectSelectionPanel.this.updateValidity();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.updateValidity();
        this.jRadioInsideEclipse.setSelected(true);
        this.enableLocation(false);
        TableColumn tableColumn = this.projectTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(25);
        tableColumn.setMinWidth(25);
    }

    private void init() {
        this.projectTable.setModel(new ProjectTableModel());
        this.projectTable.setTableHeader(null);
        this.projectTable.getSelectionModel().setSelectionMode(0);
        this.projectTable.getColumnModel().getColumn(0).setCellRenderer(new ProjectCheckboxEditorAndRenderer());
        this.projectTable.getColumnModel().getColumn(1).setCellRenderer(new ProjectNameRenderer());
        this.projectTable.setDefaultEditor(Boolean.class, new ProjectCheckboxEditorAndRenderer());
        this.projectTableSP.getViewport().setBackground(this.projectTable.getBackground());
        this.destination.setText(ProjectChooser.getProjectsFolder().getPath());
    }

    void loadProjects(File file) {
        WorkspaceFactory.getInstance().resetCache();
        Workspace workspace = null;
        try {
            workspace = WorkspaceFactory.getInstance().load(file);
        }
        catch (ProjectImporterException projectImporterException) {
            this.wizard.setErrorMessage(ProjectImporterWizard.getMessage("MSG_WorkspaceIsInvalid", file));
            logger.log(Level.FINE, "ProjectImporterException catched", projectImporterException);
            return;
        }
        TreeSet<EclipseProject> treeSet = new TreeSet<EclipseProject>(workspace.getProjects());
        this.projects = treeSet.toArray(new EclipseProject[treeSet.size()]);
        this.selectedProjects = new HashSet<EclipseProject>();
        this.requiredProjects = new HashSet<EclipseProject>();
        if (this.projects.length == 0) {
            this.wizard.setErrorMessage(ProjectImporterWizard.getMessage("MSG_WorkspaceIsEmpty", file));
        } else {
            this.updateValidity();
        }
    }

    List<EclipseProject> getProjects() {
        return ProjectSelectionPanel.getFlattenedProjects(this.selectedProjects);
    }

    public static List<EclipseProject> getFlattenedProjects(Set<EclipseProject> set) {
        ArrayList<EclipseProject> arrayList = new ArrayList<EclipseProject>();
        ProjectSelectionPanel.addProjects(set, arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EclipseProject eclipseProject = (EclipseProject)iterator.next();
            if (eclipseProject.isImportSupported()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    private static void addProjects(Set<EclipseProject> set, List<EclipseProject> list) {
        for (EclipseProject eclipseProject : set) {
            if (list.contains(eclipseProject)) continue;
            Set<EclipseProject> set2 = eclipseProject.getProjects();
            if (set2.size() == 0) {
                list.add(eclipseProject);
                continue;
            }
            ProjectSelectionPanel.addProjects(set2, list);
            list.add(eclipseProject);
        }
    }

    int getNumberOfImportedProject() {
        return this.allProjects().size();
    }

    String getDestination() {
        if (this.isSeparateFolder()) {
            return this.destination.getText();
        }
        return null;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.projectListLabel = new JLabel();
        this.projectTableSP = new JScrollPane();
        this.projectTable = new JTable();
        this.prjLocationLBL = new JLabel();
        this.destination = new JTextField();
        this.chooseDestButton = new JButton();
        this.jRadioInsideEclipse = new JRadioButton();
        this.jRadioSeparate = new JRadioButton();
        this.prjLocationLBL1 = new JLabel();
        this.setBorder(null);
        this.projectListLabel.setLabelFor(this.projectTable);
        Mnemonics.setLocalizedText((JLabel)this.projectListLabel, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"LBL_ProjectsToImport"));
        this.projectListLabel.setVerticalTextPosition(1);
        this.projectTable.setOpaque(false);
        this.projectTable.setShowHorizontalLines(false);
        this.projectTable.setShowVerticalLines(false);
        this.projectTableSP.setViewportView(this.projectTable);
        this.projectTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.prjLocationLBL.setLabelFor(this.jRadioInsideEclipse);
        Mnemonics.setLocalizedText((JLabel)this.prjLocationLBL, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"LBL_LocationOfNBProjects"));
        Mnemonics.setLocalizedText((AbstractButton)this.chooseDestButton, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"CTL_BrowseButton_B"));
        this.chooseDestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectSelectionPanel.this.chooseDestButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jRadioInsideEclipse);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioInsideEclipse, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"RADIO_LOCATION_ECLIPSE"));
        this.jRadioInsideEclipse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectSelectionPanel.this.jRadioInsideEclipseActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jRadioSeparate);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioSeparate, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"RADIO_LOCATION_SEPARATE"));
        this.jRadioSeparate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectSelectionPanel.this.jRadioSeparateActionPerformed(actionEvent);
            }
        });
        this.prjLocationLBL1.setLabelFor(this.destination);
        Mnemonics.setLocalizedText((JLabel)this.prjLocationLBL1, (String)NbBundle.getMessage(ProjectSelectionPanel.class, (String)"LBL_LocationOfNBProjects2"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.prjLocationLBL).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(34, 34, 34).add((Component)this.prjLocationLBL1).addPreferredGap(0).add((Component)this.destination, -1, 304, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chooseDestButton)).add((Component)this.projectTableSP, -1, 484, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jRadioInsideEclipse, -1, 472, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jRadioSeparate, -1, 472, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectListLabel).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectListLabel).addPreferredGap(0).add((Component)this.projectTableSP, -1, 214, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.prjLocationLBL).add(0, 0, 0).add((Component)this.jRadioInsideEclipse).add(0, 0, 0).add((Component)this.jRadioSeparate).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.prjLocationLBL1).add((Component)this.chooseDestButton).add((Component)this.destination, -2, -1, -2))));
        this.projectListLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.projectTableSP.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.projectTableSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.prjLocationLBL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.destination.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.chooseDestButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.jRadioInsideEclipse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.jRadioSeparate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.prjLocationLBL1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectSelectionPanel.class, (String)"ACSD_ProjectSelectionPanel_NA"));
    }

    private void chooseDestButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.destination.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void jRadioInsideEclipseActionPerformed(ActionEvent actionEvent) {
        this.enableLocation(false);
    }

    private void jRadioSeparateActionPerformed(ActionEvent actionEvent) {
        this.enableLocation(true);
    }

    private void enableLocation(boolean bl) {
        this.prjLocationLBL1.setEnabled(bl);
        this.destination.setEnabled(bl);
        this.chooseDestButton.setEnabled(bl);
    }

    private class ProjectTableModel
    extends AbstractTableModel {
        private ProjectTableModel() {
        }

        public Object getValueAt(int n, int n2) {
            EclipseProject eclipseProject = ProjectSelectionPanel.this.projects[n];
            if (n2 == 0) {
                return ProjectSelectionPanel.this.selectedProjects.contains(eclipseProject) || ProjectSelectionPanel.this.requiredProjects.contains(eclipseProject);
            }
            if (eclipseProject.isImportSupported()) {
                return eclipseProject.getName() + " (" + eclipseProject.getProjectTypeFactory().getProjectTypeName() + ")";
            }
            return eclipseProject.getName() + " (unknown project type)";
        }

        public int getRowCount() {
            return ProjectSelectionPanel.this.projects != null ? ProjectSelectionPanel.this.projects.length : 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 && ProjectSelectionPanel.this.projects[n].isImportSupported() && !ProjectSelectionPanel.this.requiredProjects.contains(ProjectSelectionPanel.this.projects[n]);
        }

        public void setValueAt(Object object, int n, int n2) {
            EclipseProject eclipseProject = ProjectSelectionPanel.this.projects[n];
            assert (ProjectSelectionPanel.this.projects != null);
            if (((Boolean)object).booleanValue()) {
                ProjectSelectionPanel.this.selectedProjects.add(eclipseProject);
            } else {
                ProjectSelectionPanel.this.selectedProjects.remove(eclipseProject);
            }
            ProjectSelectionPanel.this.solveDependencies();
            this.fireColumnDataChanged();
            ProjectSelectionPanel.this.updateValidity();
            ProjectSelectionPanel.this.wizard.fireProjectListChanged();
        }

        private void fireColumnDataChanged() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.fireTableCellUpdated(i, 0);
            }
        }
    }

    private class ProjectNameRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private ProjectNameRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setOpaque(bl);
                EclipseProject eclipseProject = ProjectSelectionPanel.this.projects[n];
                if (eclipseProject.isImportSupported()) {
                    jLabel.setIcon(eclipseProject.getProjectTypeFactory().getProjectTypeIcon());
                } else {
                    jLabel.setIcon(null);
                }
            }
            return component;
        }
    }

    private class ProjectCheckboxEditorAndRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private JCheckBox checkbox;

        private ProjectCheckboxEditorAndRenderer() {
        }

        public Object getCellEditorValue() {
            return this.checkbox.isSelected();
        }

        private JCheckBox createComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            EclipseProject eclipseProject = ProjectSelectionPanel.this.projects[n];
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(ProjectSelectionPanel.this.selectedProjects.contains(eclipseProject) || ProjectSelectionPanel.this.requiredProjects.contains(eclipseProject));
            jCheckBox.setToolTipText(null);
            if (eclipseProject.isImportSupported() && !ProjectSelectionPanel.this.requiredProjects.contains(eclipseProject)) {
                jCheckBox.setEnabled(true);
            } else {
                jCheckBox.setEnabled(false);
                if (!eclipseProject.isImportSupported()) {
                    jCheckBox.setToolTipText(ProjectImporterWizard.getMessage("MSG_NonJavaProject", eclipseProject.getName()));
                }
            }
            if (bl) {
                jCheckBox.setOpaque(true);
                jCheckBox.setForeground(jTable.getSelectionForeground());
                jCheckBox.setBackground(jTable.getSelectionBackground());
            } else {
                jCheckBox.setOpaque(false);
                jCheckBox.setForeground(jTable.getForeground());
                jCheckBox.setBackground(jTable.getBackground());
            }
            return jCheckBox;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.checkbox = this.createComponent(jTable, object, bl, bl, n, n2);
            this.checkbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProjectCheckboxEditorAndRenderer.this.fireEditingStopped();
                }
            });
            return this.checkbox;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.checkbox = this.createComponent(jTable, object, bl, bl, n, n2);
            return this.checkbox;
        }
    }
}

