/*
 * Decompiled with CFR 0.152.
 */
package rex.olap.mdxparse;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java_cup.runtime.Symbol;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import rex.graphics.mdxeditor.jsp.ReadEnv;
import rex.olap.mdxparse.CompoundId;
import rex.olap.mdxparse.Exp;
import rex.olap.mdxparse.ExpVisitor;
import rex.olap.mdxparse.Formula;
import rex.olap.mdxparse.FunCall;
import rex.olap.mdxparse.Lexer;
import rex.olap.mdxparse.Literal;
import rex.olap.mdxparse.MemberProperty;
import rex.olap.mdxparse.Parameter;
import rex.olap.mdxparse.QueryAxis;
import rex.olap.mdxparse.parser;
import rex.utils.S;

public class ParsedQuery
implements Exp {
    static Logger logger = Logger.getLogger((Class)ParsedQuery.class);
    List formulas = new ArrayList();
    Map paraMap = new Hashtable();
    ArrayList axisDef = null;
    String cube;
    List cellProps = new ArrayList();
    Exp slicer = null;
    private QueryAxis[] axes = new QueryAxis[0];

    public void afterParse() throws Exception {
        if (this.axisDef != null) {
            this.axes = this.axisDef.toArray(new QueryAxis[0]);
            this.axisDef = null;
        }
        this.collectParams();
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public void setAxes(QueryAxis[] axes) {
        this.axes = axes;
    }

    public String getCube() {
        if (this.cube.charAt(0) == '[' && this.cube.charAt(this.cube.length() - 1) == ']') {
            return this.cube.substring(1, this.cube.length() - 1);
        }
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public Formula[] getFormulas() {
        return this.formulas.toArray(new Formula[0]);
    }

    public String toMdx() {
        StringBuffer mdx = new StringBuffer();
        if (this.formulas.size() > 0) {
            mdx.append("WITH ");
            Iterator iter = this.formulas.iterator();
            while (iter.hasNext()) {
                mdx.append(' ');
                Formula form = (Formula)iter.next();
                mdx.append(form.toMdx());
            }
            mdx.append(' ');
        }
        mdx.append("SELECT ");
        boolean isFollow = false;
        for (int i = 0; i < this.axes.length; ++i) {
            QueryAxis qa = this.axes[i];
            if (isFollow) {
                mdx.append(", ");
            }
            isFollow = true;
            mdx.append(qa.toMdx());
        }
        mdx.append(" FROM ");
        mdx.append(this.cube);
        if (this.slicer != null) {
            mdx.append(" WHERE ");
            mdx.append(this.slicer.toMdx());
        }
        if (this.cellProps.size() > 0) {
            mdx.append(" CELL PROPERTIES VALUE, FORMATTED_VALUE");
            Iterator iter = this.cellProps.iterator();
            while (iter.hasNext()) {
                CompoundId cid = (CompoundId)iter.next();
                String str = cid.toMdx();
                if (str.equalsIgnoreCase("VALUE") || str.equalsIgnoreCase("FORMATTED_VALUE")) continue;
                mdx.append(" ,");
                mdx.append(str);
            }
        }
        return mdx.toString();
    }

    public String toDrillMdx() {
        StringBuffer mdx = new StringBuffer();
        if (this.formulas.size() > 0) {
            mdx.append("WITH ");
            Iterator iter = this.formulas.iterator();
            while (iter.hasNext()) {
                mdx.append(' ');
                Formula form = (Formula)iter.next();
                mdx.append(form.toMdx());
            }
            mdx.append(' ');
        }
        mdx.append("DRILLTHROUGH SELECT ");
        boolean isFollow = false;
        for (int i = 0; i < this.axes.length; ++i) {
            QueryAxis qa = this.axes[i];
            if (isFollow) {
                mdx.append(", ");
            }
            isFollow = true;
            mdx.append(qa.toMdx());
        }
        mdx.append(" FROM ");
        mdx.append(this.cube);
        if (this.slicer != null) {
            mdx.append(" WHERE ");
            mdx.append(this.slicer.toMdx());
        }
        if (this.cellProps.size() > 0) {
            mdx.append(" CELL PROPERTIES VALUE, FORMATTED_VALUE");
            Iterator iter = this.cellProps.iterator();
            while (iter.hasNext()) {
                CompoundId cid = (CompoundId)iter.next();
                String str = cid.toMdx();
                if (str.equalsIgnoreCase("VALUE") || str.equalsIgnoreCase("FORMATTED_VALUE")) continue;
                mdx.append(" ,");
                mdx.append(str);
            }
        }
        return mdx.toString();
    }

    public Object clone() {
        ParsedQuery cloned = new ParsedQuery();
        if (this.formulas.size() > 0) {
            ArrayList<Object> clonedFormulas = new ArrayList<Object>();
            Iterator iter = this.formulas.iterator();
            while (iter.hasNext()) {
                Formula form = (Formula)iter.next();
                clonedFormulas.add(form.clone());
            }
            cloned.formulas = clonedFormulas;
        }
        if (this.axes.length > 0) {
            QueryAxis[] clonedAxes = new QueryAxis[this.axes.length];
            for (int i = 0; i < clonedAxes.length; ++i) {
                clonedAxes[i] = (QueryAxis)this.axes[i].clone();
            }
            cloned.setAxes(clonedAxes);
        }
        if (this.slicer != null) {
            cloned.slicer = (Exp)this.slicer.clone();
        }
        cloned.setCube("[" + this.getCube() + "]");
        return cloned;
    }

    public Exp getSlicer() {
        return this.slicer;
    }

    public void setSlicer(Exp exp) {
        this.slicer = exp;
    }

    private void collectParams() throws Exception {
        System.out.println("Jab Jab");
        int iAxis = -2;
        Iterator iter = this.formulas.iterator();
        while (iter.hasNext()) {
            Formula formula = (Formula)iter.next();
            this.walkTreeForParams(formula.getExp(), iAxis);
        }
        int i = 0;
        while (i < this.axes.length) {
            Exp exp = this.axes[i].getExp();
            iAxis = i++;
            this.walkTreeForParams(exp, iAxis);
        }
        System.out.println("Tab Tab");
    }

    private void walkTreeForParams(Exp exp, int iAxis) throws Exception {
        if (!(exp instanceof FunCall)) {
            return;
        }
        FunCall f = (FunCall)exp;
        if (f.isCallTo("Parameter")) {
            Exp val;
            int type;
            int nArgs = f.getArgs().length;
            if (nArgs != 3 && nArgs != 4) {
                throw new Exception("Syntax Error in Parameter: wrong number of arguments");
            }
            if (!(f.getArgs()[0] instanceof Literal)) {
                throw new Exception("Syntax Error in Parameter definition - 1.argument");
            }
            Literal eName = (Literal)f.getArgs()[0];
            String paraName = eName.stringValue();
            if (this.paraMap.containsKey(paraName.toUpperCase())) {
                String err = "Parameter defined more than once:" + paraName;
                logger.error((Object)err);
                throw new Exception(err);
            }
            Object value = null;
            f.pQuery = this;
            CompoundId id = (CompoundId)f.getArgs()[1];
            String[] ids = id.toStringArray();
            if (ids.length > 1) {
                throw new Exception("Syntax Error in Parameter definition - 2.argument");
            }
            if (ids[0].equalsIgnoreCase("NUMERIC")) {
                type = 1;
                if (!(f.getArgs()[0] instanceof Literal)) {
                    throw new Exception("Syntax Error in Parameter definition - 3.argument");
                }
                val = (Literal)f.getArgs()[2];
                value = ((Literal)val).getValueObject();
            } else if (ids[0].equalsIgnoreCase("STRING")) {
                type = 2;
                val = (Literal)f.getArgs()[2];
                value = ((Literal)val).getValueObject();
            } else {
                type = 3;
                val = (CompoundId)f.getArgs()[2];
                value = ((CompoundId)val).toMdx();
            }
            Parameter par = new Parameter(paraName, type, iAxis);
            par.setOValue(value);
            if (nArgs == 4) {
                Literal desc = (Literal)f.getArgs()[3];
                String description = (String)desc.getValueObject();
                par.setDescription(description);
            }
            this.paraMap.put(paraName.toUpperCase(), par);
        } else if (f.isCallTo("ParamRef")) {
            f.pQuery = this;
        }
        for (int i = 0; i < f.getArgs().length; ++i) {
            this.walkTreeForParams(f.getArgs()[i], iAxis);
        }
    }

    public Map getParaMap() {
        return this.paraMap;
    }

    public void addFormula(String[] names, Exp exp, MemberProperty[] memberProperties) {
        Formula newFormula = new Formula(names, exp, memberProperties);
        this.formulas.add(newFormula);
    }

    public void addFormula(String[] names, Exp exp) {
        Formula newFormula = new Formula(names, exp);
        this.formulas.add(newFormula);
    }

    public void removeFormula(String uniqueName) {
        Iterator iter = this.formulas.iterator();
        while (iter.hasNext()) {
            Formula formula = (Formula)iter.next();
            if (!uniqueName.equals(formula.getUniqeName())) continue;
            iter.remove();
        }
    }

    public void accept(ExpVisitor visitor) {
        visitor.visitParsedQuery(this);
    }

    public List getCellProps() {
        return this.cellProps;
    }

    public static void main(String[] args) {
        String mdxQuery = "select {[Measures].[nQuantity], [Measures].[nLabor_Cost], [Measures].[nDouble_Quantity], [Measures].[nDouble_Labor_Cost]} ON COLUMNS from [InventoryNB]";
        mdxQuery = mdxQuery.replaceAll("\r", "");
        try {
            int i;
            PropertyConfigurator.configure((String)(ReadEnv.getEnvVars().getProperty("USERPROFILE") + "\\rex.properties"));
            StringReader reader = new StringReader(mdxQuery);
            parser parser_obj = new parser(new Lexer(reader));
            Symbol parse_tree = null;
            ParsedQuery pQuery = null;
            parse_tree = parser_obj.parse();
            pQuery = (ParsedQuery)parse_tree.value;
            pQuery.afterParse();
            Formula[] with = pQuery.getFormulas();
            QueryAxis[] select = pQuery.getAxes();
            String newCube = pQuery.getCube();
            Exp where = pQuery.getSlicer();
            S.out("With");
            for (i = 0; i < with.length; ++i) {
                S.out(i + " :" + with[i].toMdx());
            }
            S.out("Select " + select.length);
            for (i = 0; i < select.length; ++i) {
                S.out(select[i].toMdx());
            }
            S.out("From " + newCube);
            S.out("Where");
            S.out(where.toMdx());
            pQuery.collectParams();
            S.out("++++++++++++++++++++++++++++++++++++++++");
            S.out(pQuery.getParaMap().size() + "");
        }
        catch (Exception e) {
            S.out(e.toString());
        }
    }
}

