/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.javadoc.DocPositions;
import org.netbeans.modules.java.editor.javadoc.JavaReference;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavadocImports {
    private static final Set<String> ALL_REF_TAG_NAMES = new HashSet<String>(Arrays.asList("@link", "@linkplain", "@value", "@see", "@throws"));

    private JavadocImports() {
    }

    public static Set<String> computeUnresolvedImports(CompilationInfo compilationInfo) {
        List list = compilationInfo.getTopLevelElements();
        UnresolvedImportScanner unresolvedImportScanner = new UnresolvedImportScanner(compilationInfo);
        unresolvedImportScanner.scan(list, null);
        return unresolvedImportScanner.unresolved;
    }

    public static Set<TypeElement> computeReferencedElements(CompilationInfo compilationInfo, Element element) {
        Set<TypeElement> set = null;
        TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(compilationInfo, element);
        if (tokenSequence != null) {
            List<Object> list;
            ElementKind elementKind = element.getKind();
            TypeElement typeElement = elementKind.isClass() || elementKind.isInterface() ? (TypeElement)element : compilationInfo.getElementUtilities().enclosingTypeElement(element);
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            DocPositions docPositions = null;
            if (doc != null && typeElement != null) {
                docPositions = DocPositions.get(compilationInfo, doc, tokenSequence);
                list = docPositions.getTags();
            } else {
                list = Collections.emptyList();
            }
            for (Tag tag : list) {
                JavaReference javaReference = JavadocImports.findReference(tag, docPositions, tokenSequence);
                if (javaReference == null || javaReference.fqn == null || javaReference.fqn.length() <= 0) continue;
                String string = ((Object)javaReference.fqn).toString();
                TypeMirror typeMirror = compilationInfo.getTreeUtilities().parseType(string, typeElement);
                if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED) continue;
                DeclaredType declaredType = (DeclaredType)typeMirror;
                if (set == null) {
                    set = new HashSet<TypeElement>();
                }
                set.add((TypeElement)declaredType.asElement());
            }
        }
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    public static List<Token> computeTokensOfReferencedElements(CompilationInfo compilationInfo, Element element, Element element2) {
        List<Token> list = null;
        TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(compilationInfo, element);
        if (tokenSequence != null) {
            List<Object> list2;
            ElementKind elementKind = element.getKind();
            TypeElement typeElement = elementKind.isClass() || elementKind.isInterface() ? (TypeElement)element : compilationInfo.getElementUtilities().enclosingTypeElement(element);
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            DocPositions docPositions = null;
            if (doc != null && typeElement != null) {
                docPositions = DocPositions.get(compilationInfo, doc, tokenSequence);
                list2 = docPositions.getTags();
            } else {
                list2 = Collections.emptyList();
            }
            for (Tag tag : list2) {
                Element element3;
                JavaReference javaReference = JavadocImports.findReference(tag, docPositions, tokenSequence);
                if (javaReference == null) continue;
                for (element3 = javaReference.getReferencedElement(compilationInfo, typeElement); element3 != null && element3 != element2; element3 = element3.getEnclosingElement()) {
                }
                if (element3 != element2) continue;
                int n = -1;
                ElementKind elementKind2 = element3.getKind();
                if (javaReference.fqn != null && (elementKind2.isClass() || elementKind2.isInterface())) {
                    String string = ((TypeElement)element3).getQualifiedName().toString();
                    String string2 = ((Object)javaReference.fqn).toString();
                    if (string2.startsWith(string)) {
                        n = javaReference.begin + string.length() - 1;
                    } else {
                        String string3 = element3.getSimpleName().toString();
                        n = javaReference.begin + string3.length() - 1;
                    }
                } else if (elementKind2.isField() || elementKind2 == ElementKind.METHOD || elementKind2 == ElementKind.CONSTRUCTOR) {
                    n = javaReference.end - 1;
                }
                if (n < 0) continue;
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() || tokenSequence.token().id() != JavadocTokenId.IDENT) continue;
                if (list == null) {
                    list = new ArrayList<Token>();
                }
                list.add(tokenSequence.token());
            }
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public static Element findReferencedElement(CompilationInfo compilationInfo, int n) {
        Element element = null;
        Document document = null;
        try {
            document = compilationInfo.getDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document == null) {
            return null;
        }
        TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(compilationInfo, n);
        if (tokenSequence != null) {
            JavaReference javaReference;
            Doc doc = JavadocCompletionUtils.findJavadoc(compilationInfo, document, n);
            if (doc == null) {
                return null;
            }
            DocPositions docPositions = DocPositions.get(compilationInfo, doc, tokenSequence);
            Element element2 = compilationInfo.getElementUtilities().elementFor(doc);
            if (docPositions == null || element2 == null) {
                return null;
            }
            ElementKind elementKind = element2.getKind();
            TypeElement typeElement = elementKind.isClass() || elementKind.isInterface() ? (TypeElement)element2 : compilationInfo.getElementUtilities().enclosingTypeElement(element2);
            Tag tag = docPositions.getTag(n);
            JavaReference javaReference2 = javaReference = tag != null ? JavadocImports.findReference(tag, docPositions, tokenSequence) : null;
            if (javaReference != null && typeElement != null && (element = javaReference.getReferencedElement(compilationInfo, typeElement)) != null && javaReference.fqn != null && n < javaReference.begin + javaReference.fqn.length()) {
                element = element.getKind().isClass() || element.getKind().isInterface() ? element : element.getEnclosingElement();
                int n2 = element.getSimpleName().length();
                while (element != null && n < javaReference.begin + javaReference.fqn.length() - n2) {
                    n2 += (element = element.getEnclosingElement()) != null ? element.getSimpleName().length() + 1 : 0;
                }
            }
        }
        return element;
    }

    public static Token findNameTokenOfReferencedElement(CompilationInfo compilationInfo, int n) {
        Document document = null;
        try {
            document = compilationInfo.getDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document == null) {
            return null;
        }
        TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(compilationInfo, n);
        if (tokenSequence != null) {
            Element element;
            JavaReference javaReference;
            Doc doc = JavadocCompletionUtils.findJavadoc(compilationInfo, document, n);
            if (doc == null) {
                return null;
            }
            DocPositions docPositions = DocPositions.get(compilationInfo, doc, tokenSequence);
            Element element2 = compilationInfo.getElementUtilities().elementFor(doc);
            if (docPositions == null || element2 == null) {
                return null;
            }
            ElementKind elementKind = element2.getKind();
            TypeElement typeElement = elementKind.isClass() || elementKind.isInterface() ? (TypeElement)element2 : compilationInfo.getElementUtilities().enclosingTypeElement(element2);
            Tag tag = docPositions.getTag(n);
            JavaReference javaReference2 = javaReference = tag != null ? JavadocImports.findReference(tag, docPositions, tokenSequence) : null;
            if (javaReference != null && typeElement != null && (element = javaReference.getReferencedElement(compilationInfo, typeElement)) != null) {
                int n2;
                int n3 = n2 = javaReference.fqn != null ? javaReference.fqn.length() : 0;
                if (javaReference.fqn != null && n >= javaReference.begin && n < javaReference.begin + n2 || javaReference.member != null && n > javaReference.begin + n2 && n < javaReference.end) {
                    tokenSequence.move(n);
                    if (tokenSequence.moveNext()) {
                        return tokenSequence.token().id() == JavadocTokenId.IDENT ? tokenSequence.token() : null;
                    }
                }
            }
        }
        return null;
    }

    public static boolean isInsideReference(TokenSequence<JavadocTokenId> tokenSequence, int n) {
        tokenSequence.move(n);
        if (tokenSequence.moveNext() && JavadocTokenId.IDENT == tokenSequence.token().id()) {
            boolean bl = false;
            block6: while (tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                switch ((JavadocTokenId)token.id()) {
                    case DOT: 
                    case HASH: 
                    case IDENT: {
                        if (!bl) continue block6;
                        return false;
                    }
                    case OTHER_TEXT: {
                        bl |= JavadocCompletionUtils.isWhiteSpace((Token<JavadocTokenId>)token);
                        if (bl |= JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)token)) continue block6;
                        return false;
                    }
                    case TAG: {
                        return bl && JavadocImports.isReferenceTag((Token<JavadocTokenId>)token);
                    }
                    case HTML_TAG: {
                        return false;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static JavaReference findReference(Tag tag, DocPositions docPositions, TokenSequence<JavadocTokenId> tokenSequence) {
        if (!JavadocImports.isReferenceTag(tag)) {
            return null;
        }
        int[] nArray = docPositions.getTagSpan(tag);
        tokenSequence.move(nArray[0] + (JavadocCompletionUtils.isBlockTag(tag) ? 0 : 1));
        if (!tokenSequence.moveNext() || tokenSequence.token().id() != JavadocTokenId.TAG) {
            return null;
        }
        if (!tokenSequence.moveNext() || !JavadocCompletionUtils.isWhiteSpace((Token<JavadocTokenId>)tokenSequence.token()) && !JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)tokenSequence.token()) || !tokenSequence.moveNext()) {
            return null;
        }
        return JavaReference.resolve(tokenSequence, tokenSequence.offset(), nArray[1]);
    }

    private static boolean isReferenceTag(Tag tag) {
        String string = tag.name().intern();
        return ALL_REF_TAG_NAMES.contains(string);
    }

    private static boolean isReferenceTag(Token<JavadocTokenId> token) {
        String string = ((Object)token.text()).toString().intern();
        return token.id() == JavadocTokenId.TAG && ALL_REF_TAG_NAMES.contains(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnresolvedImportScanner
    extends ElementScanner6<Void, Void> {
        private final CompilationInfo javac;
        private Set<String> unresolved = new HashSet<String>();

        public UnresolvedImportScanner(CompilationInfo compilationInfo) {
            this.javac = compilationInfo;
        }

        @Override
        public Void visitExecutable(ExecutableElement executableElement, Void void_) {
            TypeElement typeElement = this.javac.getElementUtilities().enclosingTypeElement((Element)executableElement);
            if (typeElement != null) {
                this.resolveElement(executableElement, typeElement);
            }
            return (Void)super.visitExecutable(executableElement, void_);
        }

        @Override
        public Void visitType(TypeElement typeElement, Void void_) {
            this.resolveElement(typeElement, typeElement);
            return (Void)super.visitType(typeElement, void_);
        }

        @Override
        public Void visitVariable(VariableElement variableElement, Void void_) {
            TypeElement typeElement = this.javac.getElementUtilities().enclosingTypeElement((Element)variableElement);
            if (typeElement != null) {
                this.resolveElement(variableElement, typeElement);
            }
            return (Void)super.visitVariable(variableElement, void_);
        }

        private void resolveElement(Element element, TypeElement typeElement) {
            String string = this.javac.getElements().getDocComment(element);
            if (string != null) {
                DocPositions docPositions;
                Doc doc = this.javac.getElementUtilities().javaDocFor(element);
                TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(this.javac, element);
                if (tokenSequence != null && (docPositions = DocPositions.get(this.javac, doc, tokenSequence)) != null) {
                    this.resolveTags(docPositions, tokenSequence, typeElement);
                }
            }
        }

        private void resolveTags(DocPositions docPositions, TokenSequence<JavadocTokenId> tokenSequence, TypeElement typeElement) {
            for (Tag tag : docPositions.getTags()) {
                JavaReference javaReference = JavadocImports.findReference(tag, docPositions, (TokenSequence<JavadocTokenId>)tokenSequence);
                if (javaReference == null || javaReference.fqn == null || javaReference.fqn.length() <= 0) continue;
                String string = ((Object)javaReference.fqn).toString();
                TypeMirror typeMirror = this.javac.getTreeUtilities().parseType(string, typeElement);
                if (typeMirror == null || typeMirror.getKind() != TypeKind.ERROR) continue;
                this.unresolved.add(string);
            }
        }
    }
}

