/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.gui.JRCustomDataSourceConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.sql.Connection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;

public class JRCustomDataSourceConnection
extends IReportConnection {
    private String factoryClass;
    private String methodToCall;

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FactoryClass", Misc.nvl(this.getFactoryClass(), ""));
        map.put("MethodToCall", Misc.nvl(this.getMethodToCall(), ""));
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setFactoryClass((String)map.get("FactoryClass"));
        this.setMethodToCall((String)map.get("MethodToCall"));
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public void setFactoryClass(String factoryClass) {
        this.factoryClass = factoryClass;
    }

    public JRDataSource getJRDataSource() {
        try {
            Class<?> clazz = Class.forName(this.factoryClass, true, Thread.currentThread().getContextClassLoader());
            return (JRDataSource)clazz.getMethod(this.methodToCall, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            this.showErrorMessage(I18n.getString("unexpected.datasource.error", (Object)ex.getMessage(), Misc.getLogFile()), "Exception");
            ex.printStackTrace();
            return super.getJRDataSource();
        }
    }

    public String getDescription() {
        return "\u72ec\u81ea\u306eJRDataSource";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JRCustomDataSourceConnectionEditor();
    }

    public void test() throws Exception {
        try {
            String string = this.getFactoryClass();
            IReportManager.getInstance();
            Object obj = Class.forName(string, true, IReportManager.getReportClassLoader()).newInstance();
            obj.getClass().getMethod(this.getMethodToCall(), new Class[0]).invoke(obj, new Object[0]);
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nNoClassDefFoundError!!\nCheck your classpath!\n{1}", new Object[]{"", "" + ex.getMessage()}), "Exception", 0);
            throw new Exception();
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nClassNotFoundError!\nMsg: {1}\nPossible not found class: {2}\nCheck your classpath!", new Object[]{"", "" + ex.getMessage(), "" + this.getFactoryClass()}), "Exception", 0);
            throw new Exception();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nGeneral problem:\n {1}", new Object[]{"", "" + ex.getMessage()}), "Exception", 0);
            return;
        }
        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
    }
}

