/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JRXMLDataSourceConnection;
import com.jaspersoft.ireport.designer.tools.FieldPatternDialog;
import com.jaspersoft.ireport.designer.tools.LocaleSelectorDialog;
import com.jaspersoft.ireport.designer.tools.TimeZoneDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class JRXMLDataSourceConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    private Locale tmpXMLLocale = null;
    private TimeZone tmpXMLTimeZone = null;
    private ButtonGroup buttonGroup1;
    private JButton jButton2;
    private JButton jButtonXMLDatePattern;
    private JButton jButtonXMLLocale;
    private JButton jButtonXMLNumberPattern;
    private JButton jButtonXMLTimeZone;
    private JLabel jLabel9;
    private JLabel jLabelXMLDatePattern;
    private JLabel jLabelXMLLocale;
    private JLabel jLabelXMLNumberPattern;
    private JLabel jLabelXMLRecordPath;
    private JLabel jLabelXMLTimeZone;
    private JPanel jPanel13;
    private JPanel jPanel3;
    private JPanel jPanelXML;
    private JRadioButton jRadioButtonXML_connection;
    private JRadioButton jRadioButtonXML_datasource;
    private JSeparator jSeparator9;
    private JTextField jTextFieldRecordPath;
    private JTextField jTextFieldXMLDatePattern;
    private JTextField jTextFieldXMLFile;
    private JTextField jTextFieldXMLLocaleValue;
    private JTextField jTextFieldXMLNumberPattern;
    private JTextField jTextFieldXMLTimeZoneValue;

    public JRXMLDataSourceConnectionEditor() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanelXML = new JPanel();
        this.jLabel9 = new JLabel();
        this.jTextFieldXMLFile = new JTextField();
        this.jButton2 = new JButton();
        this.jRadioButtonXML_connection = new JRadioButton();
        this.jRadioButtonXML_datasource = new JRadioButton();
        this.jPanel13 = new JPanel();
        this.jLabelXMLRecordPath = new JLabel();
        this.jTextFieldRecordPath = new JTextField();
        this.jSeparator9 = new JSeparator();
        this.jLabelXMLDatePattern = new JLabel();
        this.jTextFieldXMLDatePattern = new JTextField();
        this.jButtonXMLDatePattern = new JButton();
        this.jLabelXMLNumberPattern = new JLabel();
        this.jTextFieldXMLNumberPattern = new JTextField();
        this.jButtonXMLNumberPattern = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabelXMLLocale = new JLabel();
        this.jTextFieldXMLLocaleValue = new JTextField();
        this.jLabelXMLTimeZone = new JLabel();
        this.jButtonXMLLocale = new JButton();
        this.jTextFieldXMLTimeZoneValue = new JTextField();
        this.jButtonXMLTimeZone = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanelXML.setPreferredSize(new Dimension(1, 30));
        this.jPanelXML.setLayout(new GridBagLayout());
        this.jLabel9.setText(I18n.getString("JRXMLDataSourceConnectionEditor.Label.XMLFile"));
        this.jLabel9.setMinimumSize(new Dimension(20, 14));
        this.jLabel9.setPreferredSize(new Dimension(20, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelXML.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelXML.add((Component)this.jTextFieldXMLFile, gridBagConstraints);
        this.jButton2.setText(I18n.getString("Global.Button.Browse"));
        this.jButton2.setMargin(new Insets(2, 4, 2, 4));
        this.jButton2.setMaximumSize(new Dimension(100, 25));
        this.jButton2.setMinimumSize(new Dimension(70, 25));
        this.jButton2.setPreferredSize(new Dimension(70, 25));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 7);
        this.jPanelXML.add((Component)this.jButton2, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonXML_connection);
        this.jRadioButtonXML_connection.setText(I18n.getString("JRXMLDataSourceConnectionEditor.RadioButton.XPath"));
        this.jRadioButtonXML_connection.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonXML_connection.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonXML_connection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jRadioButtonXML_connectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 4);
        this.jPanelXML.add((Component)this.jRadioButtonXML_connection, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonXML_datasource);
        this.jRadioButtonXML_datasource.setSelected(true);
        this.jRadioButtonXML_datasource.setText(I18n.getString("JRXMLDataSourceConnectionEditor.RadioButton.Datsource"));
        this.jRadioButtonXML_datasource.setActionCommand(I18n.getString("JRXMLDataSourceConnectionEditor.RadioButton.Datasource2"));
        this.jRadioButtonXML_datasource.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonXML_datasource.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonXML_datasource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jRadioButtonXML_datasourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 4);
        this.jPanelXML.add((Component)this.jRadioButtonXML_datasource, gridBagConstraints);
        this.jPanel13.setLayout(new GridBagLayout());
        this.jLabelXMLRecordPath.setText(I18n.getString("JRXMLDataSourceConnectionEditor.Label.SelectExpression"));
        this.jLabelXMLRecordPath.setMaximumSize(new Dimension(2000, 14));
        this.jLabelXMLRecordPath.setMinimumSize(new Dimension(2, 14));
        this.jLabelXMLRecordPath.setPreferredSize(new Dimension(60, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel13.add((Component)this.jLabelXMLRecordPath, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 7);
        this.jPanel13.add((Component)this.jTextFieldRecordPath, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.jPanelXML.add((Component)this.jPanel13, gridBagConstraints);
        this.jSeparator9.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 4);
        this.jPanelXML.add((Component)this.jSeparator9, gridBagConstraints);
        this.jLabelXMLDatePattern.setText("\u65e5\u4ed8\u30d1\u30bf\u30fc\u30f3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelXML.add((Component)this.jLabelXMLDatePattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelXML.add((Component)this.jTextFieldXMLDatePattern, gridBagConstraints);
        this.jButtonXMLDatePattern.setText("\u4f5c\u6210");
        this.jButtonXMLDatePattern.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonXMLDatePattern.setMaximumSize(new Dimension(100, 25));
        this.jButtonXMLDatePattern.setMinimumSize(new Dimension(70, 25));
        this.jButtonXMLDatePattern.setPreferredSize(new Dimension(70, 25));
        this.jButtonXMLDatePattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jButton2ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 7);
        this.jPanelXML.add((Component)this.jButtonXMLDatePattern, gridBagConstraints);
        this.jLabelXMLNumberPattern.setText("\u6570\u5b57\u30d1\u30bf\u30fc\u30f3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new Insets(1, 3, 3, 3);
        this.jPanelXML.add((Component)this.jLabelXMLNumberPattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 3, 3, 3);
        this.jPanelXML.add((Component)this.jTextFieldXMLNumberPattern, gridBagConstraints);
        this.jButtonXMLNumberPattern.setText("\u4f5c\u6210");
        this.jButtonXMLNumberPattern.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonXMLNumberPattern.setMaximumSize(new Dimension(100, 25));
        this.jButtonXMLNumberPattern.setMinimumSize(new Dimension(70, 25));
        this.jButtonXMLNumberPattern.setPreferredSize(new Dimension(70, 25));
        this.jButtonXMLNumberPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jButtonXMLDatePatternjButton2ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new Insets(1, 3, 3, 7);
        this.jPanelXML.add((Component)this.jButtonXMLNumberPattern, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Locale / Time zone"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelXMLLocale.setText("\u30ed\u30ab\u30fc\u30eb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelXMLLocale, gridBagConstraints);
        this.jTextFieldXMLLocaleValue.setEditable(false);
        this.jTextFieldXMLLocaleValue.setText("\u30c7\u30d5\u30a9\u30eb\u30c8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel3.add((Component)this.jTextFieldXMLLocaleValue, gridBagConstraints);
        this.jLabelXMLTimeZone.setText("\u30bf\u30a4\u30e0\u30be\u30fc\u30f3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelXMLTimeZone, gridBagConstraints);
        this.jButtonXMLLocale.setText("\u9078\u629e...");
        this.jButtonXMLLocale.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonXMLLocale.setMaximumSize(new Dimension(100, 25));
        this.jButtonXMLLocale.setMinimumSize(new Dimension(70, 25));
        this.jButtonXMLLocale.setPreferredSize(new Dimension(70, 25));
        this.jButtonXMLLocale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jButtonXMLDatePatternjButton2ActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 8);
        this.jPanel3.add((Component)this.jButtonXMLLocale, gridBagConstraints);
        this.jTextFieldXMLTimeZoneValue.setEditable(false);
        this.jTextFieldXMLTimeZoneValue.setText("\u30c7\u30d5\u30a9\u30eb\u30c8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel3.add((Component)this.jTextFieldXMLTimeZoneValue, gridBagConstraints);
        this.jButtonXMLTimeZone.setText("\u9078\u629e...");
        this.jButtonXMLTimeZone.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonXMLTimeZone.setMaximumSize(new Dimension(100, 25));
        this.jButtonXMLTimeZone.setMinimumSize(new Dimension(70, 25));
        this.jButtonXMLTimeZone.setPreferredSize(new Dimension(70, 25));
        this.jButtonXMLTimeZone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jButtonXMLDatePattern1jButtonXMLDatePatternjButton2ActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        this.jPanel3.add((Component)this.jButtonXMLTimeZone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 0, 4);
        this.jPanelXML.add((Component)this.jPanel3, gridBagConstraints);
        this.add((Component)this.jPanelXML, "Center");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle(I18n.getString("JRXMLDataSourceConnectionEditor.Dialog.XMLFile"));
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".xml") || file.isDirectory();
            }

            public String getDescription() {
                return "XML *.xml";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File file = jfc.getSelectedFile();
            try {
                this.jTextFieldXMLFile.setText(file.getAbsolutePath());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void jRadioButtonXML_connectionActionPerformed(ActionEvent evt) {
        this.XMLDataSourceCheckBoxesChanged();
    }

    private void jRadioButtonXML_datasourceActionPerformed(ActionEvent evt) {
        this.XMLDataSourceCheckBoxesChanged();
    }

    public void XMLDataSourceCheckBoxesChanged() {
        this.jTextFieldRecordPath.setEnabled(this.jRadioButtonXML_datasource.isSelected());
        this.jLabelXMLRecordPath.setEnabled(this.jRadioButtonXML_datasource.isSelected());
    }

    private void jButtonXMLDatePattern1jButtonXMLDatePatternjButton2ActionPerformed11(ActionEvent evt) {
        TimeZoneDialog lsd = new TimeZoneDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        if (this.tmpXMLTimeZone != null) {
            lsd.setReportTimeZoneId(this.tmpXMLTimeZone.getID());
        }
        lsd.setVisible(true);
        if (lsd.getDialogResult() == 0) {
            if (lsd.getReportTimeZoneId() == null) {
                this.tmpXMLTimeZone = null;
                this.jTextFieldXMLTimeZoneValue.setText(I18n.getString("JRXMLDataSourceConnectionEditor.TextField.Default"));
            } else {
                this.tmpXMLTimeZone = TimeZone.getTimeZone(lsd.getReportTimeZoneId());
                this.jTextFieldXMLTimeZoneValue.setText(this.tmpXMLTimeZone.getDisplayName());
            }
        }
    }

    private void jButtonXMLDatePatternjButton2ActionPerformed11(ActionEvent evt) {
        LocaleSelectorDialog lsd = new LocaleSelectorDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        if (this.tmpXMLLocale != null) {
            lsd.setSelectedLocale(this.tmpXMLLocale);
        }
        lsd.setVisible(true);
        if (lsd.getDialogResult() == 0) {
            this.tmpXMLLocale = lsd.getSelectedLocale();
            this.jTextFieldXMLLocaleValue.setText(this.tmpXMLLocale == null ? I18n.getString("JRXMLDataSourceConnectionEditor.TextField.Default") : this.tmpXMLLocale.getDisplayName());
        }
    }

    private void jButtonXMLDatePatternjButton2ActionPerformed1(ActionEvent evt) {
        FieldPatternDialog fpd = new FieldPatternDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        fpd.setOnlyNumbers(true);
        if (this.jTextFieldXMLNumberPattern.getText().length() > 0) {
            fpd.setPattern(this.jTextFieldXMLNumberPattern.getText());
        }
        fpd.setVisible(true);
        if (fpd.getDialogResult() == 0) {
            this.jTextFieldXMLNumberPattern.setText(fpd.getPattern());
        }
    }

    private void jButton2ActionPerformed1(ActionEvent evt) {
        FieldPatternDialog fpd = new FieldPatternDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        fpd.setOnlyDate(true);
        if (this.jTextFieldXMLDatePattern.getText().length() > 0) {
            fpd.setPattern(this.jTextFieldXMLDatePattern.getText());
        }
        fpd.setVisible(true);
        if (fpd.getDialogResult() == 0) {
            this.jTextFieldXMLDatePattern.setText(fpd.getPattern());
        }
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof JRXMLDataSourceConnection) {
            JRXMLDataSourceConnection con = (JRXMLDataSourceConnection)this.iReportConnection;
            this.jTextFieldXMLFile.setText(con.getFilename());
            this.jTextFieldRecordPath.setText(con.getSelectExpression());
            this.jRadioButtonXML_connection.setSelected(con.isUseConnection());
            this.jRadioButtonXML_datasource.setSelected(!con.isUseConnection());
            this.jTextFieldXMLDatePattern.setText(Misc.nvl(con.getDatePattern(), ""));
            this.jTextFieldXMLNumberPattern.setText(Misc.nvl(con.getNumberPattern(), ""));
            this.tmpXMLLocale = con.getLocale();
            if (this.tmpXMLLocale != null) {
                this.jTextFieldXMLLocaleValue.setText(this.tmpXMLLocale.getDisplayName());
            } else {
                this.jTextFieldXMLLocaleValue.setText(I18n.getString("JRXMLDataSourceConnectionEditor.TextField.Default"));
            }
            this.tmpXMLTimeZone = con.getTimeZone();
            if (this.tmpXMLTimeZone != null) {
                this.jTextFieldXMLTimeZoneValue.setText(this.tmpXMLTimeZone.getDisplayName());
            } else {
                this.jTextFieldXMLTimeZoneValue.setText(I18n.getString("JRXMLDataSourceConnectionEditor.TextField.Default"));
            }
            this.XMLDataSourceCheckBoxesChanged();
        }
    }

    public IReportConnection getIReportConnection() {
        JRXMLDataSourceConnection irConn = new JRXMLDataSourceConnection();
        irConn.setFilename(this.jTextFieldXMLFile.getText().trim());
        irConn.setSelectExpression(this.jTextFieldRecordPath.getText().trim());
        irConn.setUseConnection(this.jRadioButtonXML_connection.isSelected());
        irConn.setDatePattern(this.jTextFieldXMLDatePattern.getText());
        irConn.setNumberPattern(this.jTextFieldXMLNumberPattern.getText());
        irConn.setLocale(this.tmpXMLLocale);
        irConn.setTimeZone(this.tmpXMLTimeZone);
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }
}

