/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRFont;
import org.openide.nodes.PropertySupport;

public class PdfEncodingProperty
extends PropertySupport.ReadWrite {
    private final JRFont font;
    PropertyEditor editor = null;

    public PdfEncodingProperty(JRFont font) {
        super("pdfEncoding", String.class, I18n.getString("Global.Property.PdfEncoding"), I18n.getString("Global.Property.PdfEncoding"));
        this.font = font;
        this.setValue("canEditAsText", true);
        this.setValue("oneline", true);
        this.setValue("suppressCustomEditor", true);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.font.getPdfEncoding();
    }

    public String getHtmlDisplayName() {
        return "<html><s>" + this.getDisplayName();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof String) {
            if ((val + "").trim().length() == 0) {
                val = null;
            }
            String oldValue = this.font.getOwnPdfEncoding();
            String newValue = (String)val;
            this.font.setPdfEncoding(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.font, "PdfEncoding", String.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.font.getOwnPdfEncoding() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> encodings = new ArrayList<Tag>();
            encodings.add(new Tag(null, "<\u30c7\u30d5\u30a9\u30eb\u30c8>"));
            encodings.add(new Tag("Cp1250", "CP1250 (\u4e2d\u592e\u30e8\u30fc\u30ed\u30c3\u30d1)"));
            encodings.add(new Tag("Cp1251", "CP1251 (\u30ad\u30ea\u30eb\u6587\u5b57)"));
            encodings.add(new Tag("Cp1252", "CP1252 (\u897f\u30e8\u30fc\u30ed\u30c3\u30d1ANSI \u5225\u540d WinAnsi)"));
            encodings.add(new Tag("Cp1253", "CP1253 (\u30ae\u30ea\u30b7\u30e3\u8a9e)"));
            encodings.add(new Tag("Cp1254", "CP1254 (\u30c8\u30eb\u30b3\u8a9e)"));
            encodings.add(new Tag("Cp1255", "CP1255 (\u30d8\u30d6\u30e9\u30a4\u8a9e)"));
            encodings.add(new Tag("Cp1256", "CP1256 (\u30a2\u30e9\u30d3\u30a2\u8a9e)"));
            encodings.add(new Tag("Cp1257", "CP1257 (\u30d0\u30eb\u30c1\u30c3\u30af)"));
            encodings.add(new Tag("Cp1258", "CP1258 (\u30d9\u30c8\u30ca\u30e0\u8a9e)"));
            encodings.add(new Tag("UniGB-UCS2-H", "UniGB-UCS2-H (\u4e2d\u56fd\u8a9e - \u7c21\u4f53\u5b57)"));
            encodings.add(new Tag("UniGB-UCS2-V", "UniGB-UCS2-V (\u4e2d\u56fd\u8a9e - \u7c21\u4f53\u5b57)"));
            encodings.add(new Tag("UniCNS-UCS2-H", "UniCNS-UCS2-H (\u4e2d\u56fd\u8a9e - \u7e41\u4f53\u5b57)"));
            encodings.add(new Tag("UniCNS-UCS2-V", "UniCNS-UCS2-V (\u4e2d\u56fd\u8a9e- \u7e41\u4f53\u5b57)"));
            encodings.add(new Tag("UniJIS-UCS2-H", "UniJIS-UCS2-H (\u65e5\u672c\u8a9e)"));
            encodings.add(new Tag("UniJIS-UCS2-V", "UniJIS-UCS2-V (\u65e5\u672c\u8a9e)"));
            encodings.add(new Tag("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (\u65e5\u672c\u8a9e)"));
            encodings.add(new Tag("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (\u65e5\u672c\u8a9e)"));
            encodings.add(new Tag("UniKS-UCS2-H", "UniKS-UCS2-H (\u97d3\u56fd\u8a9e)"));
            encodings.add(new Tag("UniKS-UCS2-V", "UniKS-UCS2-V (\u97d3\u56fd\u8a9e)"));
            encodings.add(new Tag("Identity-H", "Identity-H (Unicode - \u6a2a\u6587\u5b57)"));
            encodings.add(new Tag("Identity-V", "Identity-V (Unicode - \u7e26\u6587\u5b57)"));
            this.editor = new ComboBoxPropertyEditor(true, encodings);
        }
        return this.editor;
    }
}

