/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.templates;

import com.jaspersoft.ireport.designer.borders.ReportBorder;
import com.jaspersoft.ireport.designer.templates.TemplateDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class TemplateRenderer
extends JComponent
implements ListCellRenderer {
    private ImageIcon originalImage = null;
    private boolean selected = false;
    private String text = "";
    private Color selectionColor = new Color(71, 138, 229);
    private int horizontalGap = 20;
    private int verticalGap = 10;
    private int reflectionGap = 0;
    private int iconSize = 120;
    private int iconWidth = 80;
    private int iconHeight = 80;
    private ImageIcon defaultIcon = null;
    private ReportBorder reportBorder = new ReportBorder(null);

    public TemplateRenderer() {
        this.setFont(new Font("MS UI Gothic", 1, 12));
        this.defaultIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/templates/no_preview.png"));
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getIconSize() + 2 * this.getHorizontalGap(), (int)((double)this.getIconSize() * 1.5) + 10);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setForeground(list.getForeground() == null ? Color.DARK_GRAY : list.getForeground());
        this.setBackground(list.getBackground() == null ? Color.WHITE : list.getBackground());
        this.setOriginalImage(null);
        if (value instanceof TemplateDescriptor) {
            TemplateDescriptor td = (TemplateDescriptor)value;
            ImageIcon img = td.getPreviewIcon();
            this.setOriginalImage(img != null ? img : this.defaultIcon);
        } else {
            this.setOriginalImage(this.defaultIcon);
        }
        if (this.originalImage.getIconHeight() > this.originalImage.getIconWidth()) {
            this.setIconHeight(Math.min(this.getIconSize(), this.originalImage.getIconHeight()));
            this.setIconWidth((int)(1.0 * (double)this.originalImage.getIconWidth() * (double)this.getIconHeight() / (double)this.originalImage.getIconHeight()));
        } else {
            this.setIconWidth(Math.min(this.getIconSize(), this.originalImage.getIconWidth()));
            this.setIconHeight((int)(1.0 * (double)this.originalImage.getIconHeight() * (double)this.getIconWidth() / (double)this.originalImage.getIconWidth()));
        }
        this.setPreferredSize(new Dimension(this.getIconSize() + 2 * this.getHorizontalGap(), (int)((double)this.getIconSize() * 1.5) + 10));
        if (value instanceof TemplateDescriptor) {
            this.setText(((TemplateDescriptor)value).getDisplayName());
        }
        this.setSelected(isSelected);
        return this;
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        int width = this.getWidth();
        int height = this.getHeight();
        int imageWidth = this.getIconWidth();
        int imageHeight = this.getIconHeight();
        float opacity = 0.3f;
        float fadeHeight = 0.8f;
        AffineTransform tras = g2d.getTransform();
        if (this.getOriginalImage().getIconWidth() > 0 && this.getOriginalImage().getIconHeight() > 0) {
            g2d.translate((width - imageWidth) / 2, this.getVerticalGap() + this.getIconSize() - this.getIconHeight());
            if (this.isSelected()) {
                g.setColor(this.getSelectionColor());
                g2d.fillRoundRect(-3, -3, imageWidth + 6, imageHeight + 6, 5, 5);
            }
            this.reportBorder.paintShadowBorder(g2d, -6, -6, imageWidth + 12, imageHeight + 12);
            BufferedImage resizedImage = new BufferedImage(this.getOriginalImage().getIconWidth(), this.getOriginalImage().getIconHeight(), 2);
            Graphics2D rgd = resizedImage.createGraphics();
            rgd.drawImage(this.getOriginalImage().getImage(), 0, 0, null);
            resizedImage = TemplateRenderer.getFasterScaledInstance(resizedImage, imageWidth, imageHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
            g2d.drawImage((Image)resizedImage, 0, 0, this);
            g2d.translate(0, 2 * this.getIconHeight() + 3);
            g2d.scale(1.0, -1.0);
            BufferedImage reflection = new BufferedImage(imageWidth, imageHeight, 2);
            Graphics2D rg = reflection.createGraphics();
            rg.setColor(Color.WHITE);
            rg.drawImage((Image)resizedImage, 0, 0, null);
            int fadeGap = imageHeight - this.getIconSize();
            rg.setPaint(new GradientPaint(0.0f, (float)this.getIconSize() * fadeHeight + (float)fadeGap, this.getBackground(), 0.0f, imageHeight, new Color(this.getBackground().getRed(), this.getBackground().getGreen(), this.getBackground().getBlue(), (int)(255.0f * opacity))));
            rg.fillRect(0, 0, imageWidth, this.getIconSize());
            rg.dispose();
            g2d.drawRenderedImage(reflection, null);
        }
        g2d.setColor(this.getForeground());
        String text = this.getText();
        Rectangle2D rect = fm.getStringBounds(text, g);
        g2d.setTransform(tras);
        g2d.drawString(text, (int)((double)(this.getWidth() / 2) - rect.getWidth() / 2.0), this.getHeight() / 3 * 2 + fm.getHeight() + 5);
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean progressiveBilinear) {
        int h;
        int w;
        boolean isTranslucent;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        boolean bl = isTranslucent = img.getTransparency() != 1;
        if (progressiveBilinear) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (progressiveBilinear && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (progressiveBilinear && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }

    public ImageIcon getOriginalImage() {
        return this.originalImage;
    }

    public void setOriginalImage(ImageIcon originalImage) {
        this.originalImage = originalImage;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    public int getHorizontalGap() {
        return this.horizontalGap;
    }

    public void setHorizontalGap(int horizontalGap) {
        this.horizontalGap = horizontalGap;
    }

    public int getVerticalGap() {
        return this.verticalGap;
    }

    public void setVerticalGap(int varticalGap) {
        this.verticalGap = this.verticalGap;
    }

    public int getReflectionGap() {
        return this.reflectionGap;
    }

    public void setReflectionGap(int reflectionGap) {
        this.reflectionGap = reflectionGap;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }
}

