/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.tools.ClassNameComboxCellRenderer;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;

public class JRParameterDialog
extends JDialog {
    JRDesignParameter tmpParameter = null;
    private String oldName = null;
    private Map currentParameters = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ExpressionEditorArea jRTextExpressionAreaDefaultExpression;
    private JSeparator jSeparator1;
    private JTextField jTextFieldName;
    private int dialogResult;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_PARAM_NAME = 1;
    public static final int COMPONENT_PARAM_EXPRESSION = 2;

    public JRParameterDialog(Dialog parent, Map currentParameters) {
        super(parent);
        this.initAll(currentParameters);
    }

    public JRParameterDialog(Frame parent, Map currentParameters) {
        super(parent);
        this.initAll(currentParameters);
    }

    public void initAll(Map currentParameters) {
        this.setModal(true);
        this.initComponents();
        this.currentParameters = currentParameters;
        this.jRTextExpressionAreaDefaultExpression.setText("");
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRParameterDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jComboBox1.setRenderer(new ClassNameComboxCellRenderer());
        ArrayList<Tag> classes = new ArrayList<Tag>();
        classes.add(new Tag("java.lang.String", "Text"));
        classes.add(new Tag("java.util.Date", "Date"));
        classes.add(new Tag("java.sql.Time", "Date/Time"));
        classes.add(new Tag("java.lang.Boolean", "Boolean"));
        classes.add(new Tag("java.lang.Integer", "Integer"));
        classes.add(new Tag("java.lang.Double", "Double"));
        classes.add(new Tag("java.lang.Number", "Number"));
        classes.add(new Tag("java.lang.Byte", "Byte"));
        classes.add(new Tag("java.sql.Timestamp", "Timestamp"));
        classes.add(new Tag("java.lang.Float", "Float"));
        classes.add(new Tag("java.lang.Long", "Long"));
        classes.add(new Tag("java.lang.Short", "Short"));
        classes.add(new Tag("java.math.BigDecimal", "Big Decimal"));
        classes.add(new Tag("java.util.Collection", "Collection"));
        classes.add(new Tag("java.util.List", "List"));
        classes.add(new Tag("java.lang.Object", "Object"));
        classes.add(new Tag("java.io.InputStream"));
        classes.add(new Tag("net.sf.jasperreports.engine.JREmptyDataSource"));
        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(classes.toArray()));
        this.jComboBox1.setSelectedIndex(0);
        this.jComboBox1.updateUI();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionAreaDefaultExpression = new ExpressionEditorArea();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.setTitle("Add parameter");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRParameterDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRParameterDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRParameterDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setPreferredSize(new Dimension(350, 250));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Parameter name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel3.setText("Value expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jRTextExpressionAreaDefaultExpression.setPreferredSize(new Dimension(300, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jRTextExpressionAreaDefaultExpression, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel2.setText("Default Value Expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jComboBox1.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jComboBox1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.setBounds(0, 0, 320, 293);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String className;
        block5: {
            String newName = this.jTextFieldName.getText().trim();
            if (newName.length() <= 0) {
                JOptionPane.showMessageDialog(this, I18n.getString("JRParameterDialog.Message.Warning"), I18n.getString("JRParameterDialog.Message.Error"), 2);
                return;
            }
            if ((this.oldName == null || !this.oldName.equals(newName)) && this.currentParameters != null && this.currentParameters.containsKey(newName)) {
                JOptionPane.showMessageDialog(this, I18n.getString("JRParameterDialog.Message.Warning2"), I18n.getString("JRParameterDialog.Message.Error2"), 2);
                return;
            }
            className = "";
            Object obj = this.jComboBox1.getSelectedItem();
            className = obj == null ? "" : (obj instanceof Tag ? ((Tag)obj).getValue().toString() : Misc.nvl(obj, ""));
            if (className.length() == 0 || !className.matches("(\\p{Alpha}\\p{Alnum}*\\_*\\.)*(\\p{Alpha}\\p{Alnum}*\\_*)")) {
                JOptionPane.showMessageDialog(this, I18n.getString("JRParameterDialog.Message.InvalidClassName"), I18n.getString("JRParameterDialog.Message.InvalidClassNameTitle"), 2);
                return;
            }
            try {
                Class.forName(className, false, IReportManager.getReportClassLoader());
            }
            catch (ClassNotFoundException ex) {
                if (JOptionPane.showConfirmDialog(this, I18n.getString("JRParameterDialog.Message.UnknownClassName", (Object)className), I18n.getString("JRParameterDialog.Message.UnknownClassNameTitle"), 1, 1) == 0) break block5;
                return;
            }
        }
        this.tmpParameter = new JRDesignParameter();
        this.tmpParameter.setName(this.jTextFieldName.getText().trim());
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText(this.jRTextExpressionAreaDefaultExpression.getText());
        this.tmpParameter.setValueClassName(className);
        exp.setValueClassName(className);
        this.tmpParameter.setDefaultValueExpression((JRExpression)exp);
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRDesignParameter getParameter() {
        return this.tmpParameter;
    }

    public void setParameter(JRDesignParameter tmpParameter) {
        String className;
        this.jTextFieldName.setText(tmpParameter.getName());
        this.oldName = tmpParameter.getName();
        String text = "";
        if (tmpParameter.getDefaultValueExpression() != null && tmpParameter.getDefaultValueExpression().getText() != null) {
            text = tmpParameter.getDefaultValueExpression().getText();
        }
        if ((className = tmpParameter.getValueClassName()) != null) {
            for (int i = 0; i < this.jComboBox1.getItemCount(); ++i) {
                Object val = this.jComboBox1.getItemAt(i);
                if (val instanceof Tag && className.equals(((Tag)val).getValue())) {
                    this.jComboBox1.setSelectedIndex(i);
                    break;
                }
                if (!className.equals(val)) continue;
                this.jComboBox1.setSelectedIndex(i);
                break;
            }
        }
        this.jRTextExpressionAreaDefaultExpression.setText(text);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setFocusedExpression(int expID) {
        try {
            switch (expID) {
                case 2: {
                    Misc.selectTextAndFocusArea(this.jRTextExpressionAreaDefaultExpression);
                    break;
                }
                case 1: {
                    Misc.selectTextAndFocusArea(this.jTextFieldName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExpressionContext(ExpressionContext context) {
        this.jRTextExpressionAreaDefaultExpression.setExpressionContext(context);
    }
}

