/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.FileResolver;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ExpressionFileResolver
implements FileResolver {
    private JRDesignExpression expression = null;
    private JasperDesign jasperDesign = null;
    private String reportFolder = null;
    private File file = null;
    private boolean resolveFile = true;
    private JRDesignDataset dataset = null;

    public ExpressionFileResolver(JRDesignExpression expression, JRDesignDataset dataset, JasperDesign jd) {
        File reportFolderFile;
        JrxmlVisualView visualView;
        this.expression = expression;
        this.jasperDesign = jd;
        this.dataset = dataset;
        if (dataset == null) {
            this.dataset = jd.getMainDesignDataset();
        }
        if ((visualView = IReportManager.getInstance().getActiveVisualView()) != null && (reportFolderFile = FileUtil.toFile((FileObject)visualView.getEditorSupport().getDataObject().getPrimaryFile())).getParentFile() != null) {
            this.reportFolder = reportFolderFile.getParent();
        }
    }

    public File resolveFile(String arg0) {
        if (this.resolveFile) {
            try {
                this.file = Misc.locateFileFromExpression(this.jasperDesign, null, this.expression, new File(this.reportFolder), null, null);
            }
            catch (Exception ex) {
                this.file = null;
            }
        }
        return this.getFile();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        if (this.jasperDesign != jasperDesign) {
            this.jasperDesign = jasperDesign;
            this.file = null;
            this.resolveFile = true;
        }
    }

    public String getReportFolder() {
        return this.reportFolder;
    }

    public void setReportFolder(String reportFolder) {
        if (reportFolder == null && this.reportFolder == null) {
            return;
        }
        if (reportFolder != null && this.reportFolder == null || reportFolder == null && this.reportFolder != null || !reportFolder.equals(this.reportFolder)) {
            this.reportFolder = reportFolder;
            this.file = null;
            this.resolveFile = true;
        }
    }
}

