/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationForInstanceOf
implements TreeRule {
    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.INSTANCE_OF);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        return this.run(compilationInfo, treePath, CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)compilationInfo.getFileObject()));
    }

    List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath, int n) {
        Object object;
        TreePath treePath2;
        for (treePath2 = treePath; treePath2 != null && (object = treePath2.getLeaf().getKind()) != Tree.Kind.IF; treePath2 = treePath2.getParentPath()) {
            if (object != Tree.Kind.METHOD && object != Tree.Kind.CLASS) continue;
            return null;
        }
        if (treePath2 == null) {
            return null;
        }
        object = (InstanceOfTree)treePath.getLeaf();
        if (object.getType() == null || object.getType().getKind() == Tree.Kind.ERRONEOUS) {
            return null;
        }
        TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, object.getType()));
        TreePath treePath3 = new TreePath(treePath, object.getExpression());
        TypeMirror typeMirror2 = compilationInfo.getTrees().getTypeMirror(treePath3);
        if (typeMirror2 == null || !compilationInfo.getTypeUtilities().isCastable(typeMirror2, typeMirror)) {
            return null;
        }
        List<FixImpl> list = Collections.singletonList(new FixImpl(compilationInfo.getJavaSource(), TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo), TreePathHandle.create((TreePath)treePath3, (CompilationInfo)compilationInfo), TypeMirrorHandle.create((TypeMirror)typeMirror), Utilities.getName(typeMirror)));
        String string = NbBundle.getMessage(DeclarationForInstanceOf.class, (String)"ERR_DeclarationForInstanceof");
        ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)string, list, (FileObject)compilationInfo.getFileObject(), (int)n, (int)n);
        return Collections.singletonList(errorDescription);
    }

    @Override
    public String getId() {
        return DeclarationForInstanceOf.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DeclarationForInstanceOf.class, (String)"DN_DeclarationForInstanceof");
    }

    @Override
    public void cancel() {
    }

    static final class FixImpl
    implements Fix {
        private JavaSource js;
        private TreePathHandle ifHandle;
        private TreePathHandle expression;
        private TypeMirrorHandle type;
        private String name;

        public FixImpl(JavaSource javaSource, TreePathHandle treePathHandle, TreePathHandle treePathHandle2, TypeMirrorHandle typeMirrorHandle, String string) {
            this.js = javaSource;
            this.ifHandle = treePathHandle;
            this.expression = treePathHandle2;
            this.type = typeMirrorHandle;
            this.name = string;
        }

        public String getText() {
            return NbBundle.getMessage(DeclarationForInstanceOf.class, (String)"FIX_CreateDeclaration");
        }

        public ChangeInfo implement() throws Exception {
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = FixImpl.this.ifHandle.resolve((CompilationInfo)workingCopy);
                    TreePath treePath2 = FixImpl.this.expression.resolve((CompilationInfo)workingCopy);
                    TypeMirror typeMirror = FixImpl.this.type.resolve((CompilationInfo)workingCopy);
                    if (treePath == null || typeMirror == null || treePath2 == null) {
                        return;
                    }
                    IfTree ifTree = (IfTree)treePath.getLeaf();
                    StatementTree statementTree = ifTree.getThenStatement();
                    if (statementTree.getKind() == Tree.Kind.ERRONEOUS) {
                        return;
                    }
                    LinkedList<? extends StatementTree> linkedList = new LinkedList<StatementTree>();
                    if (statementTree.getKind() == Tree.Kind.BLOCK) {
                        linkedList.addAll(((BlockTree)statementTree).getStatements());
                    } else {
                        linkedList.add(statementTree);
                    }
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)FixImpl.this.name, treeMaker.Type(typeMirror), (ExpressionTree)treeMaker.TypeCast(treeMaker.Type(typeMirror), (ExpressionTree)treePath2.getLeaf()));
                    linkedList.add(0, variableTree);
                    BlockTree blockTree = treeMaker.Block(linkedList, false);
                    workingCopy.rewrite((Tree)statementTree, (Tree)blockTree);
                }
            }).commit();
            return null;
        }
    }
}

