/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

class CompiledSourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private final Map<URL, SourceForBinaryQuery.Result> cache = new HashMap<URL, SourceForBinaryQuery.Result>();
    private final String[] binaryProperties;
    private final String[] testBinaryProperties;

    public CompiledSourceForBinaryQueryImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2, String[] stringArray, String[] stringArray2) {
        assert (antProjectHelper != null);
        assert (propertyEvaluator != null);
        assert (sourceRoots != null);
        assert (sourceRoots2 != null);
        assert (stringArray != null && stringArray.length > 0);
        assert (stringArray2 != null && stringArray2.length > 0);
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = sourceRoots2;
        this.binaryProperties = stringArray;
        this.testBinaryProperties = stringArray2;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        SourceForBinaryQuery.Result result;
        if (FileUtil.getArchiveFile((URL)uRL) != null) {
            uRL = FileUtil.getArchiveFile((URL)uRL);
        }
        if ((result = this.cache.get(uRL)) != null) {
            return result;
        }
        SourceRoots sourceRoots = null;
        for (String string : this.binaryProperties) {
            if (!this.hasSources(uRL, string)) continue;
            sourceRoots = this.sourceRoots;
            break;
        }
        if (sourceRoots == null) {
            for (String string : this.testBinaryProperties) {
                if (!this.hasSources(uRL, string)) continue;
                sourceRoots = this.testRoots;
                break;
            }
        }
        if (sourceRoots == null) {
            return null;
        }
        result = new Result(sourceRoots);
        this.cache.put(uRL, result);
        return result;
    }

    private boolean hasSources(URL uRL, String string) {
        try {
            String string2 = this.evaluator.getProperty(string);
            if (string2 != null) {
                File file = this.helper.resolveFile(string2);
                URL uRL2 = file.toURI().toURL();
                if (!file.exists() && !file.getPath().toLowerCase().endsWith(".jar")) {
                    assert (!uRL2.toExternalForm().endsWith("/")) : file;
                    uRL2 = new URL(uRL2.toExternalForm() + "/");
                }
                if (uRL2.equals(uRL)) {
                    return true;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        return false;
    }

    private class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private SourceRoots sourceRoots;

        public Result(SourceRoots sourceRoots) {
            this.sourceRoots = sourceRoots;
            this.sourceRoots.addPropertyChangeListener(this);
        }

        public FileObject[] getRoots() {
            return this.sourceRoots.getRoots();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SourceRoots.PROP_ROOTS.equals(propertyChangeEvent.getPropertyName())) {
                this.changeSupport.fireChange();
            }
        }
    }
}

