/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.beans.beaninfo.BiNode;
import org.netbeans.modules.beans.beaninfo.BiPanel;
import org.netbeans.modules.beans.beaninfo.GenerateBeanInfoAction;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

final class BIEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie,
PrintCookie,
EditorCookie.Observable {
    private static final String MV_JAVA_ID = "java";
    private static final String MV_BEANINFO_ID = "beaninfo";
    private BIGES guardedEditor;
    private GuardedSectionsProvider guardedProvider;
    private GenerateBeanInfoAction.BeanInfoWorker worker;
    private CloneableTopComponent multiviewTC;
    private TopComponentsListener topComponentsListener;

    public BIEditorSupport(DataObject dataObject, CookieSet cookieSet) {
        super(dataObject, (CloneableEditorSupport.Env)new Environment(dataObject, cookieSet));
        this.setMIMEType("text/x-java");
    }

    public GuardedSectionManager getGuardedSectionManager() {
        try {
            StyledDocument styledDocument = this.openDocument();
            return GuardedSectionManager.getInstance((StyledDocument)styledDocument);
        }
        catch (IOException iOException) {
            throw (IllegalStateException)new IllegalStateException("cannot open document").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        Object object;
        if (this.guardedEditor == null) {
            this.guardedEditor = new BIGES();
            object = GuardedSectionsFactory.find((String)((DataEditorSupport.Env)this.env).getMimeType());
            if (object != null) {
                this.guardedProvider = object.create((GuardedEditorSupport)this.guardedEditor);
            }
        }
        if (this.guardedProvider != null) {
            this.guardedEditor.doc = styledDocument;
            object = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Reader reader = this.guardedProvider.createGuardedReader(inputStream, (Charset)object);
            try {
                editorKit.read(reader, (Document)styledDocument, 0);
            }
            finally {
                reader.close();
            }
        } else {
            super.loadFromStreamToKit(styledDocument, inputStream, editorKit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        if (this.guardedProvider != null) {
            Charset charset = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Writer writer = this.guardedProvider.createGuardedWriter(outputStream, charset);
            try {
                editorKit.write(writer, (Document)styledDocument, 0, styledDocument.getLength());
            }
            finally {
                writer.close();
            }
        } else {
            super.saveFromKitToStream(styledDocument, editorKit, outputStream);
        }
    }

    public void saveDocument() throws IOException {
        if (this.worker != null && this.worker.isModelModified()) {
            this.worker.generateSources();
            this.worker.waitFinished();
        }
        super.saveDocument();
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        ((Environment)this.env).addSaveCookie();
        this.updateMVTCName();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        ((Environment)this.env).removeSaveCookie();
        this.updateMVTCName();
    }

    protected void notifyClosed() {
        super.notifyClosed();
        this.worker = null;
        if (this.topComponentsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this.topComponentsListener);
            this.topComponentsListener = null;
        }
    }

    protected CloneableEditorSupport.Pane createPane() {
        DataObject dataObject = this.getDataObject();
        if (dataObject == null || !dataObject.isValid()) {
            return super.createPane();
        }
        MultiViewDescription[] multiViewDescriptionArray = new MultiViewDescription[]{new JavaView(dataObject), new BeanInfoView(dataObject)};
        return (CloneableEditorSupport.Pane)MultiViewFactory.createCloneableMultiView((MultiViewDescription[])multiViewDescriptionArray, (MultiViewDescription)multiViewDescriptionArray[0], (CloseOperationHandler)new CloseHandler(dataObject));
    }

    private void setTopComponent(TopComponent topComponent) {
        this.multiviewTC = (CloneableTopComponent)topComponent;
        this.updateMVTCName();
        if (this.topComponentsListener == null) {
            this.topComponentsListener = new TopComponentsListener();
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.topComponentsListener);
        }
    }

    private void updateMVTCName() {
        Runnable runnable = new Runnable(){

            public void run() {
                BIEditorSupport.this.updateMVTCNameInAwt();
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private void updateMVTCNameInAwt() {
        CloneableTopComponent cloneableTopComponent = this.multiviewTC;
        if (cloneableTopComponent != null) {
            String string = this.messageHtmlName();
            String string2 = this.messageName();
            String string3 = this.messageToolTip();
            for (CloneableTopComponent cloneableTopComponent2 : NbCollections.iterable((Enumeration)cloneableTopComponent.getReference().getComponents())) {
                cloneableTopComponent.setHtmlDisplayName(string);
                cloneableTopComponent.setDisplayName(string2);
                cloneableTopComponent.setName(string2);
                cloneableTopComponent.setToolTipText(string3);
            }
        }
    }

    static boolean isLastView(TopComponent topComponent) {
        if (!(topComponent instanceof CloneableTopComponent)) {
            return false;
        }
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)topComponent).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    static BIEditorSupport findEditor(DataObject dataObject) {
        return (BIEditorSupport)((Object)dataObject.getLookup().lookup(BIEditorSupport.class));
    }

    private class TopComponentsListener
    implements PropertyChangeListener {
        private TopComponentsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("opened".equals(propertyChangeEvent.getPropertyName())) {
                Set set = (Set)propertyChangeEvent.getOldValue();
                set.removeAll((Set)propertyChangeEvent.getNewValue());
                for (TopComponent topComponent : set) {
                    if (!(topComponent instanceof CloneableTopComponent)) continue;
                    CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)topComponent;
                    Enumeration enumeration = cloneableTopComponent.getReference().getComponents();
                    if (BIEditorSupport.this.multiviewTC != cloneableTopComponent) continue;
                    if (enumeration.hasMoreElements()) {
                        BIEditorSupport.this.multiviewTC = (CloneableTopComponent)enumeration.nextElement();
                        continue;
                    }
                    BIEditorSupport.this.notifyClosed();
                }
            }
        }
    }

    private static final class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -1L;
        private final transient CookieSet cookieSet;
        private transient SaveSupport saveCookie = null;

        public Environment(DataObject dataObject, CookieSet cookieSet) {
            super(dataObject);
            this.cookieSet = cookieSet;
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return BIEditorSupport.findEditor(this.getDataObject());
        }

        public void addSaveCookie() {
            DataObject dataObject = this.getDataObject();
            if (dataObject.getCookie(SaveCookie.class) == null) {
                if (this.saveCookie == null) {
                    this.saveCookie = new SaveSupport();
                }
                this.cookieSet.add((Node.Cookie)this.saveCookie);
                dataObject.setModified(true);
            }
        }

        public void removeSaveCookie() {
            DataObject dataObject = this.getDataObject();
            if (dataObject.getCookie(SaveCookie.class) != null) {
                this.cookieSet.remove((Node.Cookie)this.saveCookie);
                dataObject.setModified(false);
            }
        }

        private final class SaveSupport
        implements SaveCookie {
            private SaveSupport() {
            }

            public void save() throws IOException {
                DataObject dataObject = Environment.this.getDataObject();
                ((DataEditorSupport)Environment.this.findCloneableOpenSupport()).saveDocument();
                dataObject.setModified(false);
            }
        }
    }

    private static final class BIGES
    implements GuardedEditorSupport {
        StyledDocument doc = null;

        private BIGES() {
        }

        public StyledDocument getDocument() {
            return this.doc;
        }
    }

    private static final class BeanInfoElement
    extends CloneableTopComponent
    implements MultiViewElement,
    Externalizable {
        private static final long serialVersionUID = 1L;
        private MultiViewElementCallback callback;
        private DataObject dataObject;
        private boolean isInitialized = false;
        private final JPanel emptyToolbar = new JPanel();
        private BiPanel biPanel;

        public BeanInfoElement(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        private BeanInfoElement() {
        }

        public JComponent getVisualRepresentation() {
            return this;
        }

        public JComponent getToolbarRepresentation() {
            return this.emptyToolbar;
        }

        public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
            this.callback = multiViewElementCallback;
            BIEditorSupport bIEditorSupport = BIEditorSupport.findEditor(this.dataObject);
            bIEditorSupport.setTopComponent(multiViewElementCallback.getTopComponent());
        }

        public CloseOperationState canCloseElement() {
            return BIEditorSupport.isLastView(this.callback.getTopComponent()) ? MultiViewFactory.createUnsafeCloseState((String)BIEditorSupport.MV_JAVA_ID, (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION) : CloseOperationState.STATE_OK;
        }

        public void componentActivated() {
            super.componentActivated();
        }

        public void componentDeactivated() {
            super.componentDeactivated();
        }

        public void componentHidden() {
            super.componentHidden();
        }

        public void componentShowing() {
            super.componentShowing();
            this.initialize();
        }

        public void componentClosed() {
            super.componentClosed();
        }

        public void componentOpened() {
            super.componentOpened();
        }

        private void initialize() {
            if (!this.isInitialized) {
                this.setLayout(new BorderLayout());
                this.biPanel = new BiPanel();
                this.add((Component)((Object)this.biPanel), "Center");
                this.isInitialized = true;
            } else {
                this.biPanel.setContext((Node)new BiNode.Wait());
            }
            FileObject fileObject = this.dataObject.getPrimaryFile();
            String string = fileObject.getName();
            string = string.substring(0, string.length() - "BeanInfo".length());
            FileObject fileObject2 = fileObject.getParent().getFileObject(string, fileObject.getExt());
            BIEditorSupport bIEditorSupport = BIEditorSupport.findEditor(this.dataObject);
            if (fileObject2 != null) {
                final GenerateBeanInfoAction.BeanInfoWorker beanInfoWorker = new GenerateBeanInfoAction.BeanInfoWorker(fileObject2, this.biPanel);
                bIEditorSupport.worker = beanInfoWorker;
                beanInfoWorker.analyzePatterns().addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        beanInfoWorker.updateUI();
                    }
                });
            } else {
                this.biPanel.setContext(BiNode.createNoSourceNode(fileObject));
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.dataObject = (DataObject)objectInput.readObject();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeObject(this.dataObject);
        }
    }

    private static final class JavaElement
    extends CloneableEditor
    implements MultiViewElement,
    Externalizable {
        private static final long serialVersionUID = 1L;
        private MultiViewElementCallback callback;

        public JavaElement(CloneableEditorSupport cloneableEditorSupport) {
            super(cloneableEditorSupport);
        }

        private JavaElement() {
        }

        public JComponent getVisualRepresentation() {
            return this;
        }

        public JComponent getToolbarRepresentation() {
            Document document;
            JToolBar jToolBar = null;
            JEditorPane jEditorPane = this.getEditorPane();
            if (jEditorPane != null && (document = jEditorPane.getDocument()) instanceof NbDocument.CustomToolbar) {
                jToolBar = ((NbDocument.CustomToolbar)document).createToolbar(jEditorPane);
            }
            return jToolBar;
        }

        public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
            this.callback = multiViewElementCallback;
            BIEditorSupport bIEditorSupport = (BIEditorSupport)this.cloneableEditorSupport();
            bIEditorSupport.setTopComponent(multiViewElementCallback.getTopComponent());
        }

        public CloseOperationState canCloseElement() {
            return BIEditorSupport.isLastView(this.callback.getTopComponent()) ? MultiViewFactory.createUnsafeCloseState((String)BIEditorSupport.MV_JAVA_ID, (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION) : CloseOperationState.STATE_OK;
        }

        public void componentActivated() {
            super.componentActivated();
            BIEditorSupport bIEditorSupport = (BIEditorSupport)this.cloneableEditorSupport();
            if (bIEditorSupport.worker != null && bIEditorSupport.worker.isModelModified()) {
                bIEditorSupport.worker.generateSources();
            }
        }

        public void componentDeactivated() {
            super.componentDeactivated();
        }

        public void componentHidden() {
            super.componentHidden();
        }

        public void componentShowing() {
            super.componentShowing();
        }

        public void componentClosed() {
            super.canClose(null, true);
            super.componentClosed();
        }

        protected boolean closeLast() {
            return true;
        }

        public void componentOpened() {
            super.componentOpened();
        }

        public void updateName() {
            super.updateName();
            if (this.callback != null) {
                this.callback.updateTitle(this.getDisplayName());
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
        }
    }

    private static final class BeanInfoView
    implements MultiViewDescription,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_DATAOBJECT = "dataObject";
        private DataObject dataObject;

        public BeanInfoView(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        public int getPersistenceType() {
            return 1;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(BeanInfoView.class, (String)"LAB_BeanInfoEditorView");
        }

        public Image getIcon() {
            return this.dataObject.getNodeDelegate().getIcon(1);
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public String preferredID() {
            return BIEditorSupport.MV_BEANINFO_ID;
        }

        public MultiViewElement createElement() {
            return new BeanInfoElement(this.dataObject);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.putFields().put(FIELD_DATAOBJECT, this.dataObject);
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.dataObject = (DataObject)objectInputStream.readFields().get(FIELD_DATAOBJECT, objectInputStream);
        }
    }

    private static final class JavaView
    implements MultiViewDescription,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_DATAOBJECT = "dataObject";
        private DataObject dataObject;

        public JavaView(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        public int getPersistenceType() {
            return 1;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(JavaView.class, (String)"LAB_JavaSourceView");
        }

        public Image getIcon() {
            return this.dataObject.isValid() ? this.dataObject.getNodeDelegate().getIcon(1) : ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/warning.gif");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public String preferredID() {
            return BIEditorSupport.MV_JAVA_ID;
        }

        public MultiViewElement createElement() {
            BIEditorSupport bIEditorSupport = BIEditorSupport.findEditor(this.dataObject);
            JavaElement javaElement = new JavaElement((CloneableEditorSupport)bIEditorSupport);
            Node[] nodeArray = javaElement.getActivatedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                javaElement.setActivatedNodes(new Node[]{this.dataObject.getNodeDelegate()});
            }
            return javaElement;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.putFields().put(FIELD_DATAOBJECT, this.dataObject);
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.dataObject = (DataObject)objectInputStream.readFields().get(FIELD_DATAOBJECT, objectInputStream);
        }
    }

    private static final class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final DataObject dataObject;

        public CloseHandler(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            BIEditorSupport bIEditorSupport = BIEditorSupport.findEditor(this.dataObject);
            return bIEditorSupport != null ? bIEditorSupport.canClose() : true;
        }
    }
}

