/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.ProjectNature;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

public class FolderNodeFactory
implements NodeFactory {
    static boolean synchronous = false;

    public NodeList createNodes(Project project) {
        FreeformProject freeformProject = (FreeformProject)project.getLookup().lookup(FreeformProject.class);
        assert (freeformProject != null);
        return new RootChildren(freeformProject);
    }

    private static final class SubprojectNode
    extends AbstractNode {
        private final Project p;
        private final String label;
        private final ProjectInformation info;
        private static final Action OPEN = new OpenProjectAction();

        public SubprojectNode(Project project, String string) {
            super(Children.LEAF, Lookups.singleton((Object)project));
            this.p = project;
            this.label = string;
            this.info = ProjectUtils.getInformation((Project)project);
        }

        public String getName() {
            return this.info.getName();
        }

        public String getDisplayName() {
            return this.label != null ? this.label : this.info.getDisplayName();
        }

        public Image getIcon(int n) {
            return ImageUtilities.icon2Image((Icon)this.info.getIcon());
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{OPEN};
        }

        private static final class OpenProjectAction
        extends AbstractAction
        implements ContextAwareAction {
            private OpenProjectAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                assert (false);
            }

            public Action createContextAwareInstance(Lookup lookup) {
                final Project[] projectArray = lookup.lookupAll(Project.class).toArray(new Project[0]);
                return new AbstractAction(((OpenAction)SystemAction.get(OpenAction.class)).getName()){

                    public void actionPerformed(ActionEvent actionEvent) {
                        OpenProjects.getDefault().open(projectArray, false);
                    }

                    public boolean isEnabled() {
                        return !Arrays.asList(OpenProjects.getDefault().getOpenProjects()).containsAll(Arrays.asList(projectArray));
                    }
                };
            }
        }
    }

    private static final class ViewItemNode
    extends FilterNode {
        private final String name;
        private final String displayName;

        public ViewItemNode(Node node, String string, String string2) {
            super(node);
            this.name = string;
            this.displayName = string2;
        }

        public ViewItemNode(DataFolder dataFolder, String string, String string2, String string3, String string4) {
            super(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren((DataFilter)new GroupDataFilter(dataFolder.getPrimaryFile(), string, string2)));
            this.name = string3;
            this.displayName = string4;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return super.getDisplayName();
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }
    }

    private static final class GroupDataFilter
    implements ChangeListener,
    ChangeableDataFilter,
    DataFilter.FileBased {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final FileObject root;
        private final PathMatcher matcher;

        public GroupDataFilter(FileObject fileObject, String string, String string2) {
            this.root = fileObject;
            this.matcher = new PathMatcher(string, string2, FileUtil.toFile((FileObject)fileObject));
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptFileObject(FileObject fileObject) {
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
            assert (string != null) : fileObject + " not in " + this.root;
            if (fileObject.isFolder()) {
                string = string + "/";
            }
            if (!this.matcher.matches(string, true)) {
                return false;
            }
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.cs.fireChange();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return this.acceptFileObject(dataObject.getPrimaryFile());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RootChildren
    implements NodeList<Element>,
    AntProjectListener,
    PropertyChangeListener {
        private final FreeformProject p;
        private List<Element> keys = new ArrayList<Element>();
        private ChangeSupport cs = new ChangeSupport((Object)this);

        public RootChildren(FreeformProject freeformProject) {
            this.p = freeformProject;
        }

        public void addNotify() {
            this.updateKeys(false);
            this.p.helper().addAntProjectListener((AntProjectListener)this);
            this.p.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.keys = null;
            this.p.helper().removeAntProjectListener((AntProjectListener)this);
            this.p.evaluator().removePropertyChangeListener((PropertyChangeListener)this);
        }

        private void updateKeys(boolean bl) {
            Element element = this.p.getPrimaryConfigurationData();
            Element element2 = Util.findElement(element, "view", "http://www.netbeans.org/ns/freeform-project/2");
            if (element2 != null) {
                Element element3 = Util.findElement(element2, "items", "http://www.netbeans.org/ns/freeform-project/2");
                this.keys = Util.findSubElements(element3);
            } else {
                this.keys = Collections.emptyList();
            }
            if (bl && !synchronous) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        RootChildren.this.cs.fireChange();
                    }
                });
            } else {
                this.cs.fireChange();
            }
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            this.updateKeys(true);
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateKeys(true);
        }

        public List<Element> keys() {
            return this.keys;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public Node node(Element element) {
            DataObject dataObject;
            Element element2 = Util.findElement(element, "location", "http://www.netbeans.org/ns/freeform-project/2");
            String string = Util.findText(element2);
            String string2 = this.p.evaluator().evaluate(string);
            if (string2 == null) {
                return null;
            }
            FileObject fileObject = this.p.helper().resolveFileObject(string2);
            if (fileObject == null) {
                return null;
            }
            Element element3 = Util.findElement(element, "label", "http://www.netbeans.org/ns/freeform-project/2");
            String string3 = element3 != null ? Util.findText(element3) : null;
            if (element.getLocalName().equals("source-folder")) {
                Project project;
                if (!fileObject.isFolder()) {
                    return null;
                }
                String string4 = null;
                Element element4 = Util.findElement(element, "includes", "http://www.netbeans.org/ns/freeform-project/2");
                if (element4 != null && (string4 = this.p.evaluator().evaluate(Util.findText(element4))).matches("\\$\\{[^}]+\\}")) {
                    string4 = null;
                }
                String string5 = null;
                Element element5 = Util.findElement(element, "excludes", "http://www.netbeans.org/ns/freeform-project/2");
                if (element5 != null) {
                    string5 = this.p.evaluator().evaluate(Util.findText(element5));
                }
                String string6 = element.getAttribute("style");
                for (ProjectNature projectNature : Lookup.getDefault().lookupAll(ProjectNature.class)) {
                    if (!projectNature.getSourceFolderViewStyles().contains(string6)) continue;
                    return projectNature.createSourceFolderView(this.p, fileObject, string4, string5, string6, string, string3);
                }
                if (string6.equals("subproject")) {
                    try {
                        project = ProjectManager.getDefault().findProject(fileObject);
                        if (project != null) {
                            return new SubprojectNode(project, string3);
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    return null;
                }
                if (!string6.equals("tree")) {
                    Logger.getLogger(FolderNodeFactory.class.getName()).log(Level.WARNING, "Unrecognized <source-folder> style {0} on {1}", new Object[]{string6, fileObject});
                }
                try {
                    project = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    throw new AssertionError((Object)dataObjectNotFoundException);
                }
                return new ViewItemNode((DataFolder)project, string4, string5, string, string3);
            }
            assert (element.getLocalName().equals("source-file")) : element;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw new AssertionError((Object)dataObjectNotFoundException);
            }
            return new ViewItemNode(dataObject.getNodeDelegate(), string, string3);
        }
    }
}

