/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.j2se;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectGenerator;
import org.netbeans.modules.projectimport.eclipse.core.spi.LaunchConfiguration;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectFactorySupport;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeFactory;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeUpdater;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2SEProjectFactory
implements ProjectTypeUpdater {
    private static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    private static final Icon J2SE_PROJECT_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/j2seProject.png"));

    public boolean canHandle(ProjectTypeFactory.ProjectDescriptor projectDescriptor) {
        return projectDescriptor.getNatures().contains(JAVA_NATURE);
    }

    public Project createProject(ProjectImportModel projectImportModel, List<String> list) throws IOException {
        File file = projectImportModel.getNetBeansProjectLocation();
        if (ProjectFactorySupport.areSourceRootsOwned((ProjectImportModel)projectImportModel, (File)file, list)) {
            return null;
        }
        String string = null;
        if (new File(file, "build.xml").exists()) {
            string = "nb-build.xml";
        }
        AntProjectHelper antProjectHelper = J2SEProjectGenerator.createProject((File)file, (String)projectImportModel.getProjectName(), (File[])projectImportModel.getEclipseSourceRootsAsFileArray(), (File[])projectImportModel.getEclipseTestSourceRootsAsFileArray(), null, null, (String)string);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        boolean bl = false;
        if (new File(file, "dist").exists()) {
            editableProperties.setProperty("dist.dir", "nbdist");
            bl = true;
        }
        if (new File(file, "build").exists()) {
            editableProperties.setProperty("build.dir", "nbbuild");
            bl = true;
        }
        if (bl) {
            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        }
        J2SEProject j2SEProject = (J2SEProject)ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
        ProjectFactorySupport.updateSourceRootLabels((List)projectImportModel.getEclipseSourceRoots(), (SourceRoots)j2SEProject.getSourceRoots());
        ProjectFactorySupport.updateSourceRootLabels((List)projectImportModel.getEclipseTestSourceRoots(), (SourceRoots)j2SEProject.getTestSourceRoots());
        ProjectFactorySupport.setupSourceExcludes((AntProjectHelper)antProjectHelper, (ProjectImportModel)projectImportModel, list);
        this.setupCompilerProperties(antProjectHelper, projectImportModel);
        ProjectFactorySupport.updateProjectClassPath((AntProjectHelper)antProjectHelper, (ReferenceHelper)j2SEProject.getReferenceHelper(), (ProjectImportModel)projectImportModel, list);
        if (projectImportModel.getJavaPlatform() != null) {
            this.setExplicitJavaPlatform(antProjectHelper, projectImportModel);
        }
        this.addLaunchConfigurations(j2SEProject, projectImportModel.getLaunchConfigurations());
        ProjectManager.getDefault().saveProject((Project)j2SEProject);
        return j2SEProject;
    }

    private void setExplicitJavaPlatform(AntProjectHelper antProjectHelper, ProjectImportModel projectImportModel) {
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
        assert (nodeList.getLength() == 1) : "Broken project.xml file";
        Element element2 = element.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2se-project/3", "explicit-platform");
        element2.setAttribute("explicit-source-supported", "true");
        element.insertBefore(element2, nodeList.item(0));
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        String string = projectImportModel.getJavaPlatform().getSpecification().getVersion().toString();
        String string2 = (String)projectImportModel.getJavaPlatform().getProperties().get("platform.ant.name");
        editableProperties.setProperty("platform.active", string2);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
    }

    public String calculateKey(ProjectImportModel projectImportModel) {
        return ProjectFactorySupport.calculateKey((ProjectImportModel)projectImportModel);
    }

    public String update(Project project, ProjectImportModel projectImportModel, String string, List<String> list) throws IOException {
        if (!(project instanceof J2SEProject)) {
            throw new IOException("is not java project: " + project.getClass().getName());
        }
        String string2 = this.calculateKey(projectImportModel);
        String string3 = ProjectFactorySupport.synchronizeProjectClassPath((Project)project, (AntProjectHelper)((J2SEProject)project).getAntProjectHelper(), (ReferenceHelper)((J2SEProject)project).getReferenceHelper(), (ProjectImportModel)projectImportModel, (String)string, (String)string2, list);
        this.setupCompilerProperties(((J2SEProject)project).getAntProjectHelper(), projectImportModel);
        ProjectManager.getDefault().saveProject(project);
        return string3;
    }

    public Icon getProjectTypeIcon() {
        return J2SE_PROJECT_ICON;
    }

    public String getProjectTypeName() {
        return NbBundle.getMessage(J2SEProjectFactory.class, (String)"LABEL_Java_Project");
    }

    public List<WizardDescriptor.Panel<WizardDescriptor>> getAdditionalImportWizardPanels() {
        return Collections.emptyList();
    }

    private void setupCompilerProperties(AntProjectHelper antProjectHelper, ProjectImportModel projectImportModel) {
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("javac.source", projectImportModel.getSourceLevel());
        editableProperties.setProperty("javac.target", projectImportModel.getTargetLevel());
        editableProperties.setProperty("javac.deprecation", Boolean.toString(projectImportModel.isDeprecation()));
        editableProperties.setProperty("javac.compilerargs", projectImportModel.getCompilerArgs());
        editableProperties.setProperty("source.encoding", projectImportModel.getEncoding());
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        editableProperties = antProjectHelper.getProperties("nbproject/private/private.properties");
        editableProperties.setProperty("javac.debug", Boolean.toString(projectImportModel.isDebug()));
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties);
    }

    public File getProjectFileLocation(ProjectTypeFactory.ProjectDescriptor projectDescriptor, String string) {
        return null;
    }

    private void addLaunchConfigurations(J2SEProject j2SEProject, Collection<LaunchConfiguration> collection) {
        AntProjectHelper antProjectHelper;
        Iterator<LaunchConfiguration> iterator = collection.iterator();
        while (iterator.hasNext()) {
            antProjectHelper = iterator.next();
            if (!antProjectHelper.getType().equals("org.eclipse.jdt.launching.localJavaApplication")) {
                iterator.remove();
            }
            if (antProjectHelper.getMainType() != null) continue;
            iterator.remove();
        }
        antProjectHelper = j2SEProject.getAntProjectHelper();
        if (collection.size() == 1) {
            LaunchConfiguration launchConfiguration = collection.iterator().next();
            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
            this.storeConfig(launchConfiguration, editableProperties);
            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        } else if (!collection.isEmpty()) {
            LaunchConfiguration launchConfiguration2;
            for (LaunchConfiguration launchConfiguration2 : collection) {
                String string = "nbproject/configs/" + launchConfiguration2.getName() + ".properties";
                EditableProperties editableProperties = antProjectHelper.getProperties(string);
                this.storeConfig(launchConfiguration2, editableProperties);
                antProjectHelper.putProperties(string, editableProperties);
            }
            String string = "nbproject/private/config.properties";
            launchConfiguration2 = antProjectHelper.getProperties(string);
            launchConfiguration2.setProperty("config", collection.iterator().next().getName());
            antProjectHelper.putProperties(string, (EditableProperties)launchConfiguration2);
        }
    }

    private void storeConfig(LaunchConfiguration launchConfiguration, EditableProperties editableProperties) {
        editableProperties.setProperty("main.class", launchConfiguration.getMainType());
        if (launchConfiguration.getProgramArguments() != null) {
            editableProperties.setProperty("application.args", launchConfiguration.getProgramArguments());
        }
        if (launchConfiguration.getVmArguments() != null) {
            editableProperties.setProperty("run.jvmargs", launchConfiguration.getVmArguments());
        }
    }
}

