/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CreateDomain;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.wizards.AddDomainLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.Retriever;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class ServerWizardIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    public static final String INSTALL_ROOT_PREF_KEY = "last-install-root";
    private transient AddServerLocationPanel locationPanel = null;
    private transient AddDomainLocationPanel locationPanel2 = null;
    private WizardDescriptor wizard;
    private transient int index = 0;
    private transient WizardDescriptor.Panel[] panels = null;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private String domainsDir;
    private String domainName;
    private transient String[] steps = null;
    private int httpPort = -1;
    private int httpsPort = 8181;
    private int adminPort = 4848;
    private String installRoot;
    private String glassfishRoot;

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
    }

    public void previousPanel() {
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public String name() {
        return "GlassFish V3 Server AddInstanceIterator";
    }

    public static void showInformation(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                message.setTitle(string2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public Set instantiate() throws IOException {
        HashSet<ServerInstance> hashSet = new HashSet<ServerInstance>();
        this.ensureExecutable(new File(this.installRoot));
        File file = new File(this.domainsDir, this.domainName);
        if (!file.exists() && AddServerLocationPanel.canCreate(file)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("installfolder", this.installRoot);
            hashMap.put("homefolder", this.glassfishRoot);
            hashMap.put("displayName", (String)this.wizard.getProperty("ServInstWizard_displayName"));
            hashMap.put("domainsfolder", this.domainsDir);
            hashMap.put("domainname", this.domainName);
            CreateDomain createDomain = new CreateDomain("anonymous", "", new File(this.glassfishRoot), hashMap);
            createDomain.start();
            hashSet.add(GlassfishInstanceProvider.getDefault().getInstance(this.domainsDir));
        } else {
            GlassfishInstance glassfishInstance = GlassfishInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.glassfishRoot, this.domainsDir, this.domainName, this.httpPort, this.adminPort);
            GlassfishInstanceProvider.getDefault().addServerInstance(glassfishInstance);
            hashSet.add(glassfishInstance.getCommonInstance());
        }
        NbPreferences.forModule(ServerWizardIterator.class).put(INSTALL_ROOT_PREF_KEY, this.installRoot);
        return hashSet;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(ServerWizardIterator.class, (String)"STEP_ServerLocation"), NbBundle.getMessage(ServerWizardIterator.class, (String)"STEP_Domain")};
    }

    protected final String[] getSteps() {
        if (this.steps == null) {
            this.steps = this.createSteps();
        }
        return this.steps;
    }

    protected final WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
        }
        return this.panels;
    }

    protected WizardDescriptor.Panel[] createPanels() {
        if (this.locationPanel == null) {
            this.locationPanel = new AddServerLocationPanel(this);
            this.locationPanel.addChangeListener(this);
        }
        if (this.locationPanel2 == null) {
            this.locationPanel2 = new AddDomainLocationPanel(this);
            this.locationPanel2.addChangeListener(this);
        }
        return new WizardDescriptor.Panel[]{this.locationPanel, this.locationPanel2};
    }

    protected final int getIndex() {
        return this.index;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel panel = this.getPanels()[this.index];
        JComponent jComponent = (JComponent)panel.getComponent();
        jComponent.putClientProperty("WizardPanel_contentData", this.getSteps());
        jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.getIndex()));
        return panel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    protected final void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int n) {
        this.httpPort = n;
    }

    public void setAdminPort(int n) {
        this.adminPort = n;
    }

    public void setHttpsPort(int n) {
        this.httpsPort = n;
    }

    public void setInstallRoot(String string) {
        this.installRoot = string;
    }

    String getGlassfishRoot() {
        return this.glassfishRoot;
    }

    public void setGlassfishRoot(String string) {
        this.glassfishRoot = string;
    }

    void setDomainLocation(String string) {
        int n = string.lastIndexOf(File.separator);
        this.domainsDir = string.substring(0, n);
        this.domainName = string.substring(n + 1);
    }

    /*
     * WARNING - void declaration
     */
    private void ensureExecutable(File file) {
        Object object2;
        void file2;
        if (Utilities.isWindows()) {
            return;
        }
        if (!file.canWrite()) {
            return;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Object object3 = new String[]{"bin", "glassfish/bin", "javadb/bin", "javadb/frameworks/NetworkServer/bin", "javadb/frameworks/embedded/bin"};
        int n = ((String[])object3).length;
        boolean bl = false;
        while (file2 < n) {
            String string = object3[file2];
            object2 = new File(file, string);
            if (object2.exists()) {
                arrayList.add((String[])object2);
            }
            ++file2;
        }
        if (arrayList.size() == 0) {
            return;
        }
        object3 = new File("/bin/chmod");
        if (!((File)object3).isFile()) {
            object3 = new File("/usr/bin/chmod");
        }
        if (((File)object3).isFile()) {
            try {
                for (File stringBuilder : arrayList) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(((File)object3).getAbsolutePath());
                    arrayList2.add("u+rx");
                    object2 = stringBuilder.list();
                    for (String string : object2) {
                        if (string.indexOf(46) != -1 && !string.endsWith(".ksh")) continue;
                        arrayList2.add(string);
                    }
                    ProcessBuilder processBuilder = new ProcessBuilder(arrayList2);
                    processBuilder.directory(stringBuilder);
                    Process process = processBuilder.start();
                    int n2 = process.waitFor();
                    if (n2 == 0) continue;
                    throw new IOException(NbBundle.getMessage(Retriever.class, (String)"ERR_ChmodFailed", arrayList2, (Object)n2));
                }
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
            }
        } else {
            String string = NbBundle.getMessage(Retriever.class, (String)"ERR_ChmodNotFound");
            StringBuilder stringBuilder = new StringBuilder(string.length() + 50 * arrayList.size());
            stringBuilder.append(string);
            for (Object object2 : arrayList) {
                stringBuilder.append('\n');
                stringBuilder.append(object2);
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)stringBuilder.toString(), 2));
        }
    }
}

