/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.zip;

import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipFileIndexEntry
implements Comparable<ZipFileIndexEntry> {
    public static final ZipFileIndexEntry[] EMPTY_ARRAY = new ZipFileIndexEntry[0];
    String dir;
    boolean isDir;
    String name;
    int offset;
    int size;
    int compressedSize;
    long javatime;
    private int nativetime;

    public ZipFileIndexEntry(String path) {
        int separator = path.lastIndexOf(File.separatorChar);
        if (separator == -1) {
            this.dir = "".intern();
            this.name = path;
        } else {
            this.dir = path.substring(0, separator).intern();
            this.name = path.substring(separator + 1);
        }
    }

    public ZipFileIndexEntry(String directory, String name) {
        this.dir = directory.intern();
        this.name = name;
    }

    public String getName() {
        if (this.dir == null || this.dir.length() == 0) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.dir);
        sb.append(File.separatorChar);
        sb.append(this.name);
        return sb.toString();
    }

    public String getFileName() {
        return this.name;
    }

    public long getLastModified() {
        if (this.javatime == 0L) {
            this.javatime = ZipFileIndexEntry.dosToJavaTime(this.nativetime);
        }
        return this.javatime;
    }

    private static long dosToJavaTime(int nativetime) {
        return nativetime;
    }

    void setNativeTime(int natTime) {
        this.nativetime = natTime;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    @Override
    public int compareTo(ZipFileIndexEntry other) {
        int c;
        String otherD = other.dir;
        if (this.dir != otherD && (c = this.dir.compareTo(otherD)) != 0) {
            return c;
        }
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return this.isDir ? "Dir:" + this.dir + " : " + this.name : this.dir + ":" + this.name;
    }
}

