/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.io.IOException;
import java.util.Map;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Properties;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Property;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.EclipseLinkProvider;
import org.netbeans.modules.j2ee.persistence.provider.HibernateProvider;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.KodoProvider;
import org.netbeans.modules.j2ee.persistence.provider.OpenJPAProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ToplinkProvider;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.spi.server.ServerStatusProvider;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class ProviderUtil {
    public static final Provider HIBERNATE_PROVIDER = new HibernateProvider();
    public static final Provider TOPLINK_PROVIDER = ToplinkProvider.create();
    public static final Provider ECLIPSELINK_PROVIDER = new EclipseLinkProvider();
    public static final Provider KODO_PROVIDER = new KodoProvider();
    public static final Provider OPENJPA_PROVIDER = new OpenJPAProvider();
    public static final Provider DEFAULT_PROVIDER = new DefaultProvider();
    private static final Provider TOPLINK_PROVIDER_55_COMPATIBLE = ToplinkProvider.create55Compatible();

    private ProviderUtil() {
    }

    public static Provider getProvider(String string, Project project) {
        if (null == string || "".equals(string.trim())) {
            return ProviderUtil.getContainerManagedProvider(project);
        }
        for (Provider provider : ProviderUtil.getAllProviders()) {
            if (!provider.getProviderClass().equals(string.trim())) continue;
            return provider;
        }
        return DEFAULT_PROVIDER;
    }

    private static Provider getContainerManagedProvider(Project project) {
        PersistenceProviderSupplier persistenceProviderSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        if (persistenceProviderSupplier == null || !persistenceProviderSupplier.supportsDefaultProvider() || persistenceProviderSupplier.getSupportedProviders().isEmpty()) {
            return null;
        }
        return persistenceProviderSupplier.getSupportedProviders().get(0);
    }

    public static DatabaseConnection getConnection(PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"pu", (Object)((Object)persistenceUnit));
        if (persistenceUnit.getProperties() == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        Property[] propertyArray = persistenceUnit.getProperties().getProperty2();
        Provider provider = ProviderUtil.getProvider(persistenceUnit);
        for (int i = 0; i < propertyArray.length; ++i) {
            String string4 = propertyArray[i].getName();
            if (string4 == null) continue;
            if (string4.equals(provider.getJdbcUrl())) {
                string = propertyArray[i].getValue();
                continue;
            }
            if (string4.equals(provider.getJdbcDriver())) {
                string2 = propertyArray[i].getValue();
                continue;
            }
            if (!string4.equals(provider.getJdbcUsername())) continue;
            string3 = propertyArray[i].getValue();
        }
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            DatabaseConnection databaseConnection = databaseConnectionArray[i];
            if (!databaseConnection.getDatabaseURL().equals(string) || !databaseConnection.getDriverClass().equals(string2) || !databaseConnection.getUser().equals(string3)) continue;
            return databaseConnection;
        }
        return null;
    }

    public static void setTableGeneration(PersistenceUnit persistenceUnit, String string, Project project) {
        String string2 = persistenceUnit.getProvider();
        Provider provider = ProviderUtil.getProvider(string2, project);
        ProviderUtil.setTableGeneration(persistenceUnit, string, provider);
    }

    public static void setTableGeneration(PersistenceUnit persistenceUnit, String string, Provider provider) {
        Property property;
        if (provider == null) {
            return;
        }
        Property property2 = provider.getTableGenerationProperty(string);
        Properties properties = persistenceUnit.getProperties();
        if (properties == null) {
            properties = persistenceUnit.newProperties();
            persistenceUnit.setProperties(properties);
        }
        if ((property = ProviderUtil.getProperty(properties.getProperty2(), provider.getTableGenerationPropertyName())) != null && property2 == null) {
            properties.removeProperty2(property);
        } else if (property != null && property2 != null) {
            property.setValue(property2.getValue());
        } else if (property2 != null) {
            properties.addProperty2(property2);
        }
    }

    public static void setProvider(PersistenceUnit persistenceUnit, Provider provider, DatabaseConnection databaseConnection, String string) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)((Object)persistenceUnit));
        Parameters.notNull((CharSequence)"connection", (Object)databaseConnection);
        Parameters.notNull((CharSequence)"provider", (Object)provider);
        ProviderUtil.removeProviderProperties(persistenceUnit);
        persistenceUnit.setProvider(provider.getProviderClass());
        ProviderUtil.setDatabaseConnection(persistenceUnit, databaseConnection);
        ProviderUtil.setTableGeneration(persistenceUnit, string, provider);
    }

    public static void removeProviderProperties(PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)((Object)persistenceUnit));
        Provider provider = ProviderUtil.getProvider(persistenceUnit);
        Property[] propertyArray = ProviderUtil.getProperties(persistenceUnit);
        if (provider != null) {
            for (int i = 0; i < propertyArray.length; ++i) {
                Property property = propertyArray[i];
                if (!provider.getPropertyNames().contains(property.getName())) continue;
                persistenceUnit.getProperties().removeProperty2(property);
            }
        }
        persistenceUnit.setProvider(null);
    }

    public static PersistenceUnit buildPersistenceUnit(String string, Provider provider, DatabaseConnection databaseConnection) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"provider", (Object)provider);
        Parameters.notNull((CharSequence)"connection", (Object)databaseConnection);
        PersistenceUnit persistenceUnit = new PersistenceUnit();
        persistenceUnit.setName(string);
        persistenceUnit.setProvider(provider.getProviderClass());
        Properties properties = persistenceUnit.newProperties();
        Map<String, String> map = provider.getConnectionPropertiesMap(databaseConnection);
        for (String object : map.keySet()) {
            Object object2 = properties.newProperty();
            object2.setName(object);
            object2.setValue(map.get(object));
            properties.addProperty2((Property)((Object)object2));
        }
        Map map2 = provider.getDefaultVendorSpecificProperties();
        for (Object object2 : map2.keySet()) {
            Property property = properties.newProperty();
            property.setName((String)object2);
            property.setValue((String)map2.get(object2));
            properties.addProperty2(property);
        }
        persistenceUnit.setProperties(properties);
        return persistenceUnit;
    }

    public static void setDatabaseConnection(PersistenceUnit persistenceUnit, DatabaseConnection databaseConnection) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)((Object)persistenceUnit));
        Parameters.notNull((CharSequence)"connection", (Object)databaseConnection);
        Provider provider = ProviderUtil.getProvider(persistenceUnit);
        Property[] propertyArray = ProviderUtil.getProperties(persistenceUnit);
        Map<String, String> map = provider.getConnectionPropertiesMap(databaseConnection);
        for (String string : map.keySet()) {
            String string2;
            Property property = ProviderUtil.getProperty(propertyArray, string);
            if (property == null) {
                if (persistenceUnit.getProperties() == null) {
                    persistenceUnit.setProperties(persistenceUnit.newProperties());
                }
                property = persistenceUnit.getProperties().newProperty();
                property.setName(string);
                persistenceUnit.getProperties().addProperty2(property);
            }
            if ((string2 = map.get(string)) == null) {
                string2 = "";
            }
            property.setValue(string2);
        }
    }

    static Property[] getProperties(PersistenceUnit persistenceUnit) {
        if (persistenceUnit.getProperties() != null) {
            return persistenceUnit.getProperties().getProperty2();
        }
        return new Property[0];
    }

    private static Property getProperty(Property[] propertyArray, String string) {
        if (null == propertyArray) {
            return null;
        }
        for (int i = 0; i < propertyArray.length; ++i) {
            Property property = propertyArray[i];
            if (property.getName() == null || !property.getName().equals(string)) continue;
            return property;
        }
        return null;
    }

    public static Property getProperty(PersistenceUnit persistenceUnit, String string) {
        if (persistenceUnit.getProperties() == null) {
            return null;
        }
        return ProviderUtil.getProperty(persistenceUnit.getProperties().getProperty2(), string);
    }

    public static Provider getProvider(PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)((Object)persistenceUnit));
        for (Provider provider : ProviderUtil.getAllProviders()) {
            if (!provider.getProviderClass().equals(persistenceUnit.getProvider())) continue;
            return provider;
        }
        return DEFAULT_PROVIDER;
    }

    public static boolean isValid(PUDataObject pUDataObject) {
        return null == pUDataObject ? false : pUDataObject.parseDocument();
    }

    public static PersistenceUnit[] getPersistenceUnits(PUDataObject pUDataObject) {
        if (pUDataObject.getPersistence() == null) {
            return new PersistenceUnit[0];
        }
        return pUDataObject.getPersistence().getPersistenceUnit();
    }

    public static void renameManagedClass(PersistenceUnit persistenceUnit, String string, String string2, PUDataObject pUDataObject) {
        pUDataObject.removeClass(persistenceUnit, string2);
        pUDataObject.addClass(persistenceUnit, string);
    }

    public static void removeManagedClass(PersistenceUnit persistenceUnit, String string, PUDataObject pUDataObject) {
        pUDataObject.removeClass(persistenceUnit, string);
    }

    public static void addManagedClass(PersistenceUnit persistenceUnit, String string, PUDataObject pUDataObject) {
        pUDataObject.addClass(persistenceUnit, string);
    }

    public static void addPersistenceUnit(PersistenceUnit persistenceUnit, Project project) throws InvalidPersistenceXmlException {
        PUDataObject pUDataObject = ProviderUtil.getPUDataObject(project);
        pUDataObject.addPersistenceUnit(persistenceUnit);
        pUDataObject.save();
    }

    public static PUDataObject getPUDataObject(FileObject fileObject) throws InvalidPersistenceXmlException {
        Parameters.notNull((CharSequence)"fo", (Object)fileObject);
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        if (!(dataObject instanceof PUDataObject)) {
            throw new InvalidPersistenceXmlException(FileUtil.getFileDisplayName((FileObject)fileObject));
        }
        return (PUDataObject)dataObject;
    }

    public static synchronized PUDataObject getPUDataObject(Project project) throws InvalidPersistenceXmlException {
        Parameters.notNull((CharSequence)"project", (Object)project);
        FileObject fileObject = ProviderUtil.getDDFile(project);
        if (fileObject == null) {
            try {
                fileObject = ProviderUtil.createPersistenceDDFile(project);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject == null) {
            return null;
        }
        return ProviderUtil.getPUDataObject(fileObject);
    }

    private static FileObject createPersistenceDDFile(Project project) throws IOException {
        final FileObject fileObject = PersistenceLocation.createLocation((Project)project);
        if (fileObject == null) {
            return null;
        }
        final FileObject[] fileObjectArray = new FileObject[1];
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                fileObjectArray[0] = FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-j2ee-persistence/persistence-1.0.xml"), (FileObject)fileObject, (String)"persistence");
            }
        });
        return fileObjectArray[0];
    }

    public static boolean persistenceExists(Project project) throws InvalidPersistenceXmlException {
        Parameters.notNull((CharSequence)"project", (Object)project);
        if (ProviderUtil.getDDFile(project) == null) {
            return false;
        }
        PUDataObject pUDataObject = ProviderUtil.getPUDataObject(project);
        return pUDataObject.getPersistence().getPersistenceUnit().length > 0;
    }

    public static FileObject getDDFile(Project project) {
        int n = 0;
        PersistenceScope[] persistenceScopeArray = PersistenceUtils.getPersistenceScopes(project);
        if (n < persistenceScopeArray.length) {
            return persistenceScopeArray[n].getPersistenceXml();
        }
        return null;
    }

    public static Provider[] getAllProviders() {
        return new Provider[]{TOPLINK_PROVIDER, ECLIPSELINK_PROVIDER, HIBERNATE_PROVIDER, KODO_PROVIDER, OPENJPA_PROVIDER, TOPLINK_PROVIDER_55_COMPATIBLE};
    }

    public static boolean makePortableIfPossible(Project project, PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)((Object)persistenceUnit));
        if (Util.isJavaSE(project)) {
            return false;
        }
        Provider provider = ProviderUtil.getContainerManagedProvider(project);
        if (provider == null) {
            return false;
        }
        if (provider.getProviderClass().equals(persistenceUnit.getProvider()) && persistenceUnit.getProperties().sizeProperty2() == 0) {
            persistenceUnit.setProvider(null);
            return true;
        }
        return false;
    }

    public static boolean isValidServerInstanceOrNone(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        ServerStatusProvider serverStatusProvider = (ServerStatusProvider)project.getLookup().lookup(ServerStatusProvider.class);
        if (serverStatusProvider == null) {
            return true;
        }
        return serverStatusProvider.validServerInstancePresent();
    }
}

