/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Properties;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Property;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.unit.AddEntityDialog;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceValidator;
import org.netbeans.modules.j2ee.persistence.util.PersistenceProviderComboboxHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.JdbcListCellRenderer;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PersistenceUnitPanel
extends SectionInnerPanel {
    private final PersistenceUnit persistenceUnit;
    private PUDataObject dObj;
    private Project project;
    private boolean isContainerManaged;
    private JButton addClassButton;
    private ButtonGroup buttonGroup2;
    private JLabel datasourceLabel;
    private JRadioButton ddCreate;
    private JRadioButton ddDropCreate;
    private JRadioButton ddUnknown;
    private JComboBox dsCombo;
    private JPanel entityClassesPanel;
    private JList entityList;
    private JScrollPane entityScrollPane;
    private JCheckBox includeAllEntities;
    private JPanel includeAllPanel;
    private JLabel includeEntitiesLabel;
    private JLabel jLabel3;
    private JComboBox jdbcComboBox;
    private JLabel jdbcLabel;
    private JCheckBox jtaCheckBox;
    private JComboBox libraryComboBox;
    private JLabel libraryLabel;
    private JLabel nameLabel;
    private JPanel namePanel;
    private JTextField nameTextField;
    private JComboBox providerCombo;
    private JPanel providerDataSourcePanel;
    private JPanel providerJdbcPanel;
    private JPanel providerPanel;
    private JButton removeClassButton;
    private JLabel tableGenerationLabel;
    private JPanel tableGenerationPanel;

    public PersistenceUnitPanel(SectionView sectionView, PUDataObject pUDataObject, PersistenceUnit persistenceUnit) {
        super(sectionView);
        this.dObj = pUDataObject;
        this.persistenceUnit = persistenceUnit;
        this.project = FileOwnerQuery.getOwner((FileObject)this.dObj.getPrimaryFile());
        assert (this.project != null) : "Could not resolve project for " + pUDataObject.getPrimaryFile();
        this.isContainerManaged = PersistenceLibrarySupport.getLibrary(persistenceUnit) != null && ProviderUtil.getConnection(persistenceUnit) != null ? false : (persistenceUnit.getJtaDataSource() != null || persistenceUnit.getNonJtaDataSource() != null ? true : Util.isSupportedJavaEEVersion(this.project));
        this.initComponents();
        PersistenceProviderComboboxHelper persistenceProviderComboboxHelper = new PersistenceProviderComboboxHelper(this.project);
        if (this.isContainerManaged) {
            persistenceProviderComboboxHelper.connect(this.providerCombo);
            Provider provider = ProviderUtil.getProvider(persistenceUnit);
            this.providerCombo.setSelectedItem(provider);
        } else {
            persistenceProviderComboboxHelper.connect(this.libraryComboBox);
            this.setSelectedLibrary();
        }
        this.setVisiblePanel();
        this.initIncludeAllEntities();
        this.initEntityList();
        this.initDataSource();
        this.initJdbcComboBox();
        this.nameTextField.setText(persistenceUnit.getName());
        this.setTableGeneration();
        this.handleCmAmSelection();
        this.registerModifiers();
    }

    private void registerModifiers() {
        if (this.isContainerManaged) {
            this.addImmediateModifier(this.dsCombo);
            if (this.dsCombo.isEditable()) {
                this.addImmediateModifier((JTextComponent)this.dsCombo.getEditor().getEditorComponent());
            }
            this.addImmediateModifier(this.providerCombo);
            this.addImmediateModifier(this.jtaCheckBox);
        } else {
            this.addImmediateModifier(this.jdbcComboBox);
            this.addImmediateModifier(this.libraryComboBox);
        }
        this.addImmediateModifier(this.nameTextField);
        this.addImmediateModifier(this.ddDropCreate);
        this.addImmediateModifier(this.ddCreate);
        this.addImmediateModifier(this.ddUnknown);
        this.addImmediateModifier(this.includeAllEntities);
    }

    private void setVisiblePanel() {
        String string = this.isContainerManaged ? "container" : "application";
        ((CardLayout)this.providerPanel.getLayout()).show(this.providerPanel, string);
    }

    private void initDataSource() {
        this.jtaCheckBox.setEnabled(this.isContainerManaged);
        if (this.isContainerManaged && ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            String string = this.persistenceUnit.getJtaDataSource();
            String string2 = this.persistenceUnit.getNonJtaDataSource();
            JPADataSourcePopulator jPADataSourcePopulator = (JPADataSourcePopulator)this.project.getLookup().lookup(JPADataSourcePopulator.class);
            if (jPADataSourcePopulator != null) {
                jPADataSourcePopulator.connect(this.dsCombo);
                this.addModifier((JTextComponent)this.dsCombo.getEditor().getEditorComponent(), false);
            }
            String string3 = string != null ? string : string2;
            this.selectDatasource(string3);
            this.jtaCheckBox.setSelected(string != null);
            String string4 = this.persistenceUnit.getProvider();
            for (int i = 0; i < this.providerCombo.getItemCount(); ++i) {
                Object e = this.providerCombo.getItemAt(i);
                if (!(e instanceof Provider) || !((Provider)e).getProviderClass().equals(string4)) continue;
                this.providerCombo.setSelectedIndex(i);
                break;
            }
        } else if (!this.isContainerManaged) {
            this.setSelectedConnection();
            this.setSelectedLibrary();
            this.jtaCheckBox.setSelected(false);
        }
    }

    private void initJdbcComboBox() {
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            this.jdbcComboBox.addItem(databaseConnectionArray[i]);
        }
        this.setSelectedConnection();
    }

    private void initIncludeAllEntities() {
        boolean bl = Util.isJavaSE(this.project);
        this.includeAllEntities.setEnabled(!bl);
        this.includeAllEntities.setSelected(!bl && !this.persistenceUnit.isExcludeUnlistedClasses());
        this.includeAllEntities.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_IncludeAllEntities", (Object[])new Object[]{ProjectUtils.getInformation((Project)this.project).getDisplayName()}));
    }

    private void initEntityList() {
        this.initEntityListControls();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : this.persistenceUnit.getClass2()) {
            defaultListModel.addElement(string);
        }
        this.entityList.setModel(defaultListModel);
    }

    private void initEntityListControls() {
        boolean bl = !this.includeAllEntities.isSelected();
        this.entityList.setEnabled(bl);
        this.addClassButton.setEnabled(bl);
        this.removeClassButton.setEnabled(bl);
    }

    private void setSelectedLibrary() {
        Provider provider = ProviderUtil.getProvider(this.persistenceUnit);
        if (provider == null) {
            return;
        }
        for (int i = 0; i < this.libraryComboBox.getItemCount(); ++i) {
            Object e = this.libraryComboBox.getItemAt(i);
            Provider provider2 = (Provider)(e instanceof Provider ? e : null);
            if (provider2 == null || !provider2.equals(provider)) continue;
            this.libraryComboBox.setSelectedIndex(i);
            break;
        }
    }

    private Provider getSelectedProvider() {
        if (this.isContainerManaged) {
            return (Provider)this.providerCombo.getSelectedItem();
        }
        Object object = this.libraryComboBox.getSelectedItem();
        Provider provider = (Provider)(object instanceof Provider ? object : null);
        if (provider != null) {
            return provider;
        }
        return ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project);
    }

    private void setTableGeneration() {
        Property property;
        Provider provider = this.getSelectedProvider();
        Property property2 = property = provider == null ? null : ProviderUtil.getProperty(this.persistenceUnit, provider.getTableGenerationPropertyName());
        if (property != null) {
            if (provider.getTableGenerationCreateValue().equals(property.getValue())) {
                this.ddCreate.setSelected(true);
            } else if (provider.getTableGenerationDropCreateValue().equals(property.getValue())) {
                this.ddDropCreate.setSelected(true);
            }
        } else {
            this.ddUnknown.setSelected(true);
        }
        boolean bl = provider == null ? false : provider.supportsTableGeneration();
        this.ddCreate.setEnabled(bl);
        this.ddDropCreate.setEnabled(bl);
        this.ddUnknown.setEnabled(bl);
    }

    private void setSelectedConnection() {
        DatabaseConnection databaseConnection = ProviderUtil.getConnection(this.persistenceUnit);
        if (databaseConnection != null) {
            this.jdbcComboBox.setSelectedItem(databaseConnection);
        } else {
            Properties properties = this.persistenceUnit.getProperties();
            if (properties != null) {
                Property[] propertyArray = properties.getProperty2();
                String string = null;
                Provider provider = ProviderUtil.getProvider(this.persistenceUnit);
                for (int i = 0; i < propertyArray.length; ++i) {
                    String string2 = propertyArray[i].getName();
                    if (!provider.getJdbcUrl().equals(string2)) continue;
                    string = propertyArray[i].getValue();
                    break;
                }
                if (string == null) {
                    string = NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_CustomConnection");
                }
                this.jdbcComboBox.addItem(string);
                this.jdbcComboBox.setSelectedItem(string);
            }
        }
    }

    public void setValue(JComponent jComponent, Object object) {
        if (jComponent == this.nameTextField) {
            this.persistenceUnit.setName((String)object);
        } else if (jComponent == this.dsCombo) {
            this.setDataSource();
        } else if (jComponent == this.dsCombo.getEditor().getEditorComponent()) {
            this.setDataSource((String)object);
        } else if (jComponent == this.jdbcComboBox) {
            if (object instanceof DatabaseConnection) {
                ProviderUtil.setDatabaseConnection(this.persistenceUnit, (DatabaseConnection)object);
            }
        } else if (jComponent == this.libraryComboBox) {
            this.setProvider();
            this.setTableGeneration();
        } else if (this.providerCombo == jComponent) {
            this.setProvider();
            this.setDataSource();
        } else if (jComponent == this.ddCreate || jComponent == this.ddDropCreate || jComponent == this.ddUnknown) {
            ProviderUtil.setTableGeneration(this.persistenceUnit, this.getTableGeneration(), ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project));
        } else if (jComponent == this.includeAllEntities) {
            this.persistenceUnit.setExcludeUnlistedClasses(!this.includeAllEntities.isSelected());
        } else if (jComponent == this.jtaCheckBox) {
            this.setDataSource();
        }
        this.performValidation();
    }

    private void performValidation() {
        PersistenceValidator persistenceValidator = new PersistenceValidator(this.dObj);
        List<Error> list = persistenceValidator.validate();
        if (!list.isEmpty()) {
            this.getSectionView().getErrorPanel().setError(list.get(0));
        } else {
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    private void setDataSource() {
        this.setDataSource(null);
    }

    private void setProvider() {
        if (this.isContainerManaged && this.providerCombo.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.providerCombo.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                this.persistenceUnit.setProvider(provider.getProviderClass());
                this.setTableGeneration();
            }
            ProviderUtil.makePortableIfPossible(this.project, this.persistenceUnit);
        } else if (this.libraryComboBox.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.libraryComboBox.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                ProviderUtil.setProvider(this.persistenceUnit, provider, this.getSelectedConnection(), this.getTableGeneration());
            }
        }
    }

    private void setDataSource(String string) {
        String string2 = string;
        if (string2 == null) {
            JPADataSource jPADataSource;
            int n = this.dsCombo.getSelectedIndex();
            Object object = this.dsCombo.getSelectedItem();
            JPADataSourceProvider jPADataSourceProvider = (JPADataSourceProvider)this.project.getLookup().lookup(JPADataSourceProvider.class);
            JPADataSource jPADataSource2 = jPADataSource = jPADataSourceProvider != null ? jPADataSourceProvider.toJPADataSource(object) : null;
            if (jPADataSource != null) {
                string2 = jPADataSource.getJndiName();
            } else if (n == -1 && object != null) {
                string2 = object.toString();
            }
        }
        if (string2 == null) {
            return;
        }
        if (this.isJta()) {
            this.persistenceUnit.setJtaDataSource(string2);
            this.persistenceUnit.setNonJtaDataSource(null);
        } else {
            this.persistenceUnit.setJtaDataSource(null);
            this.persistenceUnit.setNonJtaDataSource(string2);
        }
    }

    private boolean isJta() {
        return this.jtaCheckBox.isEnabled() && this.jtaCheckBox.isSelected();
    }

    private String getTableGeneration() {
        if (this.ddCreate.isSelected()) {
            return "tableGenerationCreate";
        }
        if (this.ddDropCreate.isSelected()) {
            return "tableGenerationDropCreate";
        }
        return "tableGenerationUnknown";
    }

    private DatabaseConnection getSelectedConnection() {
        DatabaseConnection databaseConnection = null;
        if (this.jdbcComboBox.getSelectedItem() instanceof DatabaseConnection) {
            databaseConnection = (DatabaseConnection)this.jdbcComboBox.getSelectedItem();
        }
        return databaseConnection;
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (this.nameTextField == jTextComponent) {
            this.nameTextField.setText(this.persistenceUnit.getName());
        } else if (this.dsCombo.getEditor().getEditorComponent() == jTextComponent) {
            String string = this.isJta() ? this.persistenceUnit.getJtaDataSource() : this.persistenceUnit.getNonJtaDataSource();
            this.selectDatasource(string);
        }
    }

    private void selectDatasource(String string) {
        Object object = this.findDatasource(string);
        this.dsCombo.setSelectedItem(object);
        if (this.dsCombo.getEditor() != null) {
            this.dsCombo.configureEditor(this.dsCombo.getEditor(), object);
        }
    }

    private Object findDatasource(String string) {
        if (string != null) {
            int n = this.dsCombo.getItemCount();
            for (int i = 0; i < n; ++i) {
                Object e = this.dsCombo.getItemAt(i);
                if (!(e instanceof JPADataSource) || !string.equals(((JPADataSource)e).getJndiName())) continue;
                return (JPADataSource)e;
            }
        }
        return string;
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        if ("name".equals(string)) {
            return this.nameTextField;
        }
        return null;
    }

    private void handleCmAmSelection() {
        boolean bl = this.isContainerManaged;
        this.datasourceLabel.setEnabled(bl);
        this.dsCombo.setEnabled(bl);
        this.jtaCheckBox.setEnabled(bl);
        this.libraryLabel.setEnabled(!bl);
        this.libraryComboBox.setEnabled(!bl);
        this.jdbcLabel.setEnabled(!bl);
        this.jdbcComboBox.setEnabled(!bl);
        this.setTableGeneration();
    }

    private void initComponents() {
        this.buttonGroup2 = new ButtonGroup();
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.providerPanel = new JPanel();
        this.providerDataSourcePanel = new JPanel();
        this.datasourceLabel = new JLabel();
        this.jtaCheckBox = new JCheckBox();
        this.dsCombo = new JComboBox();
        this.providerCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.providerJdbcPanel = new JPanel();
        this.libraryLabel = new JLabel();
        this.jdbcLabel = new JLabel();
        this.libraryComboBox = new JComboBox();
        this.jdbcComboBox = new JComboBox();
        this.tableGenerationPanel = new JPanel();
        this.tableGenerationLabel = new JLabel();
        this.ddCreate = new JRadioButton();
        this.ddDropCreate = new JRadioButton();
        this.ddUnknown = new JRadioButton();
        this.includeAllPanel = new JPanel();
        this.includeAllEntities = new JCheckBox();
        this.entityClassesPanel = new JPanel();
        this.entityScrollPane = new JScrollPane();
        this.entityList = new JList();
        this.addClassButton = new JButton();
        this.removeClassButton = new JButton();
        this.includeEntitiesLabel = new JLabel();
        this.namePanel.setOpaque(false);
        this.nameLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_UnitName"));
        GroupLayout groupLayout = new GroupLayout((Container)this.namePanel);
        this.namePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.nameLabel).add(32, 32, 32).add((Component)this.nameTextField, -2, 440, -2).addContainerGap(136, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameTextField, -2, -1, -2)).addContainerGap()));
        this.providerPanel.setOpaque(false);
        this.providerPanel.setLayout(new CardLayout());
        this.providerDataSourcePanel.setOpaque(false);
        this.datasourceLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_DatasourceName"));
        this.jtaCheckBox.setSelected(true);
        this.jtaCheckBox.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JTA"));
        this.jtaCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jtaCheckBox.setOpaque(false);
        this.dsCombo.setEditable(true);
        this.providerCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle");
        this.jLabel3.setText(resourceBundle.getString("LBL_Provider"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.providerDataSourcePanel);
        this.providerDataSourcePanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.datasourceLabel)).add(43, 43, 43).add((GroupLayout.Group)groupLayout2.createParallelGroup(1, false).add((Component)this.providerCombo, 0, -1, Short.MAX_VALUE).add((Component)this.dsCombo, 0, 436, Short.MAX_VALUE))).add((Component)this.jtaCheckBox)).add(79, 79, 79)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.providerCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.datasourceLabel).add((Component)this.dsCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.jtaCheckBox).add(48, 48, 48)));
        this.providerPanel.add((Component)this.providerDataSourcePanel, "container");
        this.providerJdbcPanel.setOpaque(false);
        this.libraryLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_PersistenceLibrary"));
        this.jdbcLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JdbcConnection"));
        this.libraryComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.libraryComboBoxActionPerformed(actionEvent);
            }
        });
        this.jdbcComboBox.setRenderer(new JdbcListCellRenderer());
        GroupLayout groupLayout3 = new GroupLayout((Container)this.providerJdbcPanel);
        this.providerJdbcPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.libraryLabel).add((Component)this.jdbcLabel)).add(47, 47, 47).add((GroupLayout.Group)groupLayout3.createParallelGroup(1, false).add((Component)this.jdbcComboBox, 0, -1, Short.MAX_VALUE).add((Component)this.libraryComboBox, 0, 442, Short.MAX_VALUE)).addContainerGap(135, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.libraryLabel).add((Component)this.libraryComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jdbcLabel).add((Component)this.jdbcComboBox, -2, -1, -2)).addContainerGap(37, Short.MAX_VALUE)));
        this.providerPanel.add((Component)this.providerJdbcPanel, "application");
        this.tableGenerationPanel.setOpaque(false);
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle");
        this.tableGenerationLabel.setText(resourceBundle2.getString("LBL_TableGeneration"));
        this.buttonGroup2.add(this.ddCreate);
        this.ddCreate.setText(resourceBundle2.getString("LBL_Create"));
        this.ddCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddCreate.setOpaque(false);
        this.buttonGroup2.add(this.ddDropCreate);
        this.ddDropCreate.setText(resourceBundle2.getString("LBL_DropCreate"));
        this.ddDropCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddDropCreate.setOpaque(false);
        this.buttonGroup2.add(this.ddUnknown);
        this.ddUnknown.setText(resourceBundle2.getString("LBL_None"));
        this.ddUnknown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddUnknown.setOpaque(false);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.tableGenerationPanel);
        this.tableGenerationPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.tableGenerationLabel).addPreferredGap(0).add((Component)this.ddCreate).addPreferredGap(0).add((Component)this.ddDropCreate).addPreferredGap(0).add((Component)this.ddUnknown).addContainerGap(381, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.ddCreate, -1, -1, Short.MAX_VALUE).add((Component)this.ddDropCreate).add((Component)this.ddUnknown).add((Component)this.tableGenerationLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.includeAllPanel.setOpaque(false);
        this.includeAllEntities.setText(resourceBundle2.getString("LBL_IncludeAllEntities"));
        this.includeAllEntities.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.includeAllEntities.setOpaque(false);
        this.includeAllEntities.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.includeAllEntitiesActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout5 = new GroupLayout((Container)this.includeAllPanel);
        this.includeAllPanel.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.includeAllEntities).addContainerGap(504, Short.MAX_VALUE)));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.includeAllEntities).addContainerGap(-1, Short.MAX_VALUE)));
        this.entityClassesPanel.setOpaque(false);
        this.entityScrollPane.setViewportView(this.entityList);
        this.addClassButton.setText(resourceBundle2.getString("LBL_AddClasses"));
        this.addClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.addClassButtonActionPerformed(actionEvent);
            }
        });
        this.removeClassButton.setText(resourceBundle2.getString("LBL_RemoveClass"));
        this.removeClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.removeClassButtonActionPerformed(actionEvent);
            }
        });
        this.includeEntitiesLabel.setText(resourceBundle2.getString("LBL_IncludeEntityClasses"));
        GroupLayout groupLayout6 = new GroupLayout((Container)this.entityClassesPanel);
        this.entityClassesPanel.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.entityScrollPane, -2, 449, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((Component)this.removeClassButton, -1, 125, Short.MAX_VALUE).add((Component)this.addClassButton, -1, 125, Short.MAX_VALUE)).add(20, 20, 20)).add(2, (Component)this.includeEntitiesLabel, -1, 600, Short.MAX_VALUE)).addContainerGap()));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.includeEntitiesLabel, -1, 17, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.addClassButton, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.removeClassButton, -1, -1, Short.MAX_VALUE).add(44, 44, 44)).add((Component)this.entityScrollPane, -2, 96, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout7 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout7.createSequentialGroup().add((GroupLayout.Group)groupLayout7.createParallelGroup(2).add(1, (Component)this.providerPanel, -1, 729, Short.MAX_VALUE).add(1, (Component)this.includeAllPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.tableGenerationPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.namePanel, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)this.entityClassesPanel, -2, -1, -2))).addContainerGap()));
        groupLayout7.setVerticalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add((GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)this.namePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.providerPanel, -1, 98, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.tableGenerationPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.includeAllPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.entityClassesPanel, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void removeClassButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        for (Object object : objectArray = this.entityList.getSelectedValues()) {
            this.dObj.removeClass(this.persistenceUnit, (String)object);
            ((DefaultListModel)this.entityList.getModel()).removeElement(object);
        }
    }

    private void addClassButtonActionPerformed(ActionEvent actionEvent) {
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)this.dObj.getPrimaryFile());
        if (entityClassScope == null) {
            return;
        }
        String[] stringArray = this.persistenceUnit.getClass2();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        List<String> list = AddEntityDialog.open(entityClassScope, hashSet);
        for (String string : list) {
            if (!this.dObj.addClass(this.persistenceUnit, string)) continue;
            ((DefaultListModel)this.entityList.getModel()).addElement(string);
        }
    }

    private void libraryComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void includeAllEntitiesActionPerformed(ActionEvent actionEvent) {
        this.initEntityListControls();
    }
}

