/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.Strings;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.xml.multiview.Error;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceValidator {
    private final PUDataObject puDataObject;
    private List<Error> errors = new ArrayList<Error>();

    public PersistenceValidator(PUDataObject pUDataObject) {
        this.puDataObject = pUDataObject;
    }

    public List<Error> validate() {
        this.validateName();
        this.validateExcludeUnlisted();
        this.validateJarFiles();
        return this.errors;
    }

    private void validateName() {
        PersistenceUnit[] persistenceUnitArray = this.puDataObject.getPersistence().getPersistenceUnit();
        for (int i = 0; i < persistenceUnitArray.length; ++i) {
            String string = persistenceUnitArray[i].getName();
            if (Strings.isEmpty((String)string)) {
                Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)persistenceUnitArray[i], "name");
                this.errors.add(new Error(2, "name", errorLocation));
            }
            for (int j = 0; j < persistenceUnitArray.length; ++j) {
                String string2 = persistenceUnitArray[j].getName();
                if (Strings.isEmpty((String)string) || i == j || !string.equals(string2)) continue;
                Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)persistenceUnitArray[i], "name");
                this.errors.add(new Error(0, 3, string, errorLocation));
            }
        }
    }

    private void validateExcludeUnlisted() {
        if (!this.isJavaSE()) {
            return;
        }
        PersistenceUnit[] persistenceUnitArray = this.puDataObject.getPersistence().getPersistenceUnit();
        for (int i = 0; i < persistenceUnitArray.length; ++i) {
            if (!persistenceUnitArray[i].isExcludeUnlistedClasses()) continue;
            Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)persistenceUnitArray[i], "exclude-unlisted-classes");
            this.errors.add(new Error(0, 1, "exclude-unlisted-classes property is not supported in Java SE environments", errorLocation));
        }
    }

    private void validateJarFiles() {
        if (!this.isJavaSE()) {
            return;
        }
        PersistenceUnit[] persistenceUnitArray = this.puDataObject.getPersistence().getPersistenceUnit();
        for (int i = 0; i < persistenceUnitArray.length; ++i) {
            if (persistenceUnitArray[i].getJarFile() == null || persistenceUnitArray[i].getJarFile().length <= 0) continue;
            Error.ErrorLocation errorLocation = new Error.ErrorLocation((Object)persistenceUnitArray[i], "jar-files");
            this.errors.add(new Error(0, 1, "jar-files property is not supported in Java SE environments", errorLocation));
        }
    }

    protected boolean isJavaSE() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.puDataObject.getPrimaryFile());
        return Util.isJavaSE(project);
    }
}

