/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.style;

import com.jaspersoft.ireport.designer.utils.ColorSchemaGenerator;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;

public class TableStylePreview
extends JPanel {
    private Color color = Color.BLUE;
    private Color borderColor = Color.BLACK;
    private String variant = "soft";
    private int borderType = 0;
    private boolean zebra = false;

    public TableStylePreview() {
        this.initComponents();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 225, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 229, Short.MAX_VALUE));
    }

    public void paint(Graphics g) {
        int i;
        super.paint(g);
        int y = 5;
        int x = 5;
        int w = this.getWidth() - 10;
        int h = this.getHeight() - 10;
        int rowHeight = h / 7;
        Rectangle row_bounds = new Rectangle(x, y + rowHeight * 2, w, rowHeight);
        g.setColor(Color.WHITE);
        ((Graphics2D)g).fill(row_bounds);
        Color c = null;
        row_bounds = new Rectangle(x, y + rowHeight * 3, w, rowHeight);
        g.setColor(Color.WHITE);
        if (this.isZebra()) {
            c = ColorSchemaGenerator.createColor((Color)this.getColor(), (int)2, (String)this.getVariant());
            c = ColorSchemaGenerator.overlayWhite((Color)c);
            c = ColorSchemaGenerator.overlayWhite((Color)c);
            g.setColor(c);
        }
        ((Graphics2D)g).fill(row_bounds);
        row_bounds = new Rectangle(x, y + rowHeight * 4, w, rowHeight);
        g.setColor(Color.WHITE);
        ((Graphics2D)g).fill(row_bounds);
        row_bounds = new Rectangle(x, y + rowHeight * 0, w, rowHeight);
        c = ColorSchemaGenerator.createColor((Color)this.getColor(), (int)3, (String)this.getVariant());
        g.setColor(c);
        ((Graphics2D)g).fill(row_bounds);
        row_bounds = new Rectangle(x, y + rowHeight * 6, w, rowHeight);
        g.setColor(c);
        ((Graphics2D)g).fill(row_bounds);
        row_bounds = new Rectangle(x, y + rowHeight * 1, w, rowHeight);
        c = ColorSchemaGenerator.createColor((Color)this.getColor(), (int)2, (String)this.getVariant());
        g.setColor(c);
        ((Graphics2D)g).fill(row_bounds);
        row_bounds = new Rectangle(x, y + rowHeight * 5, w, rowHeight);
        g.setColor(c);
        ((Graphics2D)g).fill(row_bounds);
        g.setColor(this.getBorderColor());
        for (i = 0; i < 8; ++i) {
            ((Graphics2D)g).drawLine(x, y + rowHeight * i, x + w, y + rowHeight * i);
        }
        h = rowHeight * 7;
        if (this.getBorderType() == 0) {
            for (i = 0; i < 3; ++i) {
                ((Graphics2D)g).drawLine(x + i * (w / 3), y, x + i * (w / 3), y + h);
            }
            ((Graphics2D)g).drawLine(x + w, y, x + w, y + h - 1);
        }
        if (this.getBorderType() == 2) {
            ((Graphics2D)g).drawLine(x, y, x, y + h);
            ((Graphics2D)g).drawLine(x + w, y, x + w, y + h - 1);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
        this.repaint();
    }

    public int getBorderType() {
        return this.borderType;
    }

    public void setBorderType(int borderType) {
        this.borderType = borderType;
        this.repaint();
    }

    public boolean isZebra() {
        return this.zebra;
    }

    public void setZebra(boolean zebra) {
        this.repaint();
        this.zebra = zebra;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }
}

