/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import mondrian.spi.Dialect;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class InlineTableTest
extends FoodMartTestCase {
    public InlineTableTest(String name) {
        super(name);
    }

    public void testInlineTable() {
        String cubeName = "Sales_inline";
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales_inline\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <Dimension name=\"Alternative Promotion\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"promo_id\">\n      <InlineTable alias=\"alt_promotion\">\n        <ColumnDefs>\n          <ColumnDef name=\"promo_id\" type=\"Numeric\"/>\n          <ColumnDef name=\"promo_name\" type=\"String\"/>\n        </ColumnDefs>\n        <Rows>\n          <Row>\n            <Value column=\"promo_id\">0</Value>\n            <Value column=\"promo_name\">Promo0</Value>\n          </Row>\n          <Row>\n            <Value column=\"promo_id\">1</Value>\n            <Value column=\"promo_name\">Promo1</Value>\n          </Row>\n        </Rows>\n      </InlineTable>\n      <Level name=\"Alternative Promotion\" column=\"promo_id\" nameColumn=\"promo_name\" uniqueMembers=\"true\"/> \n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[Alternative Promotion].[All Alternative Promotions].children} ON COLUMNS\nfrom [Sales_inline] ", InlineTableTest.fold("Axis #0:\n{}\nAxis #1:\n{[Alternative Promotion].[All Alternative Promotions].[Promo0]}\n{[Alternative Promotion].[All Alternative Promotions].[Promo1]}\nRow #0: 195,448\nRow #0: \n"));
    }

    public void testInlineTableInSharedDim() {
        String cubeName = "Sales_inline_shared";
        TestContext testContext = TestContext.create(null, "  <Dimension name=\"Shared Alternative Promotion\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"promo_id\">\n      <InlineTable alias=\"alt_promotion\">\n        <ColumnDefs>\n          <ColumnDef name=\"promo_id\" type=\"Numeric\"/>\n          <ColumnDef name=\"promo_name\" type=\"String\"/>\n        </ColumnDefs>\n        <Rows>\n          <Row>\n            <Value column=\"promo_id\">0</Value>\n            <Value column=\"promo_name\">First promo</Value>\n          </Row>\n          <Row>\n            <Value column=\"promo_id\">1</Value>\n            <Value column=\"promo_name\">Second promo</Value>\n          </Row>\n        </Rows>\n      </InlineTable>\n      <Level name=\"Alternative Promotion\" column=\"promo_id\" nameColumn=\"promo_name\" uniqueMembers=\"true\"/> \n    </Hierarchy>\n  </Dimension>\n<Cube name=\"Sales_inline_shared\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <DimensionUsage name=\"Shared Alternative Promotion\" source=\"Shared Alternative Promotion\" foreignKey=\"promotion_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[Shared Alternative Promotion].[All Shared Alternative Promotions].children} ON COLUMNS\nfrom [Sales_inline_shared] ", InlineTableTest.fold("Axis #0:\n{}\nAxis #1:\n{[Shared Alternative Promotion].[All Shared Alternative Promotions].[First promo]}\n{[Shared Alternative Promotion].[All Shared Alternative Promotions].[Second promo]}\nRow #0: 195,448\nRow #0: \n"));
    }

    public void testInlineTableSnowflake() {
        if (this.getTestContext().getDialect().getDatabaseProduct() == Dialect.DatabaseProduct.INFOBRIGHT) {
            return;
        }
        String cubeName = "Sales_inline_snowflake";
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales_inline_snowflake\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <Dimension name=\"Store\" foreignKeyTable=\"store\" foreignKey=\"store_id\">\n    <Hierarchy hasAll=\"true\" primaryKeyTable=\"store\" primaryKey=\"store_id\">\n      <Join leftKey=\"store_country\" rightKey=\"nation_name\">\n      <Table name=\"store\"/>\n        <InlineTable alias=\"nation\">\n          <ColumnDefs>\n            <ColumnDef name=\"nation_name\" type=\"String\"/>\n            <ColumnDef name=\"nation_shortcode\" type=\"String\"/>\n          </ColumnDefs>\n          <Rows>\n            <Row>\n              <Value column=\"nation_name\">USA</Value>\n              <Value column=\"nation_shortcode\">US</Value>\n            </Row>\n            <Row>\n              <Value column=\"nation_name\">Mexico</Value>\n              <Value column=\"nation_shortcode\">MX</Value>\n            </Row>\n            <Row>\n              <Value column=\"nation_name\">Canada</Value>\n              <Value column=\"nation_shortcode\">CA</Value>\n            </Row>\n          </Rows>\n        </InlineTable>\n      </Join>\n      <Level name=\"Store Country\" table=\"nation\" column=\"nation_name\" nameColumn=\"nation_shortcode\" uniqueMembers=\"true\"/>\n      <Level name=\"Store State\" table=\"store\" column=\"store_state\" uniqueMembers=\"true\"/>\n      <Level name=\"Store City\" table=\"store\" column=\"store_city\" uniqueMembers=\"false\"/>\n      <Level name=\"Store Name\" table=\"store\" column=\"store_name\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[Store].children} ON COLUMNS\nfrom [Sales_inline_snowflake] ", InlineTableTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[CA]}\n{[Store].[All Stores].[MX]}\n{[Store].[All Stores].[US]}\nRow #0: \nRow #0: \nRow #0: 266,773\n"));
    }

    public void testInlineTableDate() {
        String cubeName = "Sales_Inline_Date";
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales_Inline_Date\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <Dimension name=\"Alternative Promotion\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"id\">\n        <InlineTable alias=\"inline_promo\">\n          <ColumnDefs>\n            <ColumnDef name=\"id\" type=\"Numeric\"/>\n            <ColumnDef name=\"date\" type=\"Date\"/>\n          </ColumnDefs>\n          <Rows>\n            <Row>\n              <Value column=\"id\">1</Value>\n              <Value column=\"date\">2008-04-29</Value>\n            </Row>\n            <Row>\n              <Value column=\"id\">2</Value>\n              <Value column=\"date\">2007-01-20</Value>\n            </Row>\n          </Rows>\n        </InlineTable>\n      <Level name=\"Alternative Promotion\" column=\"id\" nameColumn=\"date\" uniqueMembers=\"true\"/> \n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        Dialect dialect = testContext.getDialect();
        String extra = dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ACCESS ? " 00:00:00.0" : "";
        testContext.assertQueryReturns("select {[Alternative Promotion].Members} ON COLUMNS\nfrom [Sales_Inline_Date] ", InlineTableTest.fold("Axis #0:\n{}\nAxis #1:\n{[Alternative Promotion].[All Alternative Promotions]}\n{[Alternative Promotion].[All Alternative Promotions].[2008-04-29" + extra + "]}\n" + "{[Alternative Promotion].[All Alternative Promotions].[2007-01-20" + extra + "]}\n" + "Row #0: 266,773\n" + "Row #0: \n" + "Row #0: \n"));
    }
}

