﻿using System;
using System.IO;
using Sirkadirov.Overtest.SharedLibraries.Shared;

namespace Sirkadirov.Overtest.TestingAgent.Services.Storage
{
    public class TempDataDirectoryOperator : IDisposable
    {
        public string ParentDirectoryFullName { get; }
        public string TempDirectoryFullName { get; private set; }

        public TempDataDirectoryOperator(string tempDirectoryFullName)
        {
            ParentDirectoryFullName = tempDirectoryFullName;
            InitializeDirectory();
        }

        private void InitializeDirectory()
        {
            TempDirectoryFullName = Path.Combine(ParentDirectoryFullName, Guid.NewGuid().ToString());
            Directory.CreateDirectory(TempDirectoryFullName); // TODO: Recreate directory in a safe way
        }

        public void Dispose()
        {
            FileSystemSharedMethods.SecureDeleteDirectory(TempDirectoryFullName);
        }
    }
}