﻿using System;
using System.IO;
using Sirkadirov.Overtest.SharedLibraries.Shared;

namespace Sirkadirov.Overtest.TestingAgent.Services.Storage
{
    public class TempDirectoryAccessPoint : IDisposable
    {
        public string DirectoryFullName { get; }

        public TempDirectoryAccessPoint(string path, bool recursiveCreateDirectories = true, bool throwIfAlreadyExists = true)
        {
            DirectoryFullName = path;

            if (recursiveCreateDirectories)
            {
                if (throwIfAlreadyExists && Directory.Exists(DirectoryFullName))
                    throw new Exception();
                
                Directory.CreateDirectory(path);
            }
        }
        
        public void Dispose()
        {
            FileSystemSharedMethods.SecureDeleteDirectory(DirectoryFullName);
        }
    }
}