﻿using System.Linq;
using Microsoft.Extensions.Configuration;
using Sirkadirov.Overtest.SharedLibraries.Database.Storage.TestingApplications;
using Sirkadirov.Overtest.TestingAgent.Libraries.ProgramCompilationAgent;

namespace Sirkadirov.Overtest.TestingAgent.TestingServices.VerificationStages
{
    public class UserProgramCompilationStage
    {
        private readonly IConfiguration _configuration;
        private readonly TestingApplication _testingApplication;
        private readonly CompilationAgent _compilationAgent;
        private readonly string _sourceCodeDirectoryPath;

        public UserProgramCompilationStage(IConfiguration configuration, TestingApplication testingApplication, CompilationAgent compilationAgent, string sourceCodeDirectoryPath)
        {
            _configuration = configuration;
            _testingApplication = testingApplication;
            _compilationAgent = compilationAgent;
            _sourceCodeDirectoryPath = sourceCodeDirectoryPath;
        }

        public (bool isSuccessful, string compilerOutput, OvertestProgramCompilationPluginBase compilationPlugin) Execute()
        {
            var compilerConfiguration = _configuration
                .GetSection("compilers").GetChildren()
                .First(c => c.GetValue<string>("id") == _testingApplication.SourceCode.ProgrammingLanguageId.ToString());
            
            var compilationPlugin = _compilationAgent.GetCompilationPluginInstance(
                compilerConfiguration.GetValue<string>("plugin"),
                compilerConfiguration,
                _sourceCodeDirectoryPath
            );
            
            compilationPlugin.CreateSourceCodeFile(_testingApplication.SourceCode.SourceCode);
            var (isSuccessful, compilerOutput) = compilationPlugin.Execute();
            
            return (isSuccessful, compilerOutput, compilationPlugin);
        }
    }
}