﻿using System;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Extensions.Configuration;
using Sirkadirov.Overtest.SharedLibraries.Database;
using Sirkadirov.Overtest.SharedLibraries.Database.Storage.TestingApplications;
using Sirkadirov.Overtest.SharedLibraries.Shared.TestingApplications;
using Sirkadirov.Overtest.TestingAgent.Libraries.ProgramCompilationAgent;
using Sirkadirov.Overtest.TestingAgent.Services.Storage;
using Sirkadirov.Overtest.TestingAgent.TestingServices.Skeleton;
using Sirkadirov.Overtest.TestingAgent.TestingServices.VerificationStages.TestingType;

namespace Sirkadirov.Overtest.TestingAgent.TestingServices.VerificationStages
{
    public class UserSolutionTestingStage : VerificationStageBase
    {
        public UserSolutionTestingStage(
            IConfiguration configuration, OvertestDatabaseContext databaseContext,
            TestingApplication testingApplication,
            TempDirectoryAccessPoint testingDataAccessor, TestingDataConfiguration testingDataConfiguration,
            TempDataDirectoryOperator userProgramTempDirectory,
            OvertestProgramCompilationPluginBase userProgramCompilationPlugin
        ) : base(configuration, databaseContext, testingApplication, testingDataAccessor, testingDataConfiguration,
            userProgramTempDirectory, userProgramCompilationPlugin) {  }

        public override async Task ExecuteAsync()
        {
            /*
             * If tests list is empty, then solution
             * ajudgement will be "CompleteSolution"
             * (for backward compatibility).
             */
            
            if (TestingApplication.TestingType == TestingApplication.ApplicationTestingType.ReleaseMode && !TestingDataConfiguration.Verification.Tests.Any())
            {
                TestingApplication.TestingResult.GivenDifficulty = TestingApplication.ProgrammingTask.Difficulty;
                TestingApplication.TestingResult.SolutionAdjudgement = TestingApplicationResult.SolutionAdjudgementType.CompleteSolution;
                TestingApplication.TestingResult.RawTestingResults = nameof(TestingApplicationResult.SolutionAdjudgementType.CompleteSolution);
            }
            
            /*
             * Now we need to execute the next testing stage,
             * according to the "TestingType" of the user's
             * solution we operate.
             */
            
            // For performance reasons
            VerificationStageBase nextTestingStage;
            
            switch (TestingApplication.TestingType)
            {
                // Debug testing mode
                case TestingApplication.ApplicationTestingType.DebugMode:
                    // TODO!
                    nextTestingStage = new SolutionReleaseTestingStage(
                        Configuration, DatabaseContext,
                        TestingApplication, TestingDataAccessor, TestingDataConfiguration,
                        UserProgramTempDirectory, UserProgramCompilationPlugin
                    );
                    TestingApplication.TestingResult.RawTestingResults = "Not implemented!";
                    break;
                
                // Release testing mode
                case TestingApplication.ApplicationTestingType.ReleaseMode:
                    nextTestingStage = new SolutionReleaseTestingStage(
                        Configuration, DatabaseContext,
                        TestingApplication, TestingDataAccessor, TestingDataConfiguration,
                        UserProgramTempDirectory, UserProgramCompilationPlugin
                    );
                    break;
                
                // Reservation for future
                default:
                    throw new ApplicationException("Unknown application testing type!");
            }
            
            // Executing the next stage of the verification process
            await nextTestingStage.ExecuteAsync();
        }
    }
}