﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Extensions.Configuration;
using Sirkadirov.Overtest.TestingAgent.Libraries.ProgramCompilationAgent.DefaultCompilers;

namespace Sirkadirov.Overtest.TestingAgent.Libraries.ProgramCompilationAgent
{
    public class CompilationAgent
    {
        public List<Type> CompilationPlugins { get; private set; }
        public string PluginsLookupPath { get; }

        public CompilationAgent(string pluginsLookupPath)
        {
            PluginsLookupPath = pluginsLookupPath;
        }

        public void LookupCompilerPlugins()
        {
            // Initialize a list and add system-implemented compiler plugins
            CompilationPlugins = new List<Type>
            {
                typeof(DefaultCompiler)
            };
            
            // TODO: Lookup by directory files and .NET Reflections
        }
        
        public OvertestProgramCompilationPluginBase GetCompilationPluginInstance(string pluginName, IConfiguration compilerConfiguration, string sourceCodeDirectoryFullPath)
        {
            return (OvertestProgramCompilationPluginBase) Activator.CreateInstance(
                CompilationPlugins.First(p => p.Name == pluginName),
                compilerConfiguration,
                sourceCodeDirectoryFullPath
            );
        }
    }
}