﻿using System;
using System.Diagnostics;

namespace Sirkadirov.Overtest.TestingAgent.Libraries.ProgramCompilationAgent
{
    public static class CompilationMethods
    {
        public static (int exitCode, string stdOutput, string stdErrorOutput) ExecuteCompiler(string compilerFullName, string compilerArguments, string workingDirectory)
        {
            if (string.IsNullOrWhiteSpace(compilerFullName))
                throw new ArgumentNullException(nameof(compilerFullName));
            
            if (compilerArguments == null)
                throw new ArgumentNullException(nameof(compilerArguments));
            
            if (workingDirectory == null)
                throw new ArgumentNullException(nameof(workingDirectory));
            
            try
            {
                var cplProc = new Process
                {
                    StartInfo = new ProcessStartInfo
                    {
                        FileName = compilerFullName,
                        Arguments = compilerArguments,
                        WorkingDirectory = workingDirectory,
                        
                        ErrorDialog = false,
                        WindowStyle = ProcessWindowStyle.Minimized,
                        RedirectStandardOutput = true,
                        RedirectStandardError = true,
                        UseShellExecute = false
                    }
                };
                
                cplProc.Start();
                cplProc.WaitForExit();
                
                var standartOutput = cplProc.StandardOutput.ReadToEnd();
                var standartError = cplProc.StandardError.ReadToEnd();
                
                return (
                    exitCode: cplProc.ExitCode,
                    stdOutput: standartOutput,
                    stdErrorOutput: standartError
                );
            }
            catch (Exception ex)
            {
                return (
                    exitCode: -1,
                    stdOutput: (new ApplicationException("An exception catched while trying to compile the program!", ex)).ToString(),
                    stdErrorOutput: string.Empty
                );
            }
        }
    }
}