﻿using System;
using System.IO;
using Microsoft.Extensions.Configuration;

namespace Sirkadirov.Overtest.TestingAgent.Libraries.ProgramCompilationAgent.DefaultCompilers
{
    public class DefaultCompiler : OvertestProgramCompilationPluginBase
    {
        public DefaultCompiler(IConfiguration compilerConfiguration, string sourceCodeDirectoryFullPath)
            : base(compilerConfiguration, sourceCodeDirectoryFullPath) { /* Nothing to do */ }
        
        public override (bool isSuccessful, string compilerOutput) Execute()
        {
            var compilerConfiguration = CompilerConfiguration.GetSection("compiler");
            
            var (compilerExitCode, compilerOutput, compilerErrorOutput) = CompilationMethods.ExecuteCompiler(
                compilerConfiguration.GetValue<string>("path"),
                compilerConfiguration.GetValue<string>("arguments")
                    .Replace("{%filename%}", GetCompilationSourceFileName())
                    .Replace("{%output_filename%}", GetCompilationOutputFileName()),
                SourceCodeDirectoryFullPath
            );
            
            return (
                isSuccessful: File.Exists(Path.Combine(SourceCodeDirectoryFullPath, GetCompilationOutputFileName())),
                compilerOutput: FormatCompilerOutput(compilerOutput, compilerErrorOutput, compilerExitCode)
            );
            
            string FormatCompilerOutput(string standardOutput, string errorOutput, int exitCode)
            {
                string formattedOutput;
                
                if (string.IsNullOrWhiteSpace(standardOutput))
                    formattedOutput = "Overtest Testing Agent on " +
                                      Environment.OSVersion +
                                      Environment.NewLine +
                                      "No compiler output defined!";
                else
                    formattedOutput = standardOutput;

                if (!string.IsNullOrWhiteSpace(errorOutput))
                    formattedOutput += Environment.NewLine + Environment.NewLine + errorOutput;
                
                formattedOutput += Environment.NewLine + $"Compiler process exited with code: {exitCode}";
                //formattedOutput += string.Join(", ", Directory.GetFiles(SourceCodeDirectoryFullPath));
                
                return formattedOutput;
            }
        }
    }
}