﻿using System.IO;
using Microsoft.Extensions.Configuration;

namespace Sirkadirov.Overtest.TestingAgent.Libraries.ProgramCompilationAgent
{
    public abstract class OvertestProgramCompilationPluginBase
    {
        protected readonly IConfiguration CompilerConfiguration;
        public string SourceCodeDirectoryFullPath { get; }
        
        protected OvertestProgramCompilationPluginBase(IConfiguration compilerConfiguration, string sourceCodeDirectoryFullPath)
        {
            SourceCodeDirectoryFullPath = sourceCodeDirectoryFullPath;
            CompilerConfiguration = compilerConfiguration;
        }
        
        public virtual void CreateSourceCodeFile(byte[] rawSource)
        {
            File.WriteAllBytes(Path.Combine(SourceCodeDirectoryFullPath, GetCompilationSourceFileName()), rawSource);
        }

        public virtual string GetCompilationSourceFileName()
        {
            return CompilerConfiguration.GetSection("filenames").GetValue<string>("source");
        }
        
        public virtual string GetCompilationOutputFileName()
        {
            return CompilerConfiguration.GetSection("filenames").GetValue<string>("output");
        }
        
        public abstract (bool isSuccessful, string compilerOutput) Execute();
        
        public virtual (string fullName, string arguments) GetProgramExecutionArguments(string executableFullName, string executionArguments)
        {
            var executorConfiguration = CompilerConfiguration.GetSection("executor");

            if (!executorConfiguration.Exists())
                return (fullName: executableFullName, arguments: executionArguments);
            
            var newExecutableFullName = executorConfiguration.GetValue<string>("path").Replace("{%filename%}", executableFullName);
            var newExecutionArguments = executorConfiguration.GetValue<string>("arguments")
                .Replace("{%filename%}", executableFullName)
                .Replace("{%arguments%}", executionArguments);
            
            return (fullName: newExecutableFullName, arguments: newExecutionArguments);
        }
    }
}