﻿namespace Sirkadirov.Overtest.TestingAgent.Libraries.ProgramExecutor.DataStructures
{
    public class ProgramExecutionRequest
    {
        public abstract class ProgramFeature
        {
            public bool Enabled { get; set; } = false;
        }
        
        public ProgramStartInformation StartInformation { get; set; }
        
        public class ProgramStartInformation
        {
            public string Path { get; set; }
            public string Arguments { get; set; }
            public string WorkingDirectory { get; set; }
        }
        
        public ProgramRunAsFeature RunAsFeature { get; set; }
        
        public class ProgramRunAsFeature : ProgramFeature
        {
            public string UserName { get; set; }
            public string UserPasswordClearText { get; set; }
            public string UserDomain { get; set; }
        }
        
        public ProgramRuntimeLimitsFeature RuntimeLimitsFeature { get; set; }
        
        public class ProgramRuntimeLimitsFeature : ProgramFeature
        {
            public RuntimeLimit<long> ProcessorTimeLimit { get; set; }
            public RuntimeLimit<int> RealTimeLimit { get; set; }
            
            public RuntimeLimit<long> MemoryUsageLimit { get; set; }
            //public RuntimeLimit<long> DiskSpaceUsageLimit { get; set; } // TODO: For a future use
            
            //public RuntimeLimit<int> StdOutLengthLimit { get; set; } // TODO: For a future use

            public class RuntimeLimit<T>
            {
                public bool Enabled { get; set; } = false;
                public T Limit { get; set; }
            }
        }
        
        public ProgramStandardStreamsRedirectionOptions StandardStreamsRedirectionOptions { get; set; }
        
        public class ProgramStandardStreamsRedirectionOptions
        {
            public string InputSourceFilePath { get; set; } = null;
            public string OutputRedirectionFileName { get; set; } = null;
        }
    }
}