﻿namespace Sirkadirov.Overtest.TestingAgent.Libraries.ProgramExecutor.DataStructures
{
    public class ProgramExecutionResult
    {
        public ProgramExecutionResult()
        {
            RuntimeResourcesUsage = new ProgramRuntimeResourcesUsage();
        }
        
        public ExecutionResultType Result { get; set; } = ExecutionResultType.Unset;
        
        public ProgramRuntimeResourcesUsage RuntimeResourcesUsage { get; set; }
        
        public int ProcessExitCode { get; set; }

        public string StandardOutputData { get; set; }
        public string StandardErrorData { get; set; }

        public enum ExecutionResultType
        {
            RuntimeError = -1,
            UsedProcessorTimeLimitReached = -2,
            RealExecutionTimeLimitReached = -3,
            WorkingSetLimitReached = -4,
            DiskSpaceUsageLimitReached = -5,
            StandardOutputLengthLimitReached = -6,
            
            Unset = 0,
            Successful = 100
        }
        
        public class ProgramRuntimeResourcesUsage
        {
            public long ProcessorTime { get; set; } = 0;
            public long RealExecutionTime { get; set; } = 0;

            public long PeakMemoryUsage { get; set; } = 0;
            public long DiskSpaceUsage { get; set; } = 0;
        }
    }
}