﻿using System.Collections.Generic;

namespace Sirkadirov.Overtest.SharedLibraries.Shared.TestingApplications
{
    public class SolutionReleaseVerificationDetailedResult
    {
        public SolutionReleaseVerificationDetailedResult()
        {
            TestingParticles = new List<TestingParticleResult>();
        }
        
        public List<TestingParticleResult> TestingParticles { get; set; }
        
        public class TestingParticleResult
        {
            public string TestTitle { get; set; }
            
            public int ExitCode { get; set; }
            
            public long ProcessorTimeUsed { get; set; }
            public long ProcessorTimeLimit { get; set; }
            
            public long WorkingSetUsed { get; set; }
            public long WorkingSetLimit { get; set; }
            
            public long DiskSpaceUsed { get; set; }
            public long DiskSpaceLimit { get; set; }
            
            public long RealExecutionTimeUsed { get; set; }
            public long RealExecutionTimeLimit { get; set; }

            public VerdictType Verdict { get; set; } = VerdictType.VerificationFailed;

            public enum VerdictType
            {
                VerificationFailed = -100, // System reserved
                ProcessorTimeLimitReached = -4,
                WorkingSetLimitReached = -3,
                DiskSpaceLimitReached = -2,
                RuntimeError = -1,
                IdlingTimeout = 0,
                WrongAnswer = 1,
                WrongOutputFormat = 2,
                Successful = 100
            }
        }
    }
}