﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using Newtonsoft.Json;

namespace Sirkadirov.Overtest.SharedLibraries.Shared.TestingApplications
{
    public class TestingDataConfiguration
    {
        [JsonProperty("$schema_version")]
        public int SchemaVersion { get; set; }
        
        [JsonProperty("verification")]
        public VerificationStruct Verification { get; set; }
        
        public struct VerificationStruct
        {
            [JsonProperty("author_solution")]
            public AuthorSolutionStruct AuthorSolution { get; set; }
            
            [JsonProperty("testlib")]
            public TestLibStruct TestLib { get; set; }
            
            [JsonProperty("tests")]
            public List<TestInfoStruct> Tests { get; set; }

            public struct AuthorSolutionStruct
            {
                [JsonProperty("programming_language_id")]
                public Guid ProgrammingLanguageId { get; set; }
                
                [JsonProperty("source_code_path")]
                public string SourceCodePath { get; set; }
            }
            
            public struct TestLibStruct
            {
                [JsonProperty("initializer"), DefaultValue(null)]
                public string InitializerPath { get; set; }
                [JsonProperty("finalizer"), DefaultValue(null)]
                public string FinalizerPath { get; set; }
                
                [JsonProperty("generator"), DefaultValue(null)]
                public string GeneratorPath { get; set; }
                [JsonProperty("checker"), DefaultValue(null)]
                public string CheckerPath { get; set; }
                
                [JsonProperty("default_input_filename"), DefaultValue("input.dat")]
                public string DefaultInputFileName { get; set; }
                [JsonProperty("default_output_filename"), DefaultValue("output.dat")]
                public string DefaultOutputFileName { get; set; }
            }

            public struct TestInfoStruct
            {
                [JsonProperty("title"), DefaultValue(null)]
                public string Title { get; set; }
                
                [JsonProperty("input")]
                public InputInfoStruct InputInfo { get; set; }
                
                [JsonProperty("output")]
                public OutputInfoStruct OutputInfo { get; set; }
                
                [JsonProperty("runtime_limits")]
                public RuntimeLimitsStruct RuntimeLimits { get; set; }

                public struct InputInfoStruct
                {
                    [JsonProperty("use_generator"), DefaultValue(false)]
                    public bool UseGenerator { get; set; }
                    
                    [JsonProperty("raw_file_path"), DefaultValue(null)]
                    public string RawFilePath { get; set; }
                }
                
                public struct OutputInfoStruct
                {
                    [JsonProperty("use_checker"), DefaultValue(false)]
                    public bool UseChecker { get; set; }
                    
                    [JsonProperty("raw_file_path"), DefaultValue(null)]
                    public string RawFilePath { get; set; }
                }
                
                public struct RuntimeLimitsStruct
                {
                    [JsonProperty("max_real_time"), DefaultValue(null)]
                    public int MaxRealTime { get; set; }
                    
                    [JsonProperty("max_processor_time"), DefaultValue(null)]
                    public long MaxProcessorTime { get; set; }
                    
                    [JsonProperty("peak_working_set"), DefaultValue(null)]
                    public long PeakWorkingSet { get; set; }
                }
            }
        }
    }
}