﻿using System;
using System.IO;
using System.Text;
using Sirkadirov.Overtest.SharedLibraries.Shared.TestingApplications;

namespace Sirkadirov.Overtest.TestingAgent.Libraries.TestLib.Default
{
    public class DefaultChecker : ISolutionOutputChecker
    {
        public SolutionReleaseVerificationDetailedResult.TestingParticleResult.VerdictType Execute(TestingDataConfiguration testingDataConfiguration, string testingDataDirectory,
            TestingDataConfiguration.VerificationStruct.TestInfoStruct currentTest, string userProgramOutputDirectoryPath, string authorProgramOutputDirectoryPath)
        {
            var userProgramOutputPath = Path.Combine(userProgramOutputDirectoryPath,
                testingDataConfiguration.Verification.TestLib.DefaultOutputFileName);
            
            var idealOutputPath = Path.Combine(testingDataDirectory, currentTest.OutputInfo.RawFilePath);
            
            if (!File.Exists(userProgramOutputPath))
                return SolutionReleaseVerificationDetailedResult.TestingParticleResult.VerdictType.WrongOutputFormat;
            
            try
            {
                var userProgramOutput = TrimOutput(File.ReadAllText(userProgramOutputPath, Encoding.UTF8));
                var idealProgramOutput = TrimOutput(File.ReadAllText(idealOutputPath, Encoding.UTF8));

                return userProgramOutput == idealProgramOutput
                    ? SolutionReleaseVerificationDetailedResult.TestingParticleResult.VerdictType.Successful
                    : SolutionReleaseVerificationDetailedResult.TestingParticleResult.VerdictType.WrongAnswer;
            }
            catch (Exception)
            {
                return SolutionReleaseVerificationDetailedResult.TestingParticleResult.VerdictType.WrongOutputFormat;
            }

            string TrimOutput(string output) => output
                .TrimEnd(' ', '\r', '\n', '\t')
                .Replace("\r", string.Empty);
        }
    }
}