﻿using System.ComponentModel.DataAnnotations;

namespace Sirkadirov.Overtest.WebApplication.Areas.Administration.Models.CuratorUsersController
{
    public class CuratorUserCreationModel
    {
        [Required, EmailAddress, DataType(DataType.EmailAddress)]
        public string Email { get; set; }
        
        [Required, DataType(DataType.Password)]
        public string Password { get; set; }
        
        [Required, DataType(DataType.Text), MinLength(3), MaxLength(255)]
        public string FullName { get; set; }
        
        [DataType(DataType.Text), MinLength(0), MaxLength(255)]
        public string InstitutionName { get; set; }
    }
}