﻿import $ from "jquery";

/*
 * NAVBAR-GLOBAL
 */

$(document).ready(function ()
{
    // Default box-shadow
    $(".navbar-global").css("box-shadow", "none");
    
    // On scroll event handler
    $(window).scroll(function ()
    {

        if ($(window).scrollTop() > 0)
        {
            // Enable shadow when necessary
            $(".navbar-global").css("box-shadow", "0 0 25px rgba(40, 47, 60, .05), 0 20px 25px rgba(40, 47, 60, .05), 0 3px 4px rgba(40, 47, 60, .05)");
        }
        else
        {
            // Otherwise, disable shadow
            $(".navbar-global").css("box-shadow", "none");
        }

    });
});

/*
 * USER NAVBAR
 */

$(document).ready(function ()
{
    let userNavbarToggler = $(".user-offcanvas-navbar-toggler");
    let userMobileNavigationPanelElement = $("#user-mobile-navigation-panel");
    let userNavigationCanvasElement = $("#user-navigation-canvas");
    let userNavigationCanvasOverlayElement = $("#user-navigation-canvas-overlay");

    // noinspection SpellCheckingInspection
    userNavbarToggler.on("click", function(e)
    {
        e.preventDefault();
        e.stopPropagation();
        executeMobileCanvasMenuToggle();
    });

    // noinspection SpellCheckingInspection
    $(userMobileNavigationPanelElement).on('swiperight', function()
    {
        if (userMobileNavigationPanelElement.css("display") === "block")
        {
            if (!userNavigationCanvasElement.hasClass("show"))
                executeMobileCanvasMenuToggle();
        }
    });

    // noinspection SpellCheckingInspection
    $(document).on('swipeleft', function()
    {
        if (userMobileNavigationPanelElement.css("display") === "block")
        {
            if (userNavigationCanvasElement.hasClass("show"))
                executeMobileCanvasMenuToggle();
        }
    });

    function executeMobileCanvasMenuToggle()
    {
        userNavigationCanvasElement.toggleClass("show");
        userNavigationCanvasElement.toggleClass("mobile-canvas-active");
        userNavigationCanvasOverlayElement.toggleClass("show");
        $("body").toggleClass("overflow-hidden");
    }
});