/*
 * Decompiled with CFR 0.152.
 */
package com.cwbp.pb;

public class Packet {
    byte[] data;
    byte[] src_ip;
    byte[] dst_ip;
    byte[] src_ip_buffer = new byte[4];
    byte[] dst_ip_buffer = new byte[4];
    private static final int IP_SRC_ADDRESS_INDEX = 12;
    private static final int IP_DST_ADDRESS_INDEX = 16;
    private static final int IP_PROTOCOL_INDEX = 9;
    public static final int IP_PROTOCOL_TCP = 6;
    public static final int IP_PROTOCOL_UDP = 17;
    private static final int SRC_PORT_INDEX = 0;
    private static final int DST_PORT_INDEX = 2;
    int src_port = -1;
    int dst_port = -1;
    int protocol = -1;
    int ip_header_length = -1;
    int protocol_header_length = -1;
    long length = -1L;

    public void setData(byte[] byArray, long l) {
        this.data = byArray;
        this.length = l;
        if (this.data != null) {
            this.dst_ip = null;
            this.src_ip = null;
            this.dst_port = -1;
            this.src_port = -1;
            this.protocol = this.data[9];
            this.ip_header_length = (this.data[0] & 0xF) * 4;
            this.protocol_header_length = -1;
        }
    }

    private void setbyte(byte[] byArray, int n) {
        if (this.data != null && this.data.length > byArray.length + n) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this.data[n + i];
            }
        }
    }

    private int getint(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 * 256 + this.bytetouint(this.data[i + n]);
        }
        return n3;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public byte[] getSrcIp() {
        if (this.src_ip == null) {
            this.setbyte(this.src_ip_buffer, 12);
            this.src_ip = this.src_ip_buffer;
        }
        return this.src_ip;
    }

    public byte[] getDstIp() {
        if (this.dst_ip == null) {
            this.setbyte(this.dst_ip_buffer, 16);
            this.dst_ip = this.dst_ip_buffer;
        }
        return this.dst_ip;
    }

    public int getSrcPort() {
        if (this.src_port < 0) {
            this.src_port = this.getint(this.ip_header_length + 0, 2);
        }
        return this.src_port;
    }

    public int getDstPort() {
        if (this.dst_port < 0) {
            this.dst_port = this.getint(this.ip_header_length + 0, 2);
        }
        return this.dst_port;
    }

    public int bytetouint(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.protocol == 17) {
            stringBuffer.append(" UDP");
        } else if (this.protocol == 6) {
            stringBuffer.append(" TCP");
        } else {
            stringBuffer.append(" proto:");
            stringBuffer.append(this.protocol);
        }
        if (this.protocol == 17 || this.protocol == 6) {
            byte[] byArray = this.getSrcIp();
            stringBuffer.append(" src:");
            stringBuffer.append(this.bytetouint(byArray[0]));
            stringBuffer.append(".");
            stringBuffer.append(this.bytetouint(byArray[1]));
            stringBuffer.append(".");
            stringBuffer.append(this.bytetouint(byArray[2]));
            stringBuffer.append(".");
            stringBuffer.append(this.bytetouint(byArray[3]));
            stringBuffer.append(":");
            stringBuffer.append(this.getSrcPort());
            byArray = this.getDstIp();
            stringBuffer.append(" dst:");
            stringBuffer.append(this.bytetouint(byArray[0]));
            stringBuffer.append(".");
            stringBuffer.append(this.bytetouint(byArray[1]));
            stringBuffer.append(".");
            stringBuffer.append(this.bytetouint(byArray[2]));
            stringBuffer.append(".");
            stringBuffer.append(this.bytetouint(byArray[3]));
            stringBuffer.append(":");
            stringBuffer.append(this.getDstPort());
        }
        return stringBuffer.toString();
    }
}

