/*
 * Decompiled with CFR 0.152.
 */
package com.cwbp.pb;

import com.cwbp.pb.ArgTable;
import com.cwbp.pb.Packet;
import com.cwbp.pb.mainThread;
import com.cwbp.pb.pbReceiver;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class pbRChannel
extends pbReceiver {
    static MidiChannel channel = null;
    private boolean playing = false;
    private static int[] vels = new int[]{64, 75, 90};
    private static int[] durs = new int[]{64, 64, 64, 128, 128, 128, 128, 256, 512, 1024};
    int vel = vels[0];
    int duration = durs[1];
    public static final int MusicBox = 10;
    public static final int TubularBells = 14;
    public static final int TinkleBell = 112;
    public static final int TelephoneRing = 124;
    static int inst = 112;
    static int basePitch = 64;
    static int widthPitch = 32;

    public void init(mainThread mainThread2, ArgTable argTable) {
        block3: {
            this.thread = mainThread2;
            try {
                Synthesizer synthesizer = MidiSystem.getSynthesizer();
                synthesizer.open();
                Soundbank soundbank = synthesizer.getDefaultSoundbank();
                Instrument[] instrumentArray = synthesizer.getDefaultSoundbank().getInstruments();
                synthesizer.loadInstrument(instrumentArray[0]);
                channel = synthesizer.getChannels()[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (channel == null) break block3;
                channel.allNotesOff();
            }
        }
        if (channel != null) {
            System.out.println("intiMIDI Channel NON null");
            return;
        }
        System.out.println("intiMIDI Channel NULL");
    }

    public void receivePacket(Packet packet) {
        try {
            this.thread.sendLog(packet.toString());
            if (this.playing || packet.data.length == 0) {
                return;
            }
            this.playing = true;
            int n = packet.data[packet.data.length / 2] % widthPitch + basePitch;
            if (packet.data.length > 0) {
                this.duration = durs[(128 + packet.data[packet.data.length / 2 + 1]) % durs.length];
            }
            if (packet.data.length > 1) {
                this.vel = vels[(128 + packet.data[packet.data.length / 2 - 1]) % vels.length];
            }
            channel.programChange(inst);
            channel.noteOn(n, this.vel);
            Thread.currentThread();
            Thread.sleep(this.duration);
            channel.noteOff(n, this.vel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.playing = false;
    }
}

